/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.entity.ai.spell;

import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import ovh.corail.tombstone.capability.SpellCasterHandler;
import ovh.corail.tombstone.entity.ai.spell.SpellUseGoal;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.registry.ModSounds;

public class HealSpellGoal
extends SpellUseGoal {
    protected final TargetingConditions healTargeting = TargetingConditions.forNonCombat().range(16.0).selector((e, serverLevel) -> e.isAlive() && e.getHealth() < e.getMaxHealth() * 0.75f && this.caster.isAlliedTo((Entity)e));

    public HealSpellGoal(PathfinderMob caster) {
        super(caster);
    }

    @Override
    public boolean canUse() {
        List entitiesToHeal;
        if (super.canUse() && !(entitiesToHeal = ((ServerLevel)this.caster.level()).getNearbyEntities(LivingEntity.class, this.healTargeting, (LivingEntity)this.caster, this.caster.getBoundingBox().inflate(16.0, 4.0, 16.0))).isEmpty()) {
            SpellCasterHandler.setSpecialTarget((LivingEntity)this.caster, (LivingEntity)entitiesToHeal.get(Helper.RANDOM.nextInt(entitiesToHeal.size())));
            return true;
        }
        return false;
    }

    @Override
    public boolean canContinueToUse() {
        return super.canContinueToUse() && SpellCasterHandler.getSpecialTarget((LivingEntity)this.caster).map(e -> e.getHealth() < e.getMaxHealth()).orElse(false) != false;
    }

    @Override
    public void tick() {
        --this.attackWarmupDelay;
        if (this.attackWarmupDelay % 5 == 0) {
            this.performSpellCasting();
        }
    }

    @Override
    public void stop() {
        if (this.attackWarmupDelay > this.getCastWarmupTime() - 5) {
            this.nextAttackTickCount = this.caster.tickCount;
        }
    }

    @Override
    protected void performSpellCasting() {
        SpellCasterHandler.getSpecialTarget((LivingEntity)this.caster).ifPresent(entity -> {
            entity.heal(1.0f);
            entity.clearFire();
            ((ServerLevel)this.caster.level()).sendParticles((ParticleOptions)ParticleTypes.HEART, entity.getRandomX(1.0), entity.getRandomY() + 0.5, entity.getRandomZ(1.0), 1, 0.0, 0.0, 0.0, 0.0);
        });
    }

    @Override
    protected int getCastWarmupTime() {
        return 50;
    }

    @Override
    protected int getCastingTime() {
        return 60;
    }

    @Override
    protected int getCastingInterval() {
        return 200;
    }

    @Override
    protected SoundEvent getSpellPrepareSound() {
        return ModSounds.magic_use01;
    }

    @Override
    protected int getSpellColor() {
        return 32768;
    }
}

