/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.entity.ai.spell;

import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.sheep.Sheep;
import net.minecraft.world.item.DyeColor;
import ovh.corail.tombstone.capability.SpellCasterHandler;
import ovh.corail.tombstone.entity.ai.spell.SpellUseGoal;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.registry.ModTriggers;

public class WololoSpellGoal
extends SpellUseGoal {
    protected final DyeColor dyeColor;
    protected final TargetingConditions wololoTargeting;

    public WololoSpellGoal(PathfinderMob caster, DyeColor dyeColor) {
        super(caster);
        this.dyeColor = dyeColor;
        this.wololoTargeting = TargetingConditions.forNonCombat().range(16.0).selector((e, serverLevel) -> ((Sheep)e).getColor() != this.dyeColor);
    }

    @Override
    public boolean canUse() {
        List list;
        if (super.canUse() && this.caster.getTarget() == null && !(list = ((ServerLevel)this.caster.level()).getNearbyEntities(Sheep.class, this.wololoTargeting, (LivingEntity)this.caster, this.caster.getBoundingBox().inflate(16.0, 4.0, 16.0))).isEmpty()) {
            SpellCasterHandler.setSpecialTarget((LivingEntity)this.caster, (LivingEntity)list.get(Helper.RANDOM.nextInt(list.size())));
            return true;
        }
        return false;
    }

    @Override
    public boolean canContinueToUse() {
        return super.canContinueToUse() && this.caster.getTarget() == null;
    }

    @Override
    protected void performSpellCasting() {
        SpellCasterHandler.getSpecialTarget((LivingEntity)this.caster).filter(Sheep.class::isInstance).map(Sheep.class::cast).ifPresent(sheep -> {
            sheep.setColor(this.dyeColor);
            EntityHelper.getServantOwner((Entity)this.caster).ifPresent(owner -> ModTriggers.wololo.get(this.dyeColor).trigger((ServerPlayer)owner));
        });
    }

    @Override
    protected int getCastWarmupTime() {
        return 80;
    }

    @Override
    protected int getCastingTime() {
        return 100;
    }

    @Override
    protected int getCastingInterval() {
        return 400;
    }

    @Override
    protected SoundEvent getSpellPrepareSound() {
        return SoundEvents.EVOKER_PREPARE_WOLOLO;
    }

    @Override
    protected int getSpellColor() {
        return 3178592;
    }
}

