/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.gui;

import java.util.Objects;
import java.util.function.BooleanSupplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import ovh.corail.tombstone.helper.FontHelper;

public class CustomButton
extends Button {
    private final BooleanSupplier forceHighlight;

    CustomButton(int x, int y, int widthIn, int heightIn, Component buttonText, Button.OnPress onPress) {
        this(x, y, widthIn, heightIn, buttonText, onPress, () -> false);
    }

    CustomButton(int x, int y, int widthIn, int heightIn, Component buttonText, Button.OnPress onPress, BooleanSupplier forceHighlight) {
        super(x, y, widthIn, heightIn, buttonText, onPress, narration -> Component.empty());
        this.setFGColor(-1);
        this.forceHighlight = forceHighlight;
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        Minecraft minecraft = Minecraft.getInstance();
        if (this.isHoveredOrFocused() || this.forceHighlight.getAsBoolean()) {
            guiGraphics.fillGradient(this.getX() - 1, this.getY() - 1, this.getX() + this.width + 1, this.getY() + this.height + 1, -14668449, -14668449);
        }
        guiGraphics.fillGradient(this.getX(), this.getY(), this.getX() + this.width, this.getY() + this.height, 0x70000000, 0x30000000);
        int j = this.isHoveredOrFocused() || this.forceHighlight.getAsBoolean() ? -1875 : this.getFGColor();
        Font font = minecraft.font;
        Component component = this.getMessage();
        float f = (float)this.getX() + (float)this.width / 2.0f;
        float f2 = this.getY() + 1;
        Objects.requireNonNull(minecraft.font);
        FontHelper.drawCenteredFantasy(guiGraphics, font, component, f, f2 + (float)(this.height - 9) / 2.0f, j | Mth.ceil((float)(this.alpha * 255.0f)) << 24);
    }
}

