/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.gui;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.TooltipRenderUtil;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3x2fStack;
import org.joml.Vector2f;
import ovh.corail.tombstone.capability.TBPlayerCapabilityHandler;
import ovh.corail.tombstone.gui.CustomButton;
import ovh.corail.tombstone.gui.ScreenCompendium;
import ovh.corail.tombstone.gui.ScreenConfig;
import ovh.corail.tombstone.gui.TBScreen;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.FontHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.RenderHelper;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.item.ItemAdvancement;
import ovh.corail.tombstone.network.PacketHandler;
import ovh.corail.tombstone.network.SMessageUpgradePerk;
import ovh.corail.tombstone.perk.Perk;
import ovh.corail.tombstone.perk.PerkBranch;
import ovh.corail.tombstone.perk.PerkRegistry;
import ovh.corail.tombstone.registry.ModItems;

public final class ScreenKnowledge
extends TBScreen {
    private final Player player;
    private final List<PerkIcon> icons;
    private PerkIcon hoveredIcon;
    private int leftPerkPoints;
    private final ItemStack stackSkull = ItemAdvancement.IconType.FIRST_KNOWLEDGE.getItemStack();
    private final ItemStack stackRevive = ItemAdvancement.IconType.REVIVE.getItemStack();
    private final ItemStack stackAnkh = ItemAdvancement.IconType.FIRST_PRAY.getItemStack();
    private final double alignmentPos;
    private final List<BonusIcon> bonusIcons = new ArrayList<BonusIcon>();
    private static final int PERK_AREA_WIDTH = 328;
    private static final int PERK_AREA_HEIGHT = 110;
    private static final int PERK_AREA_DRAG_LIMIT_RIGHT = 0;
    private static final int PERK_AREA_DRAG_LIMIT_LEFT = 0;
    private static final int PERK_AREA_DRAG_LIMIT_DOWN = 10;
    private static final int PERK_AREA_DRAG_LIMIT_UP = 20;
    private int perkAreaMinX;
    private int perkAreaMinY;
    private boolean isDraggingPerkArea = false;
    private boolean isClickingPerkArea = false;
    private int perkAreaDragOffsetX = 0;
    private int perkAreaDragOffsetY = 20;
    private int lastMouseX;
    private int lastMouseY;
    private int clickedX;
    private int clickedY;
    private static final int BRANCH_SPACING = 82;
    private static final int BRANCH_TIER_SPACING = 41;

    public ScreenKnowledge(Player player) {
        super((Component)LangKey.MESSAGE_KNOWLEDGE_OF_DEATH.getText(new Object[0]));
        this.player = player;
        this.alignmentPos = this.getBarRatio();
        this.icons = PerkRegistry.values().map(x$0 -> new PerkIcon((Perk)x$0)).collect(Collectors.toList());
        this.initPerkIcons();
        this.initBonusIcons();
    }

    @Override
    protected void init() {
        super.init();
        this.perkAreaMinX = (this.width - 328) / 2;
        this.perkAreaMinY = this.guiTop + 68;
        for (PerkIcon icon : this.icons) {
            icon.updatePosition();
        }
        int xIcon = this.guiLeft + 30;
        for (BonusIcon icon : this.bonusIcons) {
            icon.setPosition(xIcon, this.guiBottom - 45);
            xIcon += 18;
        }
        this.addRenderableWidget((GuiEventListener)new CustomButton(this.guiLeft + 10, this.guiBottom - 25, 70, 15, (Component)LangKey.MESSAGE_COMPENDIUM.getText(new Object[0]), pressable -> {
            this.onClose();
            this.getMinecraft().setScreen((Screen)new ScreenCompendium());
        }));
        this.addRenderableWidget((GuiEventListener)new CustomButton(this.guiRight - 10 - 70, this.guiBottom - 25, 70, 15, (Component)LangKey.MESSAGE_CONFIG.getText(new Object[0]), pressable -> {
            this.onClose();
            this.getMinecraft().setScreen((Screen)new ScreenConfig());
        }));
    }

    private void initPerkIcons() {
        this.icons.sort(Comparator.comparingInt(icon -> icon.perk.getBranchTier()));
        HashMap<PerkBranch, Map> branchTierPositions = new HashMap<PerkBranch, Map>();
        for (PerkIcon icon2 : this.icons) {
            int slot;
            if (icon2.perk.getParent() != null) {
                this.icons.stream().filter(i -> i.perk == icon.perk.getParent()).findFirst().ifPresent(icon2::setParent);
            }
            PerkBranch branch = icon2.perk.getBranch();
            int tier = icon2.perk.getBranchTier();
            Map tierUsed = branchTierPositions.computeIfAbsent(branch, b -> new HashMap());
            Set usedSlots = tierUsed.computeIfAbsent(tier, t -> new HashSet());
            if (tier == 1 || icon2.parentIcon == null) {
                slot = 0;
                while (usedSlots.contains(slot)) {
                    ++slot;
                }
            } else {
                PerkIcon movedPerk;
                slot = icon2.parentIcon.slot;
                if (usedSlots.contains(slot) && (movedPerk = (PerkIcon)this.icons.stream().filter(i -> i.slot == icon.parentIcon.slot).findFirst().orElse(null)) != null) {
                    int newSlot = slot + 1;
                    while (usedSlots.contains(newSlot)) {
                        ++newSlot;
                    }
                    movedPerk.slot = newSlot;
                    usedSlots.add(newSlot);
                }
            }
            icon2.slot = slot;
            usedSlots.add(slot);
        }
        for (PerkIcon icon2 : this.icons) {
            icon2.updateLocalPosition();
        }
        this.updatePerkIcons();
    }

    public void updatePerkIcons() {
        Map<PerkBranch, TBPlayerCapabilityHandler.BranchUsage> usedPointsByBranch = TBPlayerCapabilityHandler.getUsedPointsByBranch(this.player);
        for (PerkIcon icon : this.icons) {
            icon.updateInfo(EntityHelper.hasPerkBranchTierRequirement(icon.perk, usedPointsByBranch.get((Object)((Object)icon.perk.getBranch())).perkPoints));
        }
    }

    private void initBonusIcons() {
        ArrayList tooltips;
        int alignmentLevel;
        boolean isBad;
        TimeHelper.SpecialEvent specialEvent = TimeHelper.getSpecialEvent();
        if (specialEvent != TimeHelper.SpecialEvent.NONE) {
            String eventName;
            this.bonusIcons.add(new BonusIcon(switch (specialEvent) {
                case TimeHelper.SpecialEvent.HALLOWEEN -> {
                    eventName = "halloween";
                    yield ItemAdvancement.IconType.GHOST.getItemStack();
                }
                case TimeHelper.SpecialEvent.CHRISTMAS -> {
                    eventName = "christmas";
                    yield new ItemStack((ItemLike)ModItems.christmas_gift);
                }
                default -> {
                    eventName = "spring_bloom";
                    yield new ItemStack((ItemLike)Items.PEONY);
                }
            }, Lists.newArrayList((Object[])new Component[]{Component.translatable((String)("tombstone.compendium." + eventName + ".title")).withStyle(StyleType.MESSAGE_SPECIAL), Component.translatable((String)"tombstone.message.holiday_event_bonus")})));
        }
        if ((isBad = (alignmentLevel = TBPlayerCapabilityHandler.getAlignmentLevel(this.player)) < 0) || alignmentLevel > 0) {
            tooltips = new ArrayList();
            tooltips.add((isBad ? LangKey.MESSAGE_DARKNESS : LangKey.MESSAGE_LIGHT).getText(StyleType.MESSAGE_SPECIAL, new Object[]{Helper.getRomanNumber(Math.abs(alignmentLevel))}));
            tooltips.add(Component.translatable((String)"tombstone.message.protect_against", (Object[])new Object[]{Component.translatable((String)("tombstone.message." + (isBad ? "living_damages" : "undead_damages"))), Math.abs(alignmentLevel * 10)}));
            this.bonusIcons.add(new BonusIcon(isBad ? this.stackSkull : this.stackRevive, tooltips));
        }
        tooltips = isBad ? Lists.newArrayList((Object[])new Component[]{Component.translatable((String)"tombstone.advancement.zombify.title").withStyle(StyleType.MESSAGE_SPECIAL), Component.translatable((String)"bonus.tombstone.zombify")}) : Lists.newArrayList((Object[])new Component[]{Component.translatable((String)"bonus.tombstone.exorcism.title").withStyle(StyleType.MESSAGE_SPECIAL), Component.translatable((String)"bonus.tombstone.exorcism")});
        this.bonusIcons.add(new BonusIcon(ItemAdvancement.IconType.EXORCISM.getItemStack(), tooltips));
        if (alignmentLevel > 0) {
            this.bonusIcons.add(new BonusIcon(ItemAdvancement.IconType.PRAYER_OF_PROTECTION.getItemStack(), Lists.newArrayList((Object[])new Component[]{Component.translatable((String)"tombstone.advancement.pray_of_protection.title").withStyle(StyleType.MESSAGE_SPECIAL), Component.translatable((String)"bonus.tombstone.pray_of_protection")})));
        }
        if (alignmentLevel > 2) {
            this.bonusIcons.add(new BonusIcon(ItemAdvancement.IconType.GOLD_HEART.getItemStack(), Lists.newArrayList((Object[])new Component[]{Component.translatable((String)"bonus.tombstone.pray_of_harmonization.title").withStyle(StyleType.MESSAGE_SPECIAL), Component.translatable((String)"bonus.tombstone.pray_of_harmonization")})));
        } else if (alignmentLevel > 1) {
            this.bonusIcons.add(new BonusIcon(new ItemStack((ItemLike)Items.LEAD), Lists.newArrayList((Object[])new Component[]{Component.translatable((String)"bonus.tombstone.pray_of_empathy.title").withStyle(StyleType.MESSAGE_SPECIAL), Component.translatable((String)"bonus.tombstone.pray_of_empathy")})));
        }
        if (alignmentLevel < -2) {
            this.bonusIcons.add(new BonusIcon(ItemAdvancement.IconType.BLACK_NOTE.getItemStack(), Lists.newArrayList((Object[])new Component[]{Component.translatable((String)"bonus.tombstone.pray_of_dissonance.title").withStyle(StyleType.MESSAGE_SPECIAL), Component.translatable((String)"bonus.tombstone.pray_of_dissonance")})));
        } else if (alignmentLevel < -1) {
            this.bonusIcons.add(new BonusIcon(new ItemStack((ItemLike)Items.GHAST_TEAR), Lists.newArrayList((Object[])new Component[]{Component.translatable((String)"bonus.tombstone.pray_of_undead.title").withStyle(StyleType.MESSAGE_SPECIAL), Component.translatable((String)"bonus.tombstone.pray_of_undead")})));
        }
        if (TBPlayerCapabilityHandler.hasWatcherKnowledge(this.player, 0)) {
            this.bonusIcons.add(new BonusIcon(ItemAdvancement.IconType.SPECTRAL_BOND.getItemStack(), Lists.newArrayList((Object[])new Component[]{Component.translatable((String)"bonus.tombstone.rite_of_silent_bond.title").withStyle(StyleType.MESSAGE_SPECIAL), Component.translatable((String)"bonus.tombstone.rite_of_silent_bond")})));
        }
        if (TBPlayerCapabilityHandler.hasWatcherKnowledge(this.player, 1)) {
            this.bonusIcons.add(new BonusIcon(ItemAdvancement.IconType.WING.getItemStack(), Lists.newArrayList((Object[])new Component[]{Component.translatable((String)"bonus.tombstone.enhanced_grave_prayer.title").withStyle(StyleType.MESSAGE_SPECIAL), Component.translatable((String)"bonus.tombstone.enhanced_grave_prayer")})));
        }
        if (TBPlayerCapabilityHandler.hasWatcherKnowledge(this.player, 2)) {
            this.bonusIcons.add(new BonusIcon(new ItemStack((ItemLike)Items.BRAIN_CORAL), Lists.newArrayList((Object[])new Component[]{Component.translatable((String)"bonus.tombstone.rite_of_coral_chant.title").withStyle(StyleType.MESSAGE_SPECIAL), Component.translatable((String)"bonus.tombstone.rite_of_coral_chant")})));
        }
        if (TBPlayerCapabilityHandler.hasWatcherKnowledge(this.player, 3)) {
            this.bonusIcons.add(new BonusIcon(ModItems.scroll_of_knowledge.createWithXp(1), Lists.newArrayList((Object[])new Component[]{Component.translatable((String)"bonus.tombstone.rite_of_remanence.title").withStyle(StyleType.MESSAGE_SPECIAL), Component.translatable((String)"bonus.tombstone.rite_of_remanence")})));
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        this.isDraggingPerkArea = false;
        this.clickedX = this.lastMouseX = (int)mouseX;
        this.clickedY = this.lastMouseY = (int)mouseY;
        boolean bl = this.isClickingPerkArea = mouseX >= (double)this.perkAreaMinX && mouseX <= (double)(this.perkAreaMinX + 328) && mouseY >= (double)this.perkAreaMinY && mouseY <= (double)(this.perkAreaMinY + 110);
        if (this.isClickingPerkArea) {
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int mouseButton, double dragX, double dragY) {
        if (mouseButton == 0 && this.isClickingPerkArea) {
            if (!this.isDraggingPerkArea) {
                int distX = Math.abs((int)mouseX - this.clickedX);
                int distY = Math.abs((int)mouseY - this.clickedY);
                if (distX > 2 || distY > 2) {
                    this.isDraggingPerkArea = true;
                }
            }
            if (this.isDraggingPerkArea) {
                this.perkAreaDragOffsetX = Mth.clamp((int)(this.perkAreaDragOffsetX + (int)(mouseX - (double)this.lastMouseX)), (int)0, (int)0);
                this.perkAreaDragOffsetY = Mth.clamp((int)(this.perkAreaDragOffsetY + (int)(mouseY - (double)this.lastMouseY)), (int)-10, (int)20);
                this.lastMouseX = (int)mouseX;
                this.lastMouseY = (int)mouseY;
            }
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, mouseButton, dragX, dragY);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int mouseButton) {
        if (mouseButton == 0 && this.isDraggingPerkArea) {
            this.isDraggingPerkArea = false;
            this.lastMouseX = 0;
            this.lastMouseY = 0;
            return true;
        }
        if (this.hoveredIcon != null) {
            if (mouseButton == 0 && !this.hoveredIcon.isDisabled) {
                int perkLevel = this.hoveredIcon.baseLevel;
                if (perkLevel < this.hoveredIcon.perk.getLevelMax() && this.leftPerkPoints >= this.hoveredIcon.perk.getCost(perkLevel + 1)) {
                    PacketHandler.sendToServer(new SMessageUpgradePerk(SMessageUpgradePerk.SyncType.UPGRADE_PERK, this.hoveredIcon.perk));
                    return true;
                }
            } else if (mouseButton == 1 && this.player.isCreative() && this.hoveredIcon.baseLevel > 0) {
                PacketHandler.sendToServer(new SMessageUpgradePerk(SMessageUpgradePerk.SyncType.DOWNGRADE_PERK, this.hoveredIcon.perk));
                return true;
            }
        }
        return super.mouseReleased(mouseX, mouseY, mouseButton);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double deltaX, double deltaY) {
        if (mouseX >= (double)this.perkAreaMinX && mouseX <= (double)(this.perkAreaMinX + 328) && mouseY >= (double)this.perkAreaMinY && mouseY <= (double)(this.perkAreaMinY + 110)) {
            boolean horizontal = Screen.hasShiftDown();
            if (horizontal) {
                this.perkAreaDragOffsetX = Mth.clamp((int)(this.perkAreaDragOffsetX + (int)(deltaX * 10.0)), (int)0, (int)0);
            } else {
                this.perkAreaDragOffsetY = Mth.clamp((int)(this.perkAreaDragOffsetY + (int)(deltaY * 10.0)), (int)-10, (int)20);
            }
            return true;
        }
        return super.mouseScrolled(mouseX, mouseY, deltaX, deltaY);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        if (this.isResized) {
            return;
        }
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.drawTitle(guiGraphics, (Component)LangKey.MESSAGE_KNOWLEDGE_OF_DEATH.getText(new Object[0]));
        int totalPerkPoints = TBPlayerCapabilityHandler.getTotalPerkPoints(this.player);
        this.leftPerkPoints = totalPerkPoints - TBPlayerCapabilityHandler.getTotalUsedPerkPoints(this.player);
        int playerKnowledge = TBPlayerCapabilityHandler.getKnowledge(this.player);
        int currentLevelKnowledge = TBPlayerCapabilityHandler.getKnowledgeForLevel(totalPerkPoints);
        int nextLevelKnowledge = TBPlayerCapabilityHandler.getKnowledgeForLevel(totalPerkPoints + 1);
        int knowledgeBarStartX = this.guiLeft + 10;
        int knowledgeBarEndX = this.halfWidth - 10;
        int knowledgeBarWidth = knowledgeBarEndX - knowledgeBarStartX;
        guiGraphics.drawString(this.font, FontHelper.withFantasyFont((Component)LangKey.MESSAGE_KNOWLEDGE_LEVEL.getText(totalPerkPoints)), this.guiLeft + 15, this.guiTop + 40, -1, false);
        float scale = 0.5f;
        float inverseScale = 2.0f;
        Matrix3x2fStack matrixStack = guiGraphics.pose();
        matrixStack.pushMatrix();
        matrixStack.scale(scale, scale);
        guiGraphics.drawString(this.font, FontHelper.withFantasyFont((Component)LangKey.MESSAGE_AVAILABLE_POINTS.getText(this.leftPerkPoints)), (int)((float)(this.guiLeft + 100) * inverseScale), (int)((float)(this.guiTop + 40) * inverseScale), -1, false);
        guiGraphics.drawString(this.font, FontHelper.withFantasyFont((Component)LangKey.MESSAGE_NEXT_LEVEL.getText(playerKnowledge - currentLevelKnowledge, nextLevelKnowledge - currentLevelKnowledge)), (int)((float)(this.guiLeft + 100) * inverseScale), (int)((float)(this.guiTop + 48) * inverseScale), -1, false);
        matrixStack.popMatrix();
        int percentFilled = Math.round((float)(knowledgeBarWidth * (playerKnowledge - currentLevelKnowledge)) / (float)(nextLevelKnowledge - currentLevelKnowledge));
        guiGraphics.fill(this.guiLeft + 9, this.guiTop + 54, this.halfWidth - 9, this.guiTop + 61, -16777216);
        guiGraphics.fill(knowledgeBarStartX, this.guiTop + 55, knowledgeBarEndX, this.guiTop + 60, -1875);
        guiGraphics.fill(knowledgeBarStartX, this.guiTop + 55, knowledgeBarStartX + percentFilled, this.guiTop + 60, -16711936);
        float step = (float)knowledgeBarWidth / 8.0f;
        for (int i = 1; i < 8; ++i) {
            guiGraphics.vLine(knowledgeBarStartX + (int)((float)i * step), this.guiTop + 54, this.guiTop + 60, -16777216);
        }
        int alignmentBarStartX = this.halfWidth + 10;
        int alignmentBarEndX = this.guiRight - 10;
        int alignmentBarWidth = alignmentBarEndX - alignmentBarStartX;
        int alignmentBarCenterX = alignmentBarStartX + alignmentBarWidth / 2;
        int alignmentLevel = TBPlayerCapabilityHandler.getAlignmentLevel(this.player);
        guiGraphics.drawString(this.font, FontHelper.withFantasyFont((Component)LangKey.MESSAGE_ALIGNMENT_LEVEL.getText((alignmentLevel < 0 ? "-" : "+") + alignmentLevel)), this.halfWidth + 15, this.guiTop + 40, -1, false);
        guiGraphics.fill(this.halfWidth + 9, this.guiTop + 54, this.guiRight - 9, this.guiTop + 61, -16777216);
        RenderHelper.fillHorizontalGradient(guiGraphics, alignmentBarStartX, this.guiTop + 55, alignmentBarCenterX, this.guiTop + 60, -65536, -1875);
        RenderHelper.fillHorizontalGradient(guiGraphics, alignmentBarCenterX, this.guiTop + 55, alignmentBarEndX, this.guiTop + 60, -1875, -16776961);
        step = (float)alignmentBarWidth / 8.0f;
        for (int i = 1; i < 8; ++i) {
            if (i == 4) continue;
            guiGraphics.vLine(alignmentBarStartX + (int)((float)i * step), this.guiTop + 54, this.guiTop + 60, -16777216);
        }
        scale = 0.6f;
        inverseScale = 1.0f / scale;
        matrixStack.pushMatrix();
        matrixStack.scale(scale, scale);
        int itemY = Math.round((float)(this.guiTop + 52) * inverseScale);
        guiGraphics.renderItem(this.stackSkull, Math.round((float)(alignmentBarStartX - 4) * inverseScale), itemY);
        guiGraphics.renderItem(this.stackRevive, Math.round((float)(alignmentBarEndX - 4) * inverseScale), itemY);
        guiGraphics.renderItem(this.stackAnkh, (int)Math.round(((double)alignmentBarCenterX + (double)((float)alignmentBarWidth * 0.5f) * this.alignmentPos - 4.0) * (double)inverseScale), itemY);
        matrixStack.popMatrix();
        this.hoveredIcon = this.icons.stream().filter(icon -> icon.contains(mouseX - this.perkAreaDragOffsetX, mouseY - this.perkAreaDragOffsetY)).findFirst().orElse(null);
        guiGraphics.enableScissor(this.perkAreaMinX, this.perkAreaMinY, this.perkAreaMinX + 328, this.perkAreaMinY + 110);
        matrixStack.pushMatrix();
        matrixStack.translate((float)this.perkAreaDragOffsetX, (float)this.perkAreaDragOffsetY);
        guiGraphics.fill(this.perkAreaMinX, this.perkAreaMinY - 20, this.perkAreaMinX + 328, this.perkAreaMinY - 3, -2145378272);
        guiGraphics.fill(this.perkAreaMinX, this.perkAreaMinY + 25 + 13, this.perkAreaMinX + 328, this.perkAreaMinY + 70 + 9, 0x20C0C0C0);
        for (PerkBranch branch : PerkBranch.values()) {
            int branchX = branch.ordinal() * 82;
            guiGraphics.fill(this.perkAreaMinX + branchX, this.perkAreaMinY - 20, this.perkAreaMinX + branchX + 82, this.perkAreaMinY + 110 + 10, branch.getColor());
            FontHelper.drawCenteredFantasy(guiGraphics, this.font, (Component)Component.translatable((String)("tombstone.message.perk_branch_" + branch.ordinal())).withStyle(StyleType.MESSAGE_SPECIAL), (float)(this.perkAreaMinX + branchX) + 41.0f, this.perkAreaMinY - 14, -1875, true);
        }
        int halfPerkSize = 13;
        this.icons.forEach(icon -> {
            PerkIcon parentIcon = icon.parentIcon;
            if (parentIcon != null) {
                int x = parentIcon.minX + 13 - 1;
                guiGraphics.fill(x - 1, parentIcon.maxY + 1, x, icon.minY - 1, -1);
            }
            this.drawPerk(guiGraphics, (PerkIcon)icon);
        });
        matrixStack.popMatrix();
        guiGraphics.disableScissor();
        this.bonusIcons.forEach(icon -> icon.render(guiGraphics));
        if (this.hoveredIcon != null) {
            if (!this.isDraggingPerkArea) {
                this.renderTooltip(guiGraphics, this.hoveredIcon.getTooltip(), (float)this.hoveredIcon.minX + 12.5f, this.hoveredIcon.minY + 25, 12.5f, (float)this.perkAreaDragOffsetY - 20.0f);
            }
        } else {
            this.bonusIcons.stream().filter(icon -> icon.contains(mouseX, mouseY)).findFirst().ifPresent(icon -> this.renderTooltip(guiGraphics, icon.tooltips, icon.minX + 6, icon.minY + 6, 11.0f, 0.0f));
        }
    }

    private double getBarRatio() {
        boolean isPositive = TBPlayerCapabilityHandler.getAlignmentValue(this.player) >= 0;
        int alignment = Math.abs(Mth.clamp((int)TBPlayerCapabilityHandler.getAlignmentValue(this.player), (int)TBPlayerCapabilityHandler.getAlignmentMinValue(), (int)TBPlayerCapabilityHandler.getAlignmentMaxValue()));
        double ratio = alignment > 3000 ? 0.75 + 0.25 * (double)(alignment - 3000) * 5.0E-4 : (alignment > 1500 ? 0.5 + 0.25 * (double)(alignment - 1500) / 1500.0 : (alignment > 500 ? 0.25 + 0.25 * (double)(alignment - 500) * 0.001 : 0.25 * (double)alignment * 0.002));
        return isPositive ? ratio : -ratio;
    }

    private void drawPerk(GuiGraphics guiGraphics, PerkIcon icon) {
        boolean isHovered = icon.equals(this.hoveredIcon);
        guiGraphics.fill(icon.minX, icon.minY + 25 - 1, icon.maxX - 1, icon.maxY, -15329733);
        boolean isGray = !icon.hasBonus && (icon.isLocked || icon.levelWithBonus == 0 && !isHovered);
        this.renderTextureWithColor(guiGraphics, FRAME, icon.minX, icon.minY, 24);
        icon.perk.getIcon().ifLeft(texture -> this.renderTextureWithColor(guiGraphics, (ResourceLocation)texture, icon.minX + 2, icon.minY + 2, 20));
        icon.perk.getIcon().ifRight(itemSupplier -> guiGraphics.renderItem((ItemStack)itemSupplier.get(), icon.minX + 4, icon.minY + 4));
        if (isGray) {
            guiGraphics.fill(icon.minX + 2, icon.minY + 2, icon.minX + 25 - 3, icon.minY + 25 - 3, Helper.convertColorToInt(0.9f, 0.06f, 0.06f, 0.06f));
        }
        if (isHovered) {
            int color = icon.isLocked ? -43691 : (icon.isMaxLevel ? -1980292 : -7096363);
            guiGraphics.hLine(icon.minX - 1, icon.maxX - 1, icon.minY - 1, color);
            guiGraphics.hLine(icon.minX - 1, icon.maxX - 1, icon.maxY, color);
            guiGraphics.vLine(icon.minX - 1, icon.minY - 1, icon.maxY, color);
            guiGraphics.vLine(icon.maxX - 1, icon.minY - 1, icon.maxY, color);
        }
        boolean hasBonus = icon.perk.getLevelBonus(this.player) != 0;
        MutableComponent perkLevelText = Component.literal((String)("" + icon.baseLevel)).setStyle(icon.isDisabled ? StyleType.COLOR_RED : (icon.isMaxLevel ? StyleType.PERK_TEXT_MAX : (icon.baseLevel > 0 ? StyleType.PERK_TEXT_DEFAULT : StyleType.PERK_TEXT_DISABLE)));
        if (hasBonus && !icon.isDisabled) {
            perkLevelText.append((Component)Component.literal((String)("(" + icon.levelWithBonus + ")")).withStyle(StyleType.PERK_TEXT_BONUS));
        }
        FontHelper.drawCenteredFantasy(guiGraphics, this.font, (Component)perkLevelText, (float)(icon.minX + icon.maxX) / 2.0f, icon.maxY - 8, -1);
        if (icon.isLocked) {
            Matrix3x2fStack matrixStack = guiGraphics.pose();
            float scale = 0.5f;
            float inverseScale = 2.0f;
            matrixStack.pushMatrix();
            matrixStack.scale(scale, scale);
            guiGraphics.drawString(this.font, (Component)Component.literal((String)"\ud83d\udd12").withStyle(ChatFormatting.RED), (int)((float)(icon.maxX - 4) * inverseScale), (int)((float)(icon.maxY - 4) * inverseScale), -1, false);
            matrixStack.popMatrix();
        }
    }

    private void renderTextureWithColor(GuiGraphics guiGraphics, ResourceLocation rl, int x, int y, int width) {
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, rl, x, y, 0.0f, 0.0f, width, width, width, width, -1);
    }

    private void renderTooltip(GuiGraphics guiGraphics, List<Component> compoList, float x, float y, float offsetX, float offsetY) {
        if (compoList.isEmpty()) {
            return;
        }
        Objects.requireNonNull(this.font);
        int lineHeight = 9 + 2;
        float scale = 0.5f;
        float inverseScale = 2.0f;
        List<FormattedCharSequence> tooltips = compoList.stream().map(FontHelper::withFantasyFont).map(Component::getVisualOrderText).toList();
        int tooltipWidth = tooltips.stream().mapToInt(t -> this.font.width(t)).max().orElse(0);
        int tooltipHeight = (tooltips.size() == 1 ? -2 : 0) + tooltips.size() * lineHeight;
        Vector2f vec2f = this.positionTooltip(guiGraphics.guiWidth(), guiGraphics.guiHeight(), x, y, tooltipWidth, tooltipHeight, offsetX, offsetY);
        int posX = Math.round(vec2f.x() * inverseScale);
        int posY = Math.round(vec2f.y() * inverseScale);
        Matrix3x2fStack matrixStack = guiGraphics.pose();
        matrixStack.pushMatrix();
        matrixStack.scale(scale, scale);
        TooltipRenderUtil.renderTooltipBackground((GuiGraphics)guiGraphics, (int)posX, (int)posY, (int)tooltipWidth, (int)tooltipHeight, null);
        int currentPosY = posY;
        for (FormattedCharSequence tooltip : tooltips) {
            guiGraphics.drawString(this.font, tooltip, posX, currentPosY, -1, false);
            currentPosY += lineHeight;
        }
        matrixStack.popMatrix();
    }

    private Vector2f positionTooltip(int screenWidth, int screenHeight, float x, float y, float tooltipWidth, float tooltipHeight, float offsetX, float offSetY) {
        return new Vector2f(Math.max(x += x + tooltipWidth / 2.0f + offsetX + 5.0f > (float)screenWidth ? -tooltipWidth / 2.0f - offsetX - 3.0f : offsetX + 2.0f, 0.0f), Math.max(y += (y + tooltipHeight + 5.0f > (float)screenHeight ? -tooltipHeight / 8.0f : -4.0f) + offSetY, 0.0f));
    }

    private class PerkIcon {
        public static final int ICON_SIZE = 25;
        private final Perk perk;
        @Nullable
        private PerkIcon parentIcon = null;
        private int localX;
        private int localY;
        private int slot;
        private int minX;
        private int minY;
        private int maxX;
        private int maxY;
        private int baseLevel;
        private int levelWithBonus;
        private int parentLevel;
        private boolean isDisabled;
        private boolean isMaxLevel;
        private boolean hasTierRequirement;
        private boolean isLocked;
        private boolean hasBonus;
        @Nullable
        private List<Component> tooltip;

        PerkIcon(Perk perk) {
            this.perk = perk;
        }

        void setParent(PerkIcon parent) {
            this.parentIcon = parent;
        }

        void updateLocalPosition() {
            this.localX = this.perk.getBranch().ordinal() * 82 + 2 + this.slot * 25 + 2;
            this.localY = (this.perk.getBranchTier() - 1) * 41;
        }

        void updatePosition() {
            this.minX = ScreenKnowledge.this.perkAreaMinX + this.localX;
            this.minY = ScreenKnowledge.this.perkAreaMinY + this.localY;
            this.maxX = this.minX + 25;
            this.maxY = this.minY + 25 + 10;
        }

        void updateInfo(boolean hasTierRequirement) {
            this.baseLevel = TBPlayerCapabilityHandler.getPerkLevel(ScreenKnowledge.this.player, this.perk);
            this.levelWithBonus = TBPlayerCapabilityHandler.getPerkLevelWithBonus(ScreenKnowledge.this.player, this.perk);
            this.parentLevel = this.parentIcon != null ? TBPlayerCapabilityHandler.getPerkLevel(ScreenKnowledge.this.player, this.parentIcon.perk) : 0;
            this.isDisabled = this.perk.isDisabled(ScreenKnowledge.this.player);
            this.isMaxLevel = this.baseLevel == this.perk.getLevelMax();
            this.hasTierRequirement = hasTierRequirement;
            this.isLocked = this.isDisabled || this.parentIcon != null && this.parentLevel == 0 || !this.hasTierRequirement;
            this.hasBonus = this.levelWithBonus > this.baseLevel;
            this.tooltip = null;
        }

        List<Component> getTooltip() {
            if (this.tooltip == null) {
                this.generateTooltip();
            }
            return this.tooltip;
        }

        private void generateTooltip() {
            ArrayList<Component> tooltip = new ArrayList<Component>();
            tooltip.add((Component)this.perk.getTranslation().copy().withStyle(StyleType.MESSAGE_SPECIAL));
            tooltip.add((Component)Component.translatable((String)(this.perk.getTranslationKey() + ".desc")).withStyle(ChatFormatting.DARK_GRAY));
            Component currentBonusInfo = this.perk.getCurrentBonusInfo(this.levelWithBonus);
            if (!currentBonusInfo.getString().isEmpty()) {
                tooltip.add((Component)LangKey.TOOLTIP_ACTUAL_BONUS.getText(new Object[0]).withStyle(StyleType.INFO));
                ChatFormatting chatFormatting = this.levelWithBonus > this.baseLevel ? ChatFormatting.DARK_PURPLE : ChatFormatting.WHITE;
                tooltip.add((Component)currentBonusInfo.copy().withStyle(chatFormatting));
            }
            boolean isValid = true;
            if (this.perk.isDisabled(ScreenKnowledge.this.player)) {
                isValid = false;
                tooltip.add((Component)this.perk.getDisabledInfo(ScreenKnowledge.this.player).plainCopy().withStyle(ChatFormatting.RED));
            } else if (!this.hasTierRequirement) {
                isValid = false;
                tooltip.add((Component)LangKey.MESSAGE_CANT_UPGRADE_BRANCH_TIER.getText(ChatFormatting.RED, new Object[0]));
            } else if (this.parentIcon != null && this.parentLevel == 0) {
                isValid = false;
                tooltip.add((Component)LangKey.MESSAGE_CANT_UPGRADE_PARENT_PERK.getText(ChatFormatting.RED, new Object[0]));
            }
            if (isValid) {
                if (this.baseLevel < this.perk.getLevelMax()) {
                    int cost;
                    Component nextBonusInfo;
                    if (this.levelWithBonus < this.perk.getLevelMax() && !(nextBonusInfo = this.perk.getNextBonusInfo(this.levelWithBonus + 1)).getString().isEmpty()) {
                        tooltip.add((Component)LangKey.TOOLTIP_NEXT_BONUS.getText(new Object[0]).withStyle(StyleType.INFO));
                        tooltip.add((Component)nextBonusInfo.copy().withStyle(ChatFormatting.GRAY));
                    }
                    boolean hasPerkPoints = ScreenKnowledge.this.leftPerkPoints >= (cost = this.perk.getCost(this.baseLevel + 1));
                    tooltip.add((Component)LangKey.MESSAGE_COST.getText(hasPerkPoints ? ChatFormatting.AQUA : ChatFormatting.RED, new Object[]{cost}));
                    if (hasPerkPoints) {
                        tooltip.add((Component)LangKey.MESSAGE_CLICK_TO_UPGRADE.getText(ChatFormatting.BLUE, new Object[0]));
                    }
                } else {
                    tooltip.add((Component)LangKey.MESSAGE_MAX.getText(ChatFormatting.GOLD, new Object[0]));
                }
            }
            this.tooltip = tooltip;
        }

        boolean contains(double mouseX, double mouseY) {
            return mouseX >= (double)this.minX && mouseY >= (double)this.minY && mouseX <= (double)this.maxX && mouseY <= (double)this.maxY;
        }
    }

    private static class BonusIcon {
        public static final int ICON_SIZE = 16;
        private final ItemStack stack;
        private final List<Component> tooltips;
        private int minX;
        private int minY;
        private int maxX;
        private int maxY;

        BonusIcon(ItemStack stack, List<Component> tooltips) {
            this.stack = stack;
            this.tooltips = tooltips;
        }

        void setPosition(int x, int y) {
            this.minX = x;
            this.minY = y;
            this.maxX = x + 16;
            this.maxY = y + 16;
        }

        boolean contains(double mouseX, double mouseY) {
            return mouseX >= (double)this.minX && mouseY >= (double)this.minY && mouseX <= (double)this.maxX && mouseY <= (double)this.maxY;
        }

        private void render(GuiGraphics guiGraphics) {
            guiGraphics.fill(this.minX - 1, this.minY - 1, this.maxX + 1, this.maxY + 1, -15329733);
            guiGraphics.fillGradient(this.minX, this.minY, this.maxX, this.maxY, -16703669, -7096363);
            guiGraphics.renderItem(this.stack, this.minX, this.minY);
        }
    }
}

