/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.gui;

import java.util.List;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import ovh.corail.tombstone.gui.ProgressOption;

public class SliderButton
extends AbstractSliderButton {
    private final ProgressOption option;
    private final List<FormattedCharSequence> tooltip;

    public SliderButton(int x, int y, int width, int height, ProgressOption option, List<FormattedCharSequence> tooltip) {
        super(x, y, width, height, CommonComponents.EMPTY, (double)((float)option.toPct(option.get())));
        this.option = option;
        this.tooltip = tooltip;
        this.updateMessage();
    }

    protected void applyValue() {
        this.option.set(this.option.toValue(this.value));
    }

    protected void updateMessage() {
        this.setMessage(this.option.getMessage());
    }

    public void onClick(double x, double y) {
        this.setValueFromMouse(x);
    }

    protected void onDrag(double x, double p_93592_, double p_93593_, double p_93594_) {
        this.setValueFromMouse(x);
    }

    private void setValueFromMouse(double x) {
        double oldValue = this.value;
        this.value = Mth.clamp((double)((x - (double)this.getX()) / ((double)this.width - 1.0)), (double)0.0, (double)1.0);
        if (oldValue != this.value) {
            this.applyValue();
        }
        this.updateMessage();
    }
}

