/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.helper;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.components.toasts.ToastManager;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.tuple.Pair;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.RenderHelper;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public final class CustomToast
implements Toast {
    public static final CustomToast INSTANCE = new CustomToast();
    private static final long DISPLAY_TIME = 5000L;
    private final Component title = LangKey.MESSAGE_COMBINE_IN_INVENTORY.getText(new Object[0]);
    private Pair<ItemStack, ItemStack> combination;
    private Component description;
    private long lastChanged;
    private boolean changed;
    private Toast.Visibility wantedVisibility = Toast.Visibility.HIDE;

    private CustomToast() {
    }

    public Object getToken() {
        return this;
    }

    public int width() {
        return 200;
    }

    public int height() {
        return 50;
    }

    public void addCombination(ItemStack initial, ItemStack added, Component description) {
        ToastManager toastManager = Minecraft.getInstance().getToastManager();
        CustomToast customToast = (CustomToast)toastManager.getToast(this.getClass(), this.getToken());
        if (customToast == null) {
            toastManager.queued.add(this);
        }
        this.combination = Pair.of((Object)initial, (Object)added);
        this.description = description;
        this.changed = true;
    }

    public Toast.Visibility getWantedVisibility() {
        return this.wantedVisibility;
    }

    public void update(ToastManager toastManager, long time) {
        if (this.changed) {
            this.lastChanged = time;
            this.changed = false;
        }
        this.wantedVisibility = this.combination == null || Optional.ofNullable(Minecraft.getInstance().screen).map(Screen::showsActiveEffects).orElse(false) == false ? Toast.Visibility.HIDE : (time - this.lastChanged >= 5000L ? Toast.Visibility.HIDE : Toast.Visibility.SHOW);
    }

    public void render(GuiGraphics guiGraphics, Font font, long time) {
        Objects.requireNonNull(font);
        int lineHeight = 9;
        List splits = font.split((FormattedText)this.description, this.width());
        int y = (Minecraft.getInstance().getWindow().getGuiScaledHeight() - this.height()) / 2;
        guiGraphics.fill(0, y, this.width(), y + 22 + lineHeight * splits.size(), -341384);
        guiGraphics.fill(1, y + 1, this.width(), y + 21 + lineHeight * splits.size(), -14274713);
        guiGraphics.fill(4, y + 2, 20, y + 18, -4144960);
        guiGraphics.fill(48, y + 2, 64, y + 18, -4144960);
        guiGraphics.drawString(font, this.title.getString(), 70, y + 6, -341384, false);
        int height = y + 20;
        for (FormattedCharSequence split : splits) {
            guiGraphics.drawString(font, split, 4, height, -11141121, false);
            height += lineHeight;
        }
        ItemStack left = (ItemStack)this.combination.getLeft();
        ItemStack right = (ItemStack)this.combination.getRight();
        guiGraphics.pose().pushMatrix();
        guiGraphics.pose().translate(0.0f, (float)y);
        guiGraphics.renderItem(left, 4, 2);
        RenderHelper.Sprites.MOUSE_ON.render(guiGraphics, 32, 2, 0.8f);
        RenderHelper.Sprites.ARROW_SPRITE.render(guiGraphics, 20, 6, 0.7f);
        guiGraphics.pose().translate(44.0f, 0.0f);
        guiGraphics.renderItem(right, 4, 2);
        guiGraphics.pose().popMatrix();
    }
}

