/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.helper;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.Direction;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetExperiencePacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.LevelChunk;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;
import ovh.corail.tombstone.ModTombstone;
import ovh.corail.tombstone.block.BlockGraveBase;
import ovh.corail.tombstone.block.entity.BlockEntityPlayerGrave;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.helper.EffectHelper;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.InventoryHelper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.helper.NBTHelper;
import ovh.corail.tombstone.helper.PlayerPreference;
import ovh.corail.tombstone.helper.SpawnHelper;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.helper.WorldHelper;
import ovh.corail.tombstone.registry.ModBlocks;
import ovh.corail.tombstone.registry.ModEffects;
import ovh.corail.tombstone.registry.ModItems;
import ovh.corail.tombstone.registry.ModPerks;
import ovh.corail.tombstone.registry.ModTriggers;

public final class DeathHandler {
    public static final DeathHandler INSTANCE = new DeathHandler();
    public final Set<Location> ALLOWED_REMOVALS = ConcurrentHashMap.newKeySet();
    private final Map<UUID, Location> GROUND_LOCATIONS = new ConcurrentHashMap<UUID, Location>();
    private static final String IS_PLAYER_DEAD_NBT_BOOL = "tb_is_player_dead";
    private static final String PRESERVED_EFFECTS_NBT_LIST = "tb_preserved_effects";
    private static final String GRAVE_LOCATIONS_NBT_LIST = "tb_grave_locations";
    private static final String SOULBOUND_STACKS_NBT_LIST = "tb_soulbound_stacks";
    private static final String KEY_STACKS_NBT_LIST = "tb_key_stacks";
    private static final String LAST_OFFHAND_ITEM = "tb_last_offhand_item";
    private static final String LAST_GROUND_LOCATION = "tb_last_ground_location";

    private DeathHandler() {
    }

    public Location getLastGrave(MinecraftServer server, ServerPlayer player) {
        List<Location> graveLocations = this.getGraveList(player);
        for (Location lastGrave : graveLocations) {
            ServerLevel currentWorld;
            if (lastGrave.isOrigin() || (currentWorld = server.getLevel(lastGrave.dim)) == null) continue;
            if (Helper.getPlayerGrave((Level)currentWorld, lastGrave.getPos()).isPresent()) {
                return lastGrave;
            }
            this.removeGrave(player, lastGrave);
        }
        return Location.ORIGIN;
    }

    public void removeGrave(ServerPlayer player, Location pos) {
        ListTag list = NBTHelper.getListOrCreate(EntityHelper.getPersistentTag((Player)player), GRAVE_LOCATIONS_NBT_LIST);
        Iterator it = list.iterator();
        while (it.hasNext()) {
            if (!pos.equals(NBTHelper.getLocation((CompoundTag)it.next(), "location"))) continue;
            it.remove();
            break;
        }
        if (list.size() > 20) {
            it = list.iterator();
            for (int removedCount = list.size() - 20; removedCount > 0 && it.hasNext(); --removedCount) {
                it.next();
                it.remove();
            }
        }
    }

    public List<Location> getGraveList(ServerPlayer player) {
        LinkedList<Location> graveLocations = new LinkedList<Location>();
        ListTag nbtList = NBTHelper.getListOrCreate(EntityHelper.getPersistentTag((Player)player), GRAVE_LOCATIONS_NBT_LIST);
        for (int i = nbtList.size() - 1; i >= 0; --i) {
            graveLocations.add(NBTHelper.getLocation(nbtList.getCompoundOrEmpty(i), "location"));
        }
        return graveLocations;
    }

    public void onPlayerDead(ServerPlayer player, DamageSource source) {
        int timeSinceDeath = player.getStats().getValue(Stats.CUSTOM.get((Object)Stats.TIME_SINCE_DEATH));
        if (timeSinceDeath < TimeHelper.tickFromMinute(1)) {
            if (player.getStats().getValue(Stats.CUSTOM.get((Object)Stats.DEATHS)) > 1) {
                ModTriggers.chain_death.trigger(player);
            }
        } else if (timeSinceDeath >= TimeHelper.tickFromHour(1)) {
            ModTriggers.strong_or_careful.trigger(player);
            if (timeSinceDeath >= TimeHelper.tickFromHour(10)) {
                ModTriggers.almost_unkillable.trigger(player);
            }
        }
        CompoundTag persistentTag = EntityHelper.getPersistentTag((Player)player);
        NBTHelper.setBoolean(persistentTag, IS_PLAYER_DEAD_NBT_BOOL, true);
        boolean hasPreservation = player.hasEffect(ModEffects.preservation);
        if (hasPreservation || ((Boolean)ConfigTombstone.player_death.restoreEffectsOnDeath.get()).booleanValue()) {
            NBTHelper.setEffects(player.registryAccess(), persistentTag, PRESERVED_EFFECTS_NBT_LIST, player.getActiveEffects().stream().filter(EffectHelper::isAllowedEffect).collect(Collectors.toList()));
        }
        this.storeExperience(player, source, hasPreservation, persistentTag);
        NBTHelper.setString(persistentTag, LAST_OFFHAND_ITEM, BuiltInRegistries.ITEM.getKey((Object)player.getOffhandItem().getItem()).toString());
    }

    private void storeExperience(ServerPlayer player, DamageSource source, boolean hasPreservation, CompoundTag persistentTag) {
        int xpTotal = EntityHelper.getPlayerTotalXp((Player)player);
        if (!hasPreservation) {
            int toRemove;
            ServerPlayer killer;
            if ((Integer)SharedConfigTombstone.player_death.xpLossOnDeath.get() > 0) {
                xpTotal = Mth.floor((double)((double)(xpTotal * Math.min(100 - (Integer)SharedConfigTombstone.player_death.xpLossOnDeath.get() + EntityHelper.getPerkLevelWithBonus((Player)player, ModPerks.memento_mori) * 20, 100)) / 100.0));
            }
            if (xpTotal > 0 && Optional.ofNullable(player.getServer()).map(MinecraftServer::isPvpAllowed).orElse(false).booleanValue() && EntityHelper.isKilledByOtherPlayer((Player)player, source) && (killer = (ServerPlayer)source.getEntity()) != null && (toRemove = Mth.floor((double)((double)(xpTotal * (Integer)ConfigTombstone.player_death.pvpStolenXp.get()) / 100.0))) > 0) {
                xpTotal -= toRemove;
                killer.giveExperiencePoints(toRemove);
                LangKey.MESSAGE_PVP_STEAL_EXPERIENCE.sendMessage(player, toRemove, player.getName());
            }
        }
        NBTHelper.setInt(persistentTag, "tb_experience_total", xpTotal);
        Pair<Integer, Float> pair = EntityHelper.getPlayerXpPair(xpTotal);
        NBTHelper.setInt(persistentTag, "tb_experience_level", (Integer)pair.getLeft());
        NBTHelper.setFloat(persistentTag, "tb_experience_bar", ((Float)pair.getRight()).floatValue());
    }

    private void restoreSoulbounds(ServerPlayer player) {
        CompoundTag persistentTag = EntityHelper.getPersistentTag((Player)player);
        NBTHelper.getListOrEmpty(persistentTag, SOULBOUND_STACKS_NBT_LIST).ifPresent(list -> list.forEach(tag -> ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)NBTHelper.readItemStack(player.registryAccess(), (CompoundTag)tag))));
        NBTHelper.remove(persistentTag, SOULBOUND_STACKS_NBT_LIST);
        NBTHelper.getListOrEmpty(persistentTag, KEY_STACKS_NBT_LIST).ifPresent(list -> list.forEach(tag -> ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)NBTHelper.readItemStack(player.registryAccess(), (CompoundTag)tag))));
        NBTHelper.remove(persistentTag, KEY_STACKS_NBT_LIST);
    }

    public boolean canRemovePlayerGrave(Level level, BlockPos pos) {
        return this.ALLOWED_REMOVALS.contains(new Location(pos, level));
    }

    public void removeAndEmptyPlayerGrave(Level level, BlockPos pos) {
        pos = pos.immutable();
        Location locationId = new Location(pos, level);
        this.ALLOWED_REMOVALS.add(locationId);
        level.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
        this.ALLOWED_REMOVALS.remove(locationId);
    }

    public void handleRespawn(ServerPlayer player) {
        this.restoreSoulbounds(player);
        CompoundTag persistentTag = EntityHelper.getPersistentTag((Player)player);
        if (NBTHelper.getBoolean(persistentTag, IS_PLAYER_DEAD_NBT_BOOL)) {
            this.restorePlayer(player, persistentTag);
        }
        player.inventoryMenu.broadcastChanges();
    }

    private void restorePlayer(ServerPlayer player, CompoundTag persistentTag) {
        if (PlayerPreference.get(player).getAutoEquipRule().equipOnRespawn()) {
            InventoryHelper.autoequip(player, new ItemStackHandler(player.getInventory().getNonEquipmentItems()), Items.AIR);
        }
        EffectHelper.addGhostlyShape((Player)player);
        NBTHelper.remove(persistentTag, IS_PLAYER_DEAD_NBT_BOOL);
        List<MobEffectInstance> effectInstances = NBTHelper.getEffects(player.registryAccess(), persistentTag, PRESERVED_EFFECTS_NBT_LIST, EffectHelper::isAllowedEffect);
        if (!effectInstances.isEmpty()) {
            effectInstances.forEach(effectInstance -> EffectHelper.addEffect((LivingEntity)player, effectInstance));
            NBTHelper.remove(persistentTag, PRESERVED_EFFECTS_NBT_LIST);
        }
        if (persistentTag.contains("tb_experience_total")) {
            player.totalExperience = NBTHelper.getInt(persistentTag, "tb_experience_total");
            player.experienceLevel = NBTHelper.getInt(persistentTag, "tb_experience_level");
            player.experienceProgress = NBTHelper.getFloat(persistentTag, "tb_experience_bar");
            NBTHelper.remove(persistentTag, "tb_experience_total", "tb_experience_level", "tb_experience_bar");
            player.connection.send((Packet)new ClientboundSetExperiencePacket(player.experienceProgress, player.totalExperience, player.experienceLevel));
        }
    }

    public void handleSoulbound(ServerPlayer player, Collection<ItemEntity> loots) {
        loots.addAll(player.level().getEntitiesOfClass(ItemEntity.class, Helper.createBounds(player.blockPosition(), ((Integer)ConfigTombstone.player_death.snifferRange.get()).intValue()), e -> e != null && (e.getOwner() == null || player.getGameProfile().getId().equals(e.getOwner().getUUID()))));
        this.storeSoulboundsOnBody(player, loots.iterator());
    }

    public void handleLoot(ServerPlayer player, Collection<ItemEntity> loots, DamageSource damageSource) {
        BlockState state;
        boolean hasGrave;
        int countDrop = loots.size();
        if (countDrop == 0) {
            LangKey.MESSAGE_NO_LOOT_FOR_GRAVE.sendSpecialMessage(player, new Object[0]);
            return;
        }
        MinecraftServer server = Objects.requireNonNull(player.getServer());
        ServerLevel level = player.level();
        boolean isAllowedDimension = this.isAllowedDimensionForGraves(level);
        PlayerPreference playerPreference = PlayerPreference.get(player);
        BlockPos initPos = WorldHelper.getCloserValidPos((Level)level, player.blockPosition());
        Location spawnPos = Location.ORIGIN;
        if (isAllowedDimension && ((Boolean)ConfigTombstone.player_death.allowToFillExistingGrave.get()).booleanValue()) {
            spawnPos = this.findExistingGraveLocation(server, player, initPos, countDrop);
        }
        boolean bl = hasGrave = !spawnPos.isOrigin();
        if (!hasGrave) {
            if (isAllowedDimension) {
                spawnPos = new SpawnHelper(level, initPos).withPlayerPreference(playerPreference).findGravePlace();
                if (spawnPos.isOrigin() && (spawnPos = this.findGraveLocationFromLastGroundLocation(server, player, playerPreference)).isOrigin() && (spawnPos = this.findGraveLocationFromRespawnLocation(server, player, playerPreference)).isOrigin()) {
                    spawnPos = new Location(initPos, (Level)level);
                }
            } else {
                spawnPos = this.findGraveLocationFromRespawnLocation(server, player, playerPreference);
                if (spawnPos.isOrigin()) {
                    LangKey.MESSAGE_NO_GRAVE_DIMENSION.sendSpecialMessage(player, new Object[0]);
                    return;
                }
            }
        }
        if (!hasGrave) {
            NBTHelper.getListOrCreate(EntityHelper.getPersistentTag((Player)player), GRAVE_LOCATIONS_NBT_LIST).add((Object)NBTHelper.setLocation(new CompoundTag(), "location", spawnPos));
            ModTombstone.LOGGER.debug("A new grave of the player " + player.getGameProfile().getName() + " was created at position [x:" + spawnPos.x + ", y:" + spawnPos.y + ", z:" + spawnPos.z + ", dim:" + spawnPos.getDimString() + "]");
            Direction facing = player.getDirection().getOpposite();
            Block graveBlock = ModBlocks.PLAYER_GRAVES.get((Object)playerPreference.getFavoriteGrave());
            state = (BlockState)((BlockState)graveBlock.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)facing)).setValue((Property)BlockGraveBase.MODEL_TEXTURE, (Comparable)Integer.valueOf(playerPreference.getMarbleType().ordinal()));
            level = Objects.requireNonNull(server.getLevel(spawnPos.dim));
            level.setBlockAndUpdate(spawnPos.getPos(), state);
        } else {
            state = level.getBlockState(spawnPos.getPos());
        }
        BlockEntityPlayerGrave grave = Helper.getPlayerGrave((Level)level, spawnPos.getPos()).orElse(null);
        if (grave == null) {
            LangKey.MESSAGE_FAIL_TO_PLACE_GRAVE.sendSpecialMessage(player, new Object[0]);
            ModTombstone.LOGGER.debug((Object)LangKey.MESSAGE_FAIL_TO_PLACE_GRAVE.getText(new Object[0]));
            return;
        }
        if (hasGrave) {
            grave.resetDeathTime();
        }
        CompoundTag persistentTag = EntityHelper.getPersistentTag((Player)player);
        NBTHelper.getString(persistentTag, LAST_OFFHAND_ITEM).flatMap(s -> Optional.ofNullable(ResourceLocation.tryParse((String)s)).map(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.ITEM).getValue(arg_0))).ifPresent(grave::setLastOffhandItem);
        NBTHelper.remove(persistentTag, LAST_OFFHAND_ITEM);
        boolean needAccess = (Integer)SharedConfigTombstone.player_death.decayTime.get() != 0 && (!server.isPvpAllowed() || (Boolean)ConfigTombstone.player_death.pvpUnlockGrave.get() == false || !EntityHelper.isKilledByOtherPlayer((Player)player, damageSource));
        MutableComponent locked = Component.literal((String)"[").append((Component)(needAccess ? LangKey.MESSAGE_LOCKED.getText(new Object[0]).append((String)((Integer)SharedConfigTombstone.player_death.decayTime.get() > 0 ? " " + String.valueOf(SharedConfigTombstone.player_death.decayTime.get()) + " min" : "")) : LangKey.MESSAGE_UNLOCKED.getText(new Object[0]))).append("]").setStyle(needAccess ? StyleType.COLOR_RED : StyleType.COLOR_GREEN);
        player.sendSystemMessage((Component)(hasGrave ? LangKey.MESSAGE_EXISTING_GRAVE : LangKey.MESSAGE_NEW_GRAVE).getText(StyleType.MESSAGE_SPECIAL, new Object[0]).append(" ").append((Component)locked));
        player.sendSystemMessage((Component)Component.literal((String)"[x: ").append(String.valueOf(spawnPos.x)).append(", y: ").append(String.valueOf(spawnPos.y)).append(", z: ").append(String.valueOf(spawnPos.z)).append("]").append((Component)Component.literal((String)" in ").append(spawnPos.getDimString())));
        Location finalSpawnPos = spawnPos;
        ListTag keyList = NBTHelper.getListOrCreate(EntityHelper.getPersistentTag((Player)player), KEY_STACKS_NBT_LIST);
        boolean found = false;
        RegistryAccess registryAccess = level.registryAccess();
        for (int i = 0; i < keyList.size(); ++i) {
            ItemStack key = NBTHelper.readItemStack(registryAccess, keyList.getCompoundOrEmpty(i));
            if (!ModItems.grave_key.getTombPos(key).equals(finalSpawnPos)) continue;
            ModItems.grave_key.reenchantOnDeath((Player)player, key);
            keyList.set(i, (Tag)NBTHelper.saveItemStack(registryAccess, key));
            found = true;
            break;
        }
        if (!found && ModItems.grave_key.isEnabled()) {
            ItemStack key = ModItems.grave_key.createWithInfo((Player)player, finalSpawnPos);
            ModItems.grave_key.reenchantOnDeath((Player)player, key);
            keyList.add((Object)NBTHelper.saveItemStack(registryAccess, key));
        }
        grave.setOwner((Player)player, TimeHelper.systemTime(), needAccess);
        IItemHandler itemHandler = grave.getInventory();
        loots.forEach(e -> e.setItem(ItemHandlerHelper.insertItemStacked((IItemHandler)itemHandler, (ItemStack)e.getItem().copy(), (boolean)false)));
        grave.setChanged();
        level.sendBlockUpdated(spawnPos.getPos(), Blocks.AIR.defaultBlockState(), state, 2);
        ModTriggers.first_grave.trigger(player);
        if (loots.size() <= itemHandler.getSlots()) {
            try {
                loots.clear();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
    }

    private Location findGraveLocationFromLastGroundLocation(MinecraftServer server, ServerPlayer player, PlayerPreference playerPreference) {
        ServerLevel world;
        Location lastGroundLocation = this.getGroundLocation(player);
        if (!lastGroundLocation.isOrigin() && (world = server.getLevel(lastGroundLocation.dim)) != null) {
            return new SpawnHelper(world, lastGroundLocation.getPos()).withPlayerPreference(playerPreference).findGravePlace();
        }
        return Location.ORIGIN;
    }

    private Location findGraveLocationFromRespawnLocation(MinecraftServer server, ServerPlayer player, PlayerPreference playerPreference) {
        // Could not load outer class - annotation placement on inner may be incorrect
        @Nullable ServerPlayer.RespawnConfig respawnConfig = player.getRespawnConfig();
        if (respawnConfig != null) {
            Location spawnPos;
            ServerLevel world;
            BlockPos respawnPosition = respawnConfig.pos();
            ResourceKey respawnDimension = respawnConfig.dimension();
            if (this.isAllowedDimensionForGraves((ResourceKey<Level>)respawnDimension) && (world = server.getLevel(respawnDimension)) != null && !(spawnPos = new SpawnHelper(world, respawnPosition).withPlayerPreference(playerPreference).findGravePlace()).isOrigin()) {
                return spawnPos;
            }
        }
        ServerLevel overworld = server.overworld();
        return new SpawnHelper(overworld, overworld.getSharedSpawnPos()).withPlayerPreference(playerPreference).findGravePlace();
    }

    private Location findExistingGraveLocation(MinecraftServer server, ServerPlayer player, BlockPos initPos, int countDrop) {
        ServerLevel currentLevel = player.level();
        Optional<BlockEntityPlayerGrave> playerGrave = new CopyOnWriteArrayList(currentLevel.blockEntityTickers).stream().map(tileTicker -> {
            try {
                BlockEntity blockEntity = ((LevelChunk.BoundTickingBlockEntity)((LevelChunk.RebindableTickingBlockEntityWrapper)tileTicker).ticker).blockEntity;
                if (ModBlocks.isPlayerGrave(blockEntity.getBlockState().getBlock())) {
                    return (BlockEntityPlayerGrave)blockEntity;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return null;
        }).filter(Objects::nonNull).filter(t -> Helper.getDistanceSq((Vec3i)t.getBlockPos(), (Vec3i)initPos) <= 400.0).filter(t -> t.getOwnerName().equals(player.getGameProfile().getName()) && InventoryHelper.hasEnoughSlots(t.getInventory(), countDrop)).min(Comparator.comparingInt(a -> a.getBlockPos().distManhattan((Vec3i)initPos)));
        if (playerGrave.isPresent()) {
            return new Location(playerGrave.get().getBlockPos(), (Level)currentLevel);
        }
        Location lastGrave = this.getLastGrave(server, player);
        if (!lastGrave.isOrigin() && lastGrave.isSameDimension((Level)currentLevel) && Helper.getDistanceSq((Vec3i)lastGrave.getPos(), (Vec3i)initPos) <= 400.0 && Helper.getPlayerGrave((Level)currentLevel, lastGrave.getPos()).filter(t -> InventoryHelper.hasEnoughSlots(t.getInventory(), countDrop)).isPresent()) {
            return lastGrave;
        }
        return Location.ORIGIN;
    }

    private void storeSoulboundsOnBody(ServerPlayer player, Iterator<ItemEntity> it) {
        CompoundTag persistentTag = EntityHelper.getPersistentTag((Player)player);
        ListTag keyList = NBTHelper.getListOrCreate(persistentTag, KEY_STACKS_NBT_LIST);
        ListTag stackList = NBTHelper.getListOrCreate(persistentTag, SOULBOUND_STACKS_NBT_LIST);
        while (it.hasNext()) {
            ItemStack stack;
            ItemEntity entityItem = it.next();
            if (entityItem == null || (stack = entityItem.getItem()).isEmpty()) {
                it.remove();
                continue;
            }
            if (!Helper.isSoulbound(stack, (Level)player.level())) continue;
            if (stack.is((Item)ModItems.grave_key)) {
                keyList.add((Object)NBTHelper.saveItemStack(player.registryAccess(), stack));
            } else {
                stackList.add((Object)NBTHelper.saveItemStack(player.registryAccess(), stack));
            }
            entityItem.setItem(ItemStack.EMPTY);
            it.remove();
        }
    }

    private boolean isAllowedDimensionForGraves(ServerLevel level) {
        return this.isAllowedDimensionForGraves((ResourceKey<Level>)level.dimension());
    }

    private boolean isAllowedDimensionForGraves(ResourceKey<Level> levelRK) {
        return !((List)ConfigTombstone.player_death.noGraveDimension.get()).contains(levelRK.location().toString());
    }

    public Location getGroundLocation(ServerPlayer player) {
        Location groundLocation = this.GROUND_LOCATIONS.get(player.getUUID());
        if (groundLocation != null) {
            return groundLocation;
        }
        Location storedLocation = NBTHelper.getLocation(EntityHelper.getPersistentTag((Player)player), LAST_GROUND_LOCATION);
        if (!storedLocation.isOrigin()) {
            this.GROUND_LOCATIONS.put(player.getUUID(), storedLocation);
        }
        return storedLocation;
    }

    public void setGroundLocations(MinecraftServer server) {
        if (!TimeHelper.atInterval((Level)server.overworld(), 20)) {
            return;
        }
        server.getPlayerList().getPlayers().stream().filter(EntityHelper::isValidServerPlayer).filter(Entity::onGround).filter(p -> !p.isDeadOrDying()).filter(p -> !p.isInLava()).forEach(this::setGroundLocation);
    }

    private void setGroundLocation(ServerPlayer player) {
        this.GROUND_LOCATIONS.put(player.getUUID(), new Location((Entity)player));
    }

    public void storeGroundLocation(ServerPlayer player) {
        Optional.ofNullable(this.GROUND_LOCATIONS.get(player.getUUID())).ifPresent(location -> NBTHelper.setLocation(EntityHelper.getPersistentTag((Player)player), LAST_GROUND_LOCATION, location));
    }

    private void storeGroundLocations(MinecraftServer server) {
        server.getPlayerList().getPlayers().stream().filter(EntityHelper::isValidServerPlayer).forEach(this::storeGroundLocation);
    }

    public void clear(MinecraftServer server) {
        this.ALLOWED_REMOVALS.clear();
        this.storeGroundLocations(server);
        this.GROUND_LOCATIONS.clear();
    }
}

