/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.helper;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.ItemLike;
import net.neoforged.fml.util.ObfuscationReflectionHelper;
import net.neoforged.neoforge.event.EventHooks;
import org.jetbrains.annotations.Nullable;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.RegistryHelper;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.registry.ModDataComponents;
import ovh.corail.tombstone.registry.ModEffects;
import ovh.corail.tombstone.registry.ModPotions;

public final class EffectHelper {
    private static final Method METHOD_ON_EFFECT_REMOVED = ObfuscationReflectionHelper.findMethod(LivingEntity.class, (String)"onEffectsRemoved", (Class[])new Class[]{Collection.class});
    public static final Function<Random, Integer> RANDOM_EFFECT_LEVEL = random -> {
        int roll = random.nextInt(100) + 1;
        return roll < 10 ? 4 : (roll < 25 ? 3 : (roll < 45 ? 2 : (roll < 70 ? 1 : 0)));
    };

    public static int getDuration(@Nullable LivingEntity entity, Holder<MobEffect> effect) {
        MobEffectInstance effectInstance;
        return entity != null && (effectInstance = entity.getEffect(effect)) != null ? effectInstance.getDuration() : 0;
    }

    public static int getDuration(@Nullable LivingEntity entity, Holder<MobEffect> effect, int amplifier) {
        if (entity == null) {
            return 0;
        }
        MobEffectInstance currentEffectInstance = entity.getEffect(effect);
        while (currentEffectInstance != null) {
            if (currentEffectInstance.getAmplifier() < amplifier) {
                return 0;
            }
            if (currentEffectInstance.getAmplifier() == amplifier) {
                return currentEffectInstance.getDuration();
            }
            currentEffectInstance = currentEffectInstance.hiddenEffect;
        }
        return 0;
    }

    public static void capDuration(LivingEntity entity, Holder<MobEffect> effectHolder, int maxDuration) {
        MobEffectInstance effectInstance = (MobEffectInstance)entity.getActiveEffectsMap().get(effectHolder);
        if (EffectHelper.capEffect(effectInstance, maxDuration)) {
            EffectHelper.clearEffect(entity, effectHolder);
            EffectHelper.addEffect(entity, effectInstance);
        }
    }

    private static boolean capEffect(@Nullable MobEffectInstance effectInstance, int maxDuration) {
        if (effectInstance == null) {
            return false;
        }
        if (effectInstance.getDuration() < maxDuration) {
            return EffectHelper.capEffect(effectInstance.hiddenEffect, maxDuration);
        }
        effectInstance.duration = maxDuration;
        effectInstance.hiddenEffect = null;
        return true;
    }

    public static void modifyEffectDuration(MobEffectInstance effectInstance, Function<MobEffectInstance, Integer> function) {
        effectInstance.duration = function.apply(effectInstance);
        if (effectInstance.hiddenEffect != null) {
            EffectHelper.modifyEffectDuration(effectInstance.hiddenEffect, function);
        }
    }

    public static MobEffectInstance copyEffectWithHidden(MobEffectInstance effectInstance) {
        MobEffectInstance effectCopy = new MobEffectInstance(effectInstance);
        if (effectInstance.hiddenEffect != null) {
            effectCopy.hiddenEffect = EffectHelper.copyEffectWithHidden(effectInstance.hiddenEffect);
        }
        return effectCopy;
    }

    public static boolean isUnstableIntangibilityActive(@Nullable LivingEntity entity) {
        return TimeHelper.inIntervalAfter(EffectHelper.getDuration(entity, ModEffects.unstable_intangibility), 100, 79);
    }

    public static void addEffect(@Nullable LivingEntity entity, Holder<MobEffect> effectHolder, int duration) {
        EffectHelper.addEffect(entity, effectHolder, duration, 0, new boolean[0]);
    }

    public static void addEffect(@Nullable LivingEntity entity, Holder<MobEffect> effectHolder, int duration, int amplifier, boolean ... params) {
        if (entity != null) {
            entity.addEffect(new MobEffectInstance(effectHolder, duration, amplifier, params.length == 0 || params[0], params.length <= 1 || params[1]));
        }
    }

    public static void addEffect(@Nullable LivingEntity entity, MobEffectInstance effectInstance) {
        if (entity != null && effectInstance.getEffect() != null) {
            entity.addEffect(effectInstance);
        }
    }

    public static void addGhostlyShape(Player player) {
        int duration = (Integer)SharedConfigTombstone.player_death.ghostlyShapeDuration.get();
        if (duration > 0) {
            EffectHelper.addEffect((LivingEntity)player, ModEffects.ghostly_shape, duration * 20);
        }
    }

    public static boolean clearEffect(@Nullable LivingEntity entity, Holder<MobEffect> effectHolder) {
        if (entity != null && !entity.level().isClientSide()) {
            EventHooks.onEffectRemoved((LivingEntity)entity, effectHolder);
            MobEffectInstance effectInstance = entity.removeEffectNoUpdate(effectHolder);
            if (effectInstance != null) {
                try {
                    METHOD_ON_EFFECT_REMOVED.invoke((Object)entity, List.of(effectInstance));
                    return true;
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
        }
        return false;
    }

    public static void clearEffect(LivingEntity entity, Predicate<MobEffect> predic) {
        if (!entity.level().isClientSide()) {
            Iterator it = entity.getActiveEffectsMap().entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                Holder effectHolder = (Holder)entry.getKey();
                if (!predic.test((MobEffect)effectHolder.value())) continue;
                try {
                    EventHooks.onEffectRemoved((LivingEntity)entity, (Holder)effectHolder);
                    it.remove();
                    METHOD_ON_EFFECT_REMOVED.invoke((Object)entity, List.of((MobEffectInstance)entry.getValue()));
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void clearBadEffects(@Nullable LivingEntity entity) {
        if (entity != null) {
            EffectHelper.clearEffect(entity, EffectHelper::isHarmful);
            if (entity.isOnFire()) {
                entity.clearFire();
            }
            if (entity.hasGlowingTag()) {
                entity.setGlowingTag(false);
            }
        }
    }

    @Nullable
    public static MobEffectInstance getRandomEffect(int duration, boolean isBad) {
        return EffectHelper.getRandomEffect(duration, isBad, true, RANDOM_EFFECT_LEVEL);
    }

    @Nullable
    public static MobEffectInstance getRandomEffect(int duration, boolean isBad, boolean acceptInstantEffect, Function<Random, Integer> functionEffectLevel) {
        return EffectHelper.getRandomEffect(duration, isBad ? EffectHelper::isBadEffect : EffectHelper::isAllowedEffect, acceptInstantEffect, functionEffectLevel);
    }

    @Nullable
    public static MobEffectInstance getRandomEffect(int duration, Predicate<MobEffect> predic, boolean acceptInstantEffect, Function<Random, Integer> functionEffectLevel) {
        if (!acceptInstantEffect) {
            predic = predic.and(effect -> !effect.isInstantenous());
        }
        return RegistryHelper.findRandomHolder(BuiltInRegistries.MOB_EFFECT, predic).map(effectHolder -> new MobEffectInstance(effectHolder, ((MobEffect)effectHolder.value()).isInstantenous() ? 1 : duration, ((Integer)functionEffectLevel.apply(Helper.RANDOM)).intValue())).orElse(null);
    }

    public static void addRandomEffect(Player player, int duration, boolean withMessage, boolean isBad, boolean acceptInstantEffect) {
        MobEffectInstance effectInstance = EffectHelper.getRandomEffect(duration, isBad, acceptInstantEffect, RANDOM_EFFECT_LEVEL);
        if (effectInstance != null) {
            if (withMessage && EntityHelper.isValidServerPlayer((Entity)player)) {
                LangKey.MESSAGE_SPELL_CAST_ON_YOU.sendMessage((ServerPlayer)player, StyleType.MESSAGE_SPELL, new Object[]{((MobEffect)effectInstance.getEffect().value()).getDisplayName().plainCopy().setStyle(StyleType.MESSAGE_SPECIAL)});
            }
            EffectHelper.addEffect((LivingEntity)player, effectInstance);
        }
    }

    public static boolean isHarmful(@Nullable MobEffect effect) {
        return effect != null && !effect.isBeneficial() && effect.getCategory() != MobEffectCategory.NEUTRAL;
    }

    public static boolean isBadEffect(@Nullable MobEffect effect) {
        return EffectHelper.isHarmful(effect) && !Helper.containRL((List)ConfigTombstone.general.unhandledHarmfulEffects.get(), BuiltInRegistries.MOB_EFFECT.getKey((Object)effect));
    }

    public static boolean isBeneficial(@Nullable MobEffect effect) {
        return effect != null && effect.isBeneficial();
    }

    public static boolean isAllowedEffect(@Nullable MobEffectInstance effectInstance) {
        return effectInstance != null && EffectHelper.isAllowedEffect((MobEffect)effectInstance.getEffect().value());
    }

    public static boolean isAllowedEffect(@Nullable MobEffect effect) {
        return EffectHelper.isBeneficial(effect) && !Helper.containRL((List)ConfigTombstone.general.unhandledBeneficialEffects.get(), BuiltInRegistries.MOB_EFFECT.getKey((Object)effect));
    }

    public static ItemStack createMagicArrows(int count, Holder<MobEffect> effectHolder) {
        return EffectHelper.createMagicArrows(count, effectHolder, 0);
    }

    public static ItemStack createMagicArrows(int count, Holder<MobEffect> effectHolder, int amplifier) {
        return EffectHelper.createMagicArrows(count, new MobEffectInstance(effectHolder, 3200, amplifier));
    }

    public static ItemStack createMagicArrows(int count, MobEffectInstance ... effectInstances) {
        ItemStack arrow = new ItemStack((ItemLike)Items.TIPPED_ARROW, count);
        arrow.set(DataComponents.POTION_CONTENTS, (Object)new PotionContents(Optional.empty(), Optional.of(effectInstances.length > 1 ? -16777216 : ((MobEffect)effectInstances[0].getEffect().value()).getColor()), Arrays.stream(effectInstances).collect(Collectors.toList()), Optional.empty()));
        arrow.set(ModDataComponents.ENCHANTED_ARROW, (Object)true);
        return arrow;
    }

    public static ItemStack createRandomArrows(int count) {
        @Nullable MobEffectInstance effect = EffectHelper.getRandomEffect(3200, true);
        if (effect != null) {
            return EffectHelper.createMagicArrows(count, effect);
        }
        return new ItemStack((ItemLike)Items.SPECTRAL_ARROW, count);
    }

    public static ItemStack createCursedArrows(int count) {
        ArrayList list = new ArrayList();
        IntStream.range(0, 5).forEach(i -> Optional.ofNullable(EffectHelper.getRandomEffect(3200, e -> EffectHelper.isBadEffect(e) && list.stream().noneMatch(instance -> instance.getEffect().value() == e), true, RANDOM_EFFECT_LEVEL)).ifPresent(list::add));
        if (!list.isEmpty()) {
            return EffectHelper.createMagicArrows(count, list.toArray(new MobEffectInstance[0]));
        }
        return new ItemStack((ItemLike)Items.SPECTRAL_ARROW, count);
    }

    public static String getPotency(int amplifier) {
        return amplifier <= 1 ? "" : Helper.getRomanNumber(amplifier);
    }

    public static boolean isPotionEnabled(Holder<Potion> potionHolder) {
        if (potionHolder.unwrapKey().map(key -> "tombstone".equals(key.location().getNamespace())).orElse(false).booleanValue()) {
            if (potionHolder.is(ModPotions.spectral)) {
                return true;
            }
            if (potionHolder.is(ModPotions.earthly_garden)) {
                return (Boolean)SharedConfigTombstone.potions.allowEarthlyGarden.get();
            }
            if (potionHolder.is(ModPotions.bait)) {
                return (Boolean)SharedConfigTombstone.potions.allowBait.get();
            }
            if (potionHolder.is(ModPotions.frostbite)) {
                return (Boolean)SharedConfigTombstone.potions.allowFrostbite.get();
            }
            if (potionHolder.is(ModPotions.darkness)) {
                return (Boolean)SharedConfigTombstone.potions.allowDarkness.get();
            }
            if (potionHolder.is(ModPotions.discretion)) {
                return (Boolean)SharedConfigTombstone.potions.allowDiscretion.get();
            }
            if (potionHolder.is(ModPotions.restoration)) {
                return (Boolean)SharedConfigTombstone.potions.allowRestoration.get();
            }
            if (potionHolder.is(ModPotions.weaver_walk)) {
                return (Boolean)SharedConfigTombstone.potions.allowWeaverWalk.get();
            }
            if (potionHolder.is(ModPotions.giant_strength)) {
                return (Boolean)SharedConfigTombstone.potions.allowGiantStrength.get();
            }
            if (potionHolder.is(ModPotions.little_world)) {
                return (Boolean)SharedConfigTombstone.potions.allowLittleWorld.get();
            }
        }
        return true;
    }
}

