/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.helper;

import com.google.common.base.CharMatcher;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FormattedCharSequence;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.helper.StyleType;

public class FontHelper {
    private static final CharMatcher ALLOWED_CHAR = CharMatcher.anyOf((CharSequence)"abcdefghijklmnopqrstuvwxyz ABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890.:,;'\"(!?)+-*/_\u00e9\u00e8\u00e0\u00e7\u00f9\u00ea\u00fb\u00e2\u00eb");

    public static void drawCentered(GuiGraphics guiGraphics, Font font, Component text, float x, float y, int color) {
        FontHelper.drawCentered(guiGraphics, font, text, x, y, color, false);
    }

    public static void drawCentered(GuiGraphics guiGraphics, Font font, Component text, float x, float y, int color, boolean shadow) {
        FontHelper.drawCentered(guiGraphics, font, text.getVisualOrderText(), x, y, color, shadow);
    }

    public static void drawCentered(GuiGraphics guiGraphics, Font font, FormattedCharSequence text, float x, float y, int color, boolean shadow) {
        guiGraphics.drawString(font, text, (int)(x - (float)font.width(text) / 2.0f), (int)y, 0xFF000000 | color, shadow);
    }

    public static void drawCenteredFantasy(GuiGraphics guiGraphics, Font font, Component text, float x, float y, int color) {
        FontHelper.drawCenteredFantasy(guiGraphics, font, text, x, y, color, false);
    }

    public static void drawCenteredFantasy(GuiGraphics guiGraphics, Font font, Component text, float x, float y, int color, boolean shadow) {
        FontHelper.drawCentered(guiGraphics, font, FontHelper.withFantasyFont(text), x, y, color, shadow);
    }

    public static Component withFantasyFont(Component component) {
        return FontHelper.isValidLanguageForFantasy() ? component.copy().withStyle(StyleType.FANTASY_NORMAL) : component;
    }

    public static Component withLargeFantasyFont(Component component) {
        return FontHelper.isValidLanguageForFantasy() ? component.copy().withStyle(StyleType.FANTASY_LARGE) : component;
    }

    public static boolean isValidLanguageForFantasy() {
        if (((ConfigTombstone.Client.FontRule)((Object)ConfigTombstone.client.fontRule.get())).isVanilla()) {
            return false;
        }
        String langCode = Minecraft.getInstance().options.languageCode;
        return langCode.startsWith("en") || langCode.startsWith("fr") || langCode.startsWith("es") || langCode.startsWith("nl") || langCode.startsWith("pt");
    }

    public static boolean canBeFantasy(String text) {
        return ALLOWED_CHAR.matchesAllOf((CharSequence)text);
    }
}

