/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.helper;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.saveddata.SavedDataType;

public final class GlobalClock
extends SavedData {
    public static final GlobalClock INSTANCE = new GlobalClock();
    public static final SavedDataType<GlobalClock> TYPE = new SavedDataType("tb_global_clock", () -> INSTANCE, RecordCodecBuilder.create(c -> c.group((App)Codec.LONG.optionalFieldOf("time", (Object)0L).forGetter(globalClock -> GlobalClock.INSTANCE.serverTime)).apply((Applicative)c, serverTime -> {
        GlobalClock.INSTANCE.serverTime = serverTime;
        return INSTANCE;
    })));
    private long serverTime = 0L;
    private long clientTime = 0L;

    public static GlobalClock get(ServerLevel level) {
        return (GlobalClock)level.getDataStorage().computeIfAbsent(TYPE);
    }

    public void clientTick() {
        ++this.clientTime;
    }

    public void serverTick() {
        ++this.serverTime;
        this.setDirty();
    }

    public void setClientTime(long clientTime) {
        this.clientTime = clientTime;
    }

    public long getTime(Level level) {
        return level.isClientSide() ? this.clientTime : this.getTime(level.getServer());
    }

    public long getTime(MinecraftServer server) {
        return GlobalClock.get((ServerLevel)server.overworld()).serverTime;
    }
}

