/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.helper;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShapeRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.particle.ParticleMarker;
import ovh.corail.tombstone.registry.ModItems;

public final class MarkerHandler {
    public static final MarkerHandler instance = new MarkerHandler();
    private Consumer<PoseStack> renderBox;

    private MarkerHandler() {
    }

    public void update(Minecraft mc) {
        if (mc.player == null | mc.level == null) {
            return;
        }
        this.renderBox = null;
        if (((Boolean)ConfigTombstone.client.highlight.get()).booleanValue()) {
            Location loc;
            ItemStack stack = mc.player.getMainHandItem();
            if ((ConfigTombstone.client.markerType.get() == ConfigTombstone.Client.MarkerType.BOX || TimeHelper.atInterval(mc.player.level(), 5)) && !(loc = stack.is((Item)ModItems.grave_key) ? ModItems.grave_key.getTombPos(stack) : (stack.is((Item)ModItems.tablet_of_recall) ? ModItems.tablet_of_recall.getTombPos(stack) : (ModItems.lost_tablet.isWakeUp(stack) ? ModItems.lost_tablet.getLocation(stack) : (stack.is((Item)ModItems.villager_gift) && (!ModItems.villager_gift.isInVillageRange((Player)mc.player, stack) || ModItems.villager_gift.isTargetFound(stack)) ? ModItems.villager_gift.getCurrentTarget(stack) : (stack.is((Item)ModItems.seeker_rod) && (!ModItems.seeker_rod.isInVillageRange((Player)mc.player, stack) || ModItems.seeker_rod.isTargetFound(stack)) ? ModItems.seeker_rod.getCurrentTarget(stack) : Location.ORIGIN))))).isOrigin() && loc.isSameDimension(mc.player.level())) {
                BlockPos pos = loc.getPos();
                if (ConfigTombstone.client.markerType.get() == ConfigTombstone.Client.MarkerType.BOX) {
                    this.renderBox = poseStack -> MarkerHandler.createBox(mc, poseStack, pos.getX(), pos.getY(), pos.getZ(), Helper.getHSBtoRGBF((float)(TimeHelper.systemTime() / 15L % 360L) / 360.0f, 1.0f, 1.0f));
                } else {
                    boolean isFarAway;
                    float[] colors = Helper.getHSBtoRGBF((float)(TimeHelper.systemTime() / 15L % 360L) / 360.0f, 1.0f, 1.0f);
                    Vec3 vec = new Vec3((double)pos.getX() + 0.5, (double)pos.getY() + 0.8, (double)pos.getZ() + 0.5);
                    Vec3 vecCameraToLocation = vec.subtract(mc.gameRenderer.getMainCamera().getPosition());
                    boolean bl = isFarAway = vecCameraToLocation.length() > 10.0;
                    if (isFarAway) {
                        vec = mc.gameRenderer.getMainCamera().getPosition().add(vecCameraToLocation.normalize().scale(10.0));
                    }
                    MarkerHandler.spawnParticle(mc, vec, isFarAway ? 1.0f : 0.5f, colors);
                }
            }
        }
    }

    public void renderBox(PoseStack poseStack) {
        if (this.renderBox != null) {
            this.renderBox.accept(poseStack);
        }
    }

    private static void spawnParticle(Minecraft mc, Vec3 vec3, float scale, float[] colors) {
        double horizontalOffset = 0.25;
        assert (mc.level != null);
        double yOffset = (Helper.RANDOM.nextDouble() - 0.5) * 2.0;
        ParticleMarker particle = new ParticleMarker(mc.level, vec3.x + (Helper.RANDOM.nextDouble() - 0.5) * 2.0 * horizontalOffset, vec3.y + yOffset * 0.5, vec3.z + (Helper.RANDOM.nextDouble() - 0.5) * 2.0 * horizontalOffset, 0.0, (double)(yOffset < 0.5 ? -1 : 1) * Helper.RANDOM.nextDouble() * 0.01, 0.0, scale, colors);
        mc.particleEngine.add((Particle)particle);
    }

    private static void createBox(Minecraft mc, PoseStack poseStack, double x, double y, double z, float[] colors) {
        Vec3 vec = new Vec3(x, y, z).subtract(mc.gameRenderer.getMainCamera().getPosition());
        if (vec.length() > 200.0) {
            vec = vec.normalize().scale(200.0);
        }
        Vec3 vec1 = new Vec3(vec.x, vec.y, vec.z);
        Vec3 vec2 = new Vec3(vec.x + 1.0, vec.y + 1.0, vec.z + 1.0);
        VertexConsumer vertexConsumer = Minecraft.getInstance().renderBuffers().bufferSource().getBuffer(RenderType.lines());
        ShapeRenderer.renderLineBox((PoseStack)poseStack, (VertexConsumer)vertexConsumer, (double)vec1.x, (double)vec1.y, (double)vec1.z, (double)vec2.x, (double)vec2.y, (double)vec2.z, (float)colors[0], (float)colors[1], (float)colors[2], (float)1.0f, (float)colors[0], (float)colors[1], (float)colors[2]);
    }
}

