/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.helper;

import com.mojang.serialization.DynamicOps;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.UUIDUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.helper.SerializationHelper;
import ovh.corail.tombstone.perk.Perk;
import ovh.corail.tombstone.perk.PerkRegistry;

public class NBTHelper {
    public static void remove(@Nullable CompoundTag tag, String ... keyNames) {
        Optional.ofNullable(tag).ifPresent(t -> Arrays.stream(keyNames).forEach(arg_0 -> ((CompoundTag)t).remove(arg_0)));
    }

    public static boolean getBoolean(@Nullable CompoundTag tag, String keyName) {
        return Optional.ofNullable(tag).flatMap(t -> t.getBoolean(keyName)).orElse(false);
    }

    public static void setBoolean(@Nullable CompoundTag tag, String keyName, boolean value) {
        Optional.ofNullable(tag).ifPresent(t -> t.putBoolean(keyName, value));
    }

    public static long getLong(@Nullable CompoundTag tag, String keyName) {
        return Optional.ofNullable(tag).flatMap(t -> t.getLong(keyName)).orElse(0L);
    }

    public static void setLong(@Nullable CompoundTag tag, String keyName, long value) {
        Optional.ofNullable(tag).ifPresent(t -> t.putLong(keyName, value));
    }

    public static int getInt(@Nullable CompoundTag tag, String keyName) {
        return Optional.ofNullable(tag).flatMap(t -> t.getInt(keyName)).orElse(0);
    }

    public static void setInt(@Nullable CompoundTag tag, String keyName, int value) {
        Optional.ofNullable(tag).ifPresent(t -> t.putInt(keyName, value));
    }

    public static short getShort(@Nullable CompoundTag tag, String keyName) {
        return Optional.ofNullable(tag).flatMap(t -> t.getShort(keyName)).orElse((short)0);
    }

    public static void setShort(@Nullable CompoundTag tag, String keyName, short value) {
        Optional.ofNullable(tag).ifPresent(t -> t.putShort(keyName, value));
    }

    public static byte getByte(@Nullable CompoundTag tag, String keyName) {
        return (byte)(Optional.ofNullable(tag).flatMap(t -> t.getByte(keyName)).orElse((byte)0) & 0xFF);
    }

    public static void setByte(@Nullable CompoundTag tag, String keyName, byte value) {
        Optional.ofNullable(tag).ifPresent(t -> t.putByte(keyName, value));
    }

    public static double getDouble(@Nullable CompoundTag tag, String keyName) {
        return Optional.ofNullable(tag).flatMap(t -> t.getDouble(keyName)).orElse(0.0);
    }

    public static void setDouble(@Nullable CompoundTag tag, String keyName, double value) {
        Optional.ofNullable(tag).ifPresent(t -> t.putDouble(keyName, value));
    }

    public static float getFloat(@Nullable CompoundTag tag, String keyName) {
        return Optional.ofNullable(tag).flatMap(t -> t.getFloat(keyName)).orElse(Float.valueOf(0.0f)).floatValue();
    }

    public static void setFloat(@Nullable CompoundTag tag, String keyName, float value) {
        Optional.ofNullable(tag).ifPresent(t -> t.putFloat(keyName, value));
    }

    public static Optional<String> getString(@Nullable CompoundTag tag, String keyName) {
        return Optional.ofNullable(tag).flatMap(t -> t.getString(keyName));
    }

    public static void setString(@Nullable CompoundTag tag, String keyName, String value) {
        Optional.ofNullable(tag).ifPresent(t -> t.putString(keyName, value));
    }

    private static void setBlockPos(CompoundTag tag, String keyName, BlockPos keyValue) {
        NBTHelper.setInt(tag, keyName + "_x", keyValue.getX());
        NBTHelper.setInt(tag, keyName + "_y", keyValue.getY());
        NBTHelper.setInt(tag, keyName + "_z", keyValue.getZ());
    }

    private static Optional<BlockPos> getBlockPos(@Nullable CompoundTag tag, String keyName) {
        if (tag != null && tag.contains(keyName + "_x") && tag.contains(keyName + "_y") && tag.contains(keyName + "_z")) {
            return Optional.of(new BlockPos(NBTHelper.getInt(tag, keyName + "_x"), NBTHelper.getInt(tag, keyName + "_y"), NBTHelper.getInt(tag, keyName + "_z")));
        }
        return Optional.empty();
    }

    private static void setWorldKey(CompoundTag tag, String keyName, ResourceKey<Level> worldKey) {
        Level.RESOURCE_KEY_CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, worldKey).result().ifPresent(rl -> tag.put(keyName, rl));
    }

    @Nullable
    public static ResourceKey<Level> getWorldKey(@Nullable CompoundTag tag, String keyName) {
        if (tag != null && tag.contains(keyName)) {
            return Level.RESOURCE_KEY_CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)tag.get(keyName)).result().orElse(null);
        }
        return null;
    }

    public static CompoundTag setLocation(CompoundTag tag, String keyName, Location location) {
        NBTHelper.setBlockPos(tag, keyName, location.getPos());
        NBTHelper.setWorldKey(tag, keyName + "_dim", location.dim);
        return tag;
    }

    public static Location getLocation(@Nullable CompoundTag tag, String keyName) {
        ResourceKey<Level> worldKey;
        BlockPos pos;
        if (tag != null && (pos = (BlockPos)NBTHelper.getBlockPos(tag, keyName).orElse(null)) != null && (worldKey = NBTHelper.getWorldKey(tag, keyName + "_dim")) != null) {
            return new Location(pos, worldKey);
        }
        return Location.ORIGIN;
    }

    public static Optional<UUID> getUUID(CompoundTag tag, String keyName) {
        return tag.read(keyName, UUIDUtil.CODEC);
    }

    public static void setUUID(CompoundTag tag, String keyName, @Nullable UUID uuid) {
        tag.storeNullable(keyName, UUIDUtil.CODEC, (Object)uuid);
    }

    public static Optional<ListTag> getListOrEmpty(CompoundTag tag, String keyName) {
        return Optional.of(tag).filter(t -> t.contains(keyName)).flatMap(t -> t.getList(keyName)).filter(t -> !t.isEmpty());
    }

    public static ListTag getListOrCreate(CompoundTag tag, String keyName) {
        Optional<ListTag> optionalListTag;
        if (tag.contains(keyName) && (optionalListTag = NBTHelper.getListOrEmpty(tag, keyName)).isPresent()) {
            return optionalListTag.get();
        }
        ListTag list = new ListTag();
        tag.put(keyName, (Tag)list);
        return list;
    }

    public static Optional<MobEffectInstance> getEffect(@Nullable CompoundTag tag, String keyName) {
        return tag != null ? MobEffectInstance.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)tag.get(keyName)).result() : Optional.empty();
    }

    public static void setEffect(CompoundTag tag, String keyName, MobEffectInstance mobEffectInstance) {
        MobEffectInstance.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)mobEffectInstance).result().ifPresent(rl -> tag.put(keyName, rl));
    }

    public static List<MobEffectInstance> getEffects(RegistryAccess registryAccess, CompoundTag tag, String keyName, Predicate<MobEffectInstance> predic) {
        return tag.read(keyName, MobEffectInstance.CODEC.listOf(), (DynamicOps)registryAccess.createSerializationContext((DynamicOps)NbtOps.INSTANCE)).orElse(List.of()).stream().filter(predic).collect(Collectors.toList());
    }

    public static void setEffects(RegistryAccess registryAccess, CompoundTag tag, String keyName, List<MobEffectInstance> effectInstances) {
        if (!effectInstances.isEmpty()) {
            tag.store(keyName, MobEffectInstance.CODEC.listOf(), (DynamicOps)registryAccess.createSerializationContext((DynamicOps)NbtOps.INSTANCE), effectInstances);
        } else {
            NBTHelper.remove(tag, keyName);
        }
    }

    public static void readPerks(Map<Perk, Integer> perks, CompoundTag tag) {
        NBTHelper.getListOrEmpty(tag, "perks").ifPresent(tagPerks -> {
            for (int i = 0; i < tagPerks.size(); ++i) {
                CompoundTag tagPerk = tagPerks.getCompoundOrEmpty(i);
                if (!tagPerk.contains("id") || !tagPerk.contains("level")) continue;
                NBTHelper.getString(tagPerk, "id").ifPresent(id -> {
                    int perkLevel;
                    Perk perk = PerkRegistry.getValue(id);
                    if (perk != null && !perk.isDisabled(null) && (perkLevel = NBTHelper.getByte(tagPerk, "level") & 0xFF) > 0) {
                        perks.put(perk, Math.min(perk.getLevelMax(), perkLevel));
                    }
                });
            }
        });
    }

    public static void writePerks(Map<Perk, Integer> perks, CompoundTag tag) {
        ListTag tagPerks = new ListTag();
        tag.put("perks", (Tag)tagPerks);
        perks.forEach((perk, perklevel) -> {
            if (perk != null && perklevel > 0 && !perk.isDisabled(null)) {
                CompoundTag tagPerk = new CompoundTag();
                NBTHelper.setString(tagPerk, "id", PerkRegistry.getStringKey(perk));
                NBTHelper.setByte(tagPerk, "level", (byte)Math.min(perk.getLevelMax(), perklevel));
                tagPerks.add((Object)tagPerk);
            }
        });
    }

    public static CompoundTag serializeEntity(Entity entity) {
        CompoundTag ret = new CompoundTag();
        String id = entity.getEncodeId();
        if (id != null) {
            ret.putString("id", id);
        }
        return SerializationHelper.createCompoundTag(arg_0 -> ((Entity)entity).saveWithoutId(arg_0), entity.registryAccess());
    }

    public static ItemStack readItemStack(RegistryAccess registryAccess, CompoundTag tag) {
        RegistryOps registryOps = RegistryOps.create((DynamicOps)NbtOps.INSTANCE, (HolderLookup.Provider)registryAccess);
        return ItemStack.CODEC.parse((DynamicOps)registryOps, (Object)tag).result().orElse(ItemStack.EMPTY);
    }

    public static CompoundTag saveItemStack(RegistryAccess registryAccess, ItemStack stack) {
        RegistryOps registryOps = RegistryOps.create((DynamicOps)NbtOps.INSTANCE, (HolderLookup.Provider)registryAccess);
        return ItemStack.CODEC.encodeStart((DynamicOps)registryOps, (Object)stack).result().orElse(new CompoundTag());
    }
}

