/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.helper;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.saveddata.SavedDataType;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.level.BlockEvent;
import ovh.corail.tombstone.registry.ModTags;

public class PlacedBlocksTracker
extends SavedData {
    public static final SavedDataType<PlacedBlocksTracker> TYPE = new SavedDataType("tb_placed_blocks_tracker", PlacedBlocksTracker::new, RecordCodecBuilder.create(c -> c.group((App)BlockPos.CODEC.listOf().fieldOf("placed_blocks").forGetter(placedBlocksTracker -> placedBlocksTracker.placedBlocks.stream().toList())).apply((Applicative)c, PlacedBlocksTracker::new)));
    private final Set<BlockPos> placedBlocks = ConcurrentHashMap.newKeySet();
    public boolean isValidBlock = false;

    public PlacedBlocksTracker() {
    }

    public PlacedBlocksTracker(List<BlockPos> placedBlocks) {
        this.placedBlocks.addAll(placedBlocks);
    }

    public void add(BlockPos pos) {
        this.placedBlocks.add(pos.immutable());
        this.setDirty();
    }

    public void remove(BlockPos pos) {
        this.placedBlocks.remove(pos);
        this.setDirty();
    }

    public boolean contains(BlockPos pos) {
        return this.placedBlocks.contains(pos);
    }

    public static PlacedBlocksTracker get(ServerLevel level) {
        return (PlacedBlocksTracker)level.getDataStorage().computeIfAbsent(TYPE);
    }

    @EventBusSubscriber(modid="tombstone")
    public static class PlacedBlocksEvents {
        @SubscribeEvent(priority=EventPriority.LOWEST)
        public static void onPlacedBlock(BlockEvent.EntityPlaceEvent event) {
            LevelAccessor levelAccessor = event.getBlockSnapshot().getLevel();
            if (levelAccessor instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)levelAccessor;
                if (PlacedBlocksEvents.isTrackedBlock(event.getPlacedBlock())) {
                    PlacedBlocksTracker tracker = PlacedBlocksTracker.get(serverLevel);
                    if (tracker.isValidBlock) {
                        tracker.isValidBlock = false;
                    } else {
                        tracker.add(event.getPos());
                    }
                }
            }
        }

        @SubscribeEvent(priority=EventPriority.LOWEST)
        public static void onBrokenBlock(BlockEvent.BreakEvent event) {
            PlacedBlocksTracker tracker;
            if (!event.getPlayer().level().isClientSide && PlacedBlocksEvents.isTrackedBlock(event.getState()) && (tracker = PlacedBlocksTracker.get((ServerLevel)event.getPlayer().level())).contains(event.getPos())) {
                tracker.remove(event.getPos());
            }
        }

        private static boolean isTrackedBlock(BlockState state) {
            return state.is(ModTags.Blocks.living_corals) || state.is(ModTags.Blocks.dead_corals);
        }
    }
}

