/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.helper;

import io.netty.buffer.ByteBuf;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.Nullable;
import ovh.corail.tombstone.block.BlockGraveMarble;
import ovh.corail.tombstone.block.GraveModel;
import ovh.corail.tombstone.config.ConfigTombstone;

public final class PlayerPreference {
    private static final Map<UUID, PlayerPreference> PLAYER_PREFERENCES = new ConcurrentHashMap<UUID, PlayerPreference>();
    private static final PlayerPreference DEFAULT_PREFERENCE = new PlayerPreference(GraveModel.getDefault(), BlockGraveMarble.MarbleType.getDefault(), ConfigTombstone.Client.AutoEquipRule.getDefault(), false, false, false, true, true, false, true, true);
    private GraveModel graveModel;
    private BlockGraveMarble.MarbleType marbleType;
    private ConfigTombstone.Client.AutoEquipRule autoEquipRule;
    private boolean equipElytraInPriority;
    private boolean equipShieldInPriority;
    private boolean reverseInventorySorting;
    private boolean knowledgeMessage;
    private boolean alignmentMessage;
    private boolean priorizeToolOnHotbar;
    private boolean activateGraveBySneaking;
    private boolean allowGraveInWater;

    private PlayerPreference(GraveModel graveModel, BlockGraveMarble.MarbleType marbleType, ConfigTombstone.Client.AutoEquipRule autoEquipRule, boolean equipElytraInPriority, boolean equipShieldInPriority, boolean reverseInventorySorting, boolean knowledgeMessage, boolean alignmentMessage, boolean priorizeToolOnHotbar, boolean activateGraveBySneaking, boolean allowGraveInWater) {
        this.graveModel = graveModel;
        this.marbleType = marbleType;
        this.autoEquipRule = autoEquipRule;
        this.equipElytraInPriority = equipElytraInPriority;
        this.equipShieldInPriority = equipShieldInPriority;
        this.reverseInventorySorting = reverseInventorySorting;
        this.knowledgeMessage = knowledgeMessage;
        this.alignmentMessage = alignmentMessage;
        this.priorizeToolOnHotbar = priorizeToolOnHotbar;
        this.activateGraveBySneaking = activateGraveBySneaking;
        this.allowGraveInWater = allowGraveInWater;
    }

    public GraveModel getFavoriteGrave() {
        return this.graveModel;
    }

    public BlockGraveMarble.MarbleType getMarbleType() {
        return this.marbleType;
    }

    public void setFavoriteGrave(@Nullable GraveModel graveModel) {
        this.graveModel = Optional.ofNullable(graveModel).orElse(GraveModel.getDefault());
    }

    public void setMarbleType(@Nullable BlockGraveMarble.MarbleType marbleType) {
        this.marbleType = Optional.ofNullable(marbleType).orElse(BlockGraveMarble.MarbleType.getDefault());
    }

    public boolean hasSameFavoriteGrave(PlayerPreference aPlayerPreference) {
        return this.hasSameFavoriteGrave(aPlayerPreference.getFavoriteGrave(), aPlayerPreference.getMarbleType());
    }

    private boolean hasSameFavoriteGrave(GraveModel graveModel, BlockGraveMarble.MarbleType marbleType) {
        return this.getFavoriteGrave() == graveModel && this.getMarbleType() == marbleType;
    }

    public boolean equipElytraInPriority() {
        return this.equipElytraInPriority;
    }

    public void setEquipElytraInPriority(boolean flag) {
        this.equipElytraInPriority = flag;
    }

    public boolean equipShieldInPriority() {
        return this.equipShieldInPriority;
    }

    public void setEquipShieldInPriority(boolean flag) {
        this.equipShieldInPriority = flag;
    }

    public boolean isReverseInventorySorting() {
        return this.reverseInventorySorting;
    }

    public void setReverseInventorySorting(boolean flag) {
        this.reverseInventorySorting = flag;
    }

    public boolean displayKnowledgeMessage() {
        return this.knowledgeMessage;
    }

    public void setDisplayKnowledgeMessage(boolean flag) {
        this.knowledgeMessage = flag;
    }

    public boolean displayAlignmentMessage() {
        return this.alignmentMessage;
    }

    public void setDisplayAlignmentMessage(boolean flag) {
        this.alignmentMessage = flag;
    }

    public boolean priorizeToolOnHotbar() {
        return this.priorizeToolOnHotbar;
    }

    public void setPriorizeToolOnHotbar(boolean flag) {
        this.priorizeToolOnHotbar = flag;
    }

    public boolean activateGraveBySneaking() {
        return this.activateGraveBySneaking;
    }

    public void setActivateGraveBySneaking(boolean flag) {
        this.activateGraveBySneaking = flag;
    }

    public boolean allowGraveInWater() {
        return this.allowGraveInWater;
    }

    public void setAllowGraveInWater(boolean flag) {
        this.allowGraveInWater = flag;
    }

    public ConfigTombstone.Client.AutoEquipRule getAutoEquipRule() {
        return this.autoEquipRule;
    }

    public void setAutoEquipRule(ConfigTombstone.Client.AutoEquipRule autoEquipRule) {
        this.autoEquipRule = autoEquipRule;
    }

    public static void set(ServerPlayer player, PlayerPreference playerPreference) {
        if (playerPreference.graveModel == null) {
            playerPreference.graveModel = GraveModel.getDefault();
        }
        if (playerPreference.marbleType == null) {
            playerPreference.marbleType = BlockGraveMarble.MarbleType.getDefault();
        }
        if (playerPreference.autoEquipRule == null) {
            playerPreference.autoEquipRule = ConfigTombstone.Client.AutoEquipRule.getDefault();
        }
        PLAYER_PREFERENCES.put(player.getGameProfile().getId(), playerPreference);
    }

    public static PlayerPreference get(ServerPlayer player) {
        return PLAYER_PREFERENCES.getOrDefault(player.getGameProfile().getId(), DEFAULT_PREFERENCE);
    }

    public static void clear() {
        PLAYER_PREFERENCES.clear();
    }

    public static void toBytes(PlayerPreference playerPreference, ByteBuf buf) {
        buf.writeByte(playerPreference.graveModel.ordinal());
        buf.writeByte(playerPreference.marbleType.ordinal());
        buf.writeByte(playerPreference.autoEquipRule.ordinal());
        buf.writeBoolean(playerPreference.equipElytraInPriority);
        buf.writeBoolean(playerPreference.equipShieldInPriority);
        buf.writeBoolean(playerPreference.reverseInventorySorting);
        buf.writeBoolean(playerPreference.knowledgeMessage);
        buf.writeBoolean(playerPreference.alignmentMessage);
        buf.writeBoolean(playerPreference.priorizeToolOnHotbar);
        buf.writeBoolean(playerPreference.activateGraveBySneaking);
        buf.writeBoolean(playerPreference.allowGraveInWater);
    }

    public static PlayerPreference fromBytes(ByteBuf buf) {
        return new PlayerPreference(GraveModel.byId(buf.readByte()), BlockGraveMarble.MarbleType.byId(buf.readByte()), ConfigTombstone.Client.AutoEquipRule.byId(buf.readByte()), buf.readBoolean(), buf.readBoolean(), buf.readBoolean(), buf.readBoolean(), buf.readBoolean(), buf.readBoolean(), buf.readBoolean(), buf.readBoolean());
    }

    public static PlayerPreference fromClientConfig() {
        return new PlayerPreference((GraveModel)((Object)ConfigTombstone.client.favoriteGrave.get()), (BlockGraveMarble.MarbleType)((Object)ConfigTombstone.client.favoriteGraveMarble.get()), (ConfigTombstone.Client.AutoEquipRule)((Object)ConfigTombstone.client.autoEquipRule.get()), (Boolean)ConfigTombstone.client.equipElytraInPriority.get(), (Boolean)ConfigTombstone.client.equipShieldInPriority.get(), (Boolean)ConfigTombstone.client.reverseInventorySorting.get(), (Boolean)ConfigTombstone.client.displayKnowledgeMessage.get(), (Boolean)ConfigTombstone.client.displayAlignmentMessage.get(), (Boolean)ConfigTombstone.client.priorizeToolOnHotbar.get(), (Boolean)ConfigTombstone.client.activateGraveBySneaking.get(), (Boolean)ConfigTombstone.client.allowGraveInWater.get());
    }

    public boolean hasChangedFromConfig() {
        return !this.hasSameFavoriteGrave((GraveModel)((Object)ConfigTombstone.client.favoriteGrave.get()), (BlockGraveMarble.MarbleType)((Object)ConfigTombstone.client.favoriteGraveMarble.get())) || this.autoEquipRule != ConfigTombstone.client.autoEquipRule.get() || this.equipElytraInPriority != (Boolean)ConfigTombstone.client.equipElytraInPriority.get() || this.equipShieldInPriority != (Boolean)ConfigTombstone.client.equipShieldInPriority.get() || this.reverseInventorySorting != (Boolean)ConfigTombstone.client.reverseInventorySorting.get() || this.knowledgeMessage != (Boolean)ConfigTombstone.client.displayKnowledgeMessage.get() || this.alignmentMessage != (Boolean)ConfigTombstone.client.displayAlignmentMessage.get() || this.priorizeToolOnHotbar != (Boolean)ConfigTombstone.client.priorizeToolOnHotbar.get() || this.activateGraveBySneaking != (Boolean)ConfigTombstone.client.activateGraveBySneaking.get() || this.allowGraveInWater != (Boolean)ConfigTombstone.client.allowGraveInWater.get();
    }

    public void updateClientConfig() {
        ConfigTombstone.client.favoriteGrave.set((Object)this.graveModel);
        ConfigTombstone.client.favoriteGraveMarble.set((Object)this.marbleType);
        ConfigTombstone.client.autoEquipRule.set((Object)this.autoEquipRule);
        ConfigTombstone.client.displayKnowledgeMessage.set((Object)this.knowledgeMessage);
        ConfigTombstone.client.displayAlignmentMessage.set((Object)this.alignmentMessage);
        ConfigTombstone.client.equipElytraInPriority.set((Object)this.equipElytraInPriority);
        ConfigTombstone.client.equipShieldInPriority.set((Object)this.equipShieldInPriority);
        ConfigTombstone.client.reverseInventorySorting.set((Object)this.reverseInventorySorting);
        ConfigTombstone.client.priorizeToolOnHotbar.set((Object)this.priorizeToolOnHotbar);
        ConfigTombstone.client.activateGraveBySneaking.set((Object)this.activateGraveBySneaking);
        ConfigTombstone.client.allowGraveInWater.set((Object)this.allowGraveInWater);
    }
}

