/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.helper;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.ConversionParams;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.monster.ZombieVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.Nullable;
import ovh.corail.tombstone.capability.EnhancedFamiliarHandler;
import ovh.corail.tombstone.capability.ProtectedEntityHandler;
import ovh.corail.tombstone.capability.ServantUndeadHandler;
import ovh.corail.tombstone.capability.TBPlayerCapabilityHandler;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.helper.EffectHelper;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.helper.TamableType;
import ovh.corail.tombstone.registry.ModPerks;
import ovh.corail.tombstone.registry.ModTags;
import ovh.corail.tombstone.registry.ModTriggers;

public class PrayerHelper {
    public static boolean exorcism(ServerPlayer player, LivingEntity target, int ignoredAlignment) {
        ServerLevel serverLevel = player.level();
        if (target instanceof ZombieVillager) {
            ZombieVillager zombieVillager = (ZombieVillager)target;
            zombieVillager.convertTo(EntityType.VILLAGER, ConversionParams.single((Mob)zombieVillager, (boolean)false, (boolean)false), villager -> {
                for (EquipmentSlot equipmentslot : zombieVillager.dropPreservedEquipment(serverLevel, d -> !EnchantmentHelper.has((ItemStack)d, (DataComponentType)EnchantmentEffectComponents.PREVENT_ARMOR_CHANGE))) {
                    SlotAccess slotaccess = villager.getSlot(equipmentslot.getIndex() + 300);
                    slotaccess.set(zombieVillager.getItemBySlot(equipmentslot));
                }
                villager.setVillagerData(zombieVillager.getVillagerData());
                if (zombieVillager.gossips != null) {
                    villager.setGossips(zombieVillager.gossips);
                }
                if (zombieVillager.tradeOffers != null) {
                    villager.setOffers(zombieVillager.tradeOffers.copy());
                }
                villager.setVillagerXp(zombieVillager.getVillagerXp());
                villager.finalizeSpawn((ServerLevelAccessor)serverLevel, serverLevel.getCurrentDifficultyAt(villager.blockPosition()), EntitySpawnReason.CONVERSION, null);
                if (!zombieVillager.isSilent()) {
                    serverLevel.levelEvent(null, 1027, zombieVillager.blockPosition(), 0);
                }
            });
            TBPlayerCapabilityHandler.rewardKnowledge(player, 3);
            TBPlayerCapabilityHandler.rewardAlignment(player, (Integer)ConfigTombstone.alignment.pointsExorcismZombieVillager.get());
            LangKey.MESSAGE_EXORCISM.sendSpecialMessage(player, new Object[0]);
            ModTriggers.exorcism.trigger(player);
            return true;
        }
        return false;
    }

    public static boolean isValidUndead(Entity entity) {
        PathfinderMob target;
        return entity instanceof PathfinderMob && EntityHelper.isUndead((LivingEntity)(target = (PathfinderMob)entity)) && !entity.getType().is(ModTags.EntityTypes.UNHANDLED_TAMABLE_UNDEADS) && !EntityHelper.isBoss((LivingEntity)target);
    }

    public static boolean undead(ServerPlayer player, LivingEntity target, int alignment) {
        if (alignment < -1 && TamableType.getType(target) == TamableType.UNDEAD && player.level().getDifficulty() != Difficulty.PEACEFUL && TamableType.UNDEAD.getOwnerId(target) == null) {
            PrayerHelper.applyPrayOfUndeadLogic(player, target);
            LangKey.MESSAGE_PRAYER_OF_UNDEAD.sendSpecialMessage(player, new Object[0]);
            ModTriggers.prayer_of_undead.trigger(player);
            return true;
        }
        return false;
    }

    private static void applyPrayOfUndeadLogic(ServerPlayer player, LivingEntity target) {
        ServantUndeadHandler.setOwnerId((Entity)target, player.getGameProfile().getId());
        if (Helper.RANDOM.nextInt(100) <= EntityHelper.getPerkLevelWithBonus((Player)player, ModPerks.necromancer) * 20) {
            ServantUndeadHandler.setSpellCaster((Entity)target, ServantUndeadHandler.CasterType.getRandomId());
        }
        ServantUndeadHandler.setAI((PathfinderMob)target);
    }

    public static boolean dissonance(ServerPlayer player, LivingEntity target, int alignment) {
        if (alignment < -2) {
            PrayerHelper.applyPrayOfUndeadLogic(player, target);
            if (EnhancedFamiliarHandler.hasCapability((Entity)target)) {
                EnhancedFamiliarHandler.setEnhanced((Entity)target);
                EnhancedFamiliarHandler.applyAttributes(target);
            }
            LangKey.MESSAGE_PRAYER_OF_UNDEAD.sendSpecialMessage(player, new Object[0]);
            ModTriggers.prayer_of_dissonance.trigger(player);
            ModTriggers.prayer_of_undead.trigger(player);
            return true;
        }
        return false;
    }

    public static boolean zombify(ServerPlayer player, LivingEntity target, int alignment) {
        ServerLevel serverLevel = player.level();
        if (alignment < 0 && target instanceof Villager) {
            Villager villager = (Villager)target;
            if (serverLevel.getDifficulty() != Difficulty.PEACEFUL) {
                villager.convertTo(EntityType.ZOMBIE_VILLAGER, ConversionParams.single((Mob)villager, (boolean)false, (boolean)false), zombieVillager -> {
                    zombieVillager.finalizeSpawn((ServerLevelAccessor)serverLevel, serverLevel.getCurrentDifficultyAt(zombieVillager.blockPosition()), EntitySpawnReason.CONVERSION, null);
                    zombieVillager.setVillagerData(villager.getVillagerData());
                    zombieVillager.setGossips(villager.getGossips().copy());
                    zombieVillager.setTradeOffers(villager.getOffers().copy());
                    zombieVillager.setVillagerXp(villager.getVillagerXp());
                    ServantUndeadHandler.setOwnerId((Entity)zombieVillager, player.getGameProfile().getId());
                    if (Helper.RANDOM.nextInt(100) <= EntityHelper.getPerkLevelWithBonus((Player)player, ModPerks.necromancer) * 20) {
                        ServantUndeadHandler.setSpellCaster((Entity)zombieVillager, ServantUndeadHandler.CasterType.getRandomId());
                    }
                    ServantUndeadHandler.setAI((PathfinderMob)zombieVillager);
                });
                TBPlayerCapabilityHandler.rewardKnowledge(player, 3);
                TBPlayerCapabilityHandler.rewardAlignment(player, (Integer)ConfigTombstone.alignment.pointsZombifyVillager.get());
                LangKey.MESSAGE_EXORCISM.sendSpecialMessage(player, new Object[0]);
                ModTriggers.zombify.trigger(player);
                return true;
            }
        }
        return false;
    }

    public static boolean empathy(ServerPlayer player, LivingEntity target, int alignment) {
        if (alignment > 1 && PrayerHelper.applyPrayOfEmpathyLogic(player, target)) {
            LangKey.MESSAGE_PRAY_OF_EMPATHY.sendSpecialMessage(player, new Object[0]);
            ModTriggers.prayer_of_empathy.trigger(player);
            return true;
        }
        return false;
    }

    private static boolean applyPrayOfEmpathyLogic(ServerPlayer player, LivingEntity target) {
        @Nullable TamableType tamableType = TamableType.getType(target);
        if (tamableType != null && tamableType != TamableType.UNDEAD) {
            tamableType.setTamedBy((Player)player, target);
            if (tamableType == TamableType.TAMABLE) {
                player.level().broadcastEntityEvent((Entity)target, (byte)7);
            }
            return true;
        }
        return false;
    }

    public static boolean harmonization(ServerPlayer player, LivingEntity target, int alignment) {
        if (alignment > 2 && PrayerHelper.applyPrayOfEmpathyLogic(player, target)) {
            if (EnhancedFamiliarHandler.hasCapability((Entity)target)) {
                EnhancedFamiliarHandler.setEnhanced((Entity)target);
                EnhancedFamiliarHandler.applyAttributes(target);
            }
            LangKey.MESSAGE_PRAY_OF_EMPATHY.sendSpecialMessage(player, new Object[0]);
            ModTriggers.prayer_of_harmonization.trigger(player);
            ModTriggers.prayer_of_empathy.trigger(player);
            return true;
        }
        return false;
    }

    public static boolean protection(ServerPlayer player, LivingEntity target, int alignment) {
        if (alignment > 0 && ProtectedEntityHandler.hasCapability((Entity)target) && !ProtectedEntityHandler.isActive((Entity)target)) {
            ProtectedEntityHandler.apply(target, true);
            if (target instanceof ServerPlayer) {
                EntityHelper.syncProtectedPlayerCapability(player);
            }
            TBPlayerCapabilityHandler.rewardKnowledge(player, 3);
            TBPlayerCapabilityHandler.rewardAlignment(player, (Integer)ConfigTombstone.alignment.pointsPrayOfProtection.get());
            LangKey.MESSAGE_PRAY_OF_PROTECTION_SUCCESS.sendSpecialMessage(player, target.getName());
            ModTriggers.prayer_of_protection.trigger(player);
            return true;
        }
        return false;
    }

    public static boolean onGrave(ServerPlayer player, BlockPos position) {
        @Nullable BlockPos gravePos = PrayerHelper.findPrayableBlock(player.level(), position);
        if (gravePos != null) {
            TBPlayerCapabilityHandler.rewardKnowledge(player, 1);
            ModTriggers.pray_on_grave.trigger(player);
            if (TBPlayerCapabilityHandler.hasWatcherKnowledge((Player)player, 1)) {
                List<LivingEntity> allies = player.level().getEntities((Entity)player, player.getBoundingBox().inflate(3.0, 0.0, 3.0), e -> e != null && e.isAlive()).stream().filter(LivingEntity.class::isInstance).map(LivingEntity.class::cast).filter(e -> EntityHelper.isValidPlayer((Entity)e) || player.isAlliedTo((Entity)e)).toList();
                allies.forEach(e -> EffectHelper.addRandomEffect((Player)player, (Integer)SharedConfigTombstone.decorative_grave.prayerCooldown.get() * 120, EntityHelper.isValidServerPlayer((Entity)e), false, false));
            }
            EffectHelper.addRandomEffect((Player)player, (Integer)SharedConfigTombstone.decorative_grave.prayerCooldown.get() * 120, true, false, false);
            Helper.getDecorativeGrave((Level)player.level(), gravePos).ifPresent(te -> te.decreaseCorruption(20));
            return true;
        }
        LangKey.MESSAGE_CANT_PRAY.sendMessage(player, StyleType.COLOR_RED, new Object[0]);
        return false;
    }

    @Nullable
    public static BlockPos findPrayableBlock(ServerLevel serverLevel, BlockPos startPos) {
        ArrayList<BlockPos> offsets = new ArrayList<BlockPos>();
        for (int x = -2; x <= 2; ++x) {
            for (int z = -2; z <= 2; ++z) {
                offsets.add(new BlockPos(x, 0, z));
            }
        }
        offsets.sort(Comparator.comparingInt(pos -> pos.distManhattan((Vec3i)BlockPos.ZERO)));
        BlockPos.MutableBlockPos currentPos = new BlockPos.MutableBlockPos();
        for (BlockPos offset : offsets) {
            int posX = startPos.getX() + offset.getX();
            int posZ = startPos.getZ() + offset.getZ();
            for (int y = -1; y <= 1; ++y) {
                currentPos.set(posX, startPos.getY() + y, posZ);
                if (!serverLevel.getBlockState((BlockPos)currentPos).is(ModTags.Blocks.decorative_graves)) continue;
                return currentPos.immutable();
            }
        }
        return null;
    }
}

