/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.helper;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import org.jetbrains.annotations.Nullable;
import ovh.corail.tombstone.compatibility.CompatibilityMysticalAgriculture;
import ovh.corail.tombstone.compatibility.SupportMods;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.registry.ModTags;

public class RandomWeightedItem {
    private final TagKey<Item> itemTagKey;
    private final Map<Item, Integer> weightedItems = new HashMap<Item, Integer>();
    private int weight = 0;

    public RandomWeightedItem(TagKey<Item> itemTagKey) {
        this.itemTagKey = itemTagKey;
        Helper.getItemHolderStream(itemTagKey).forEach(itemHolder -> {
            int rarityValue = this.getRarityValue((Holder<Item>)itemHolder);
            this.weightedItems.put((Item)itemHolder.value(), rarityValue);
            this.weight += rarityValue;
        });
    }

    @Nullable
    public Item getRandomItem() {
        if (this.weight == 0) {
            return null;
        }
        int random = Helper.RANDOM.nextInt(this.weight) + 1;
        int i = this.weight;
        for (Map.Entry<Item, Integer> entry : this.weightedItems.entrySet()) {
            int rarityValue = entry.getValue();
            if (random <= (i -= rarityValue)) continue;
            return entry.getKey();
        }
        return null;
    }

    private int getRarityValue(Holder<Item> itemHolder) {
        boolean isVanilla = itemHolder.unwrapKey().map(rk -> rk.location().getNamespace().equals("minecraft")).orElse(false);
        Rarity rarity = (Rarity)((Item)itemHolder.value()).components().getOrDefault(DataComponents.RARITY, (Object)Rarity.COMMON);
        if (!isVanilla && SupportMods.MYSTICAL_AGRICULTURE.isLoaded() && this.itemTagKey == ModTags.Items.seeds) {
            rarity = CompatibilityMysticalAgriculture.instance.getRarity((Item)itemHolder.value(), rarity);
        }
        int n = isVanilla ? 5 : 1;
        return n * (switch (rarity) {
            case Rarity.EPIC -> 1;
            case Rarity.RARE -> 3;
            case Rarity.UNCOMMON -> 5;
            default -> 10;
        });
    }
}

