/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.helper;

import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.Nullable;
import ovh.corail.tombstone.helper.Helper;

public class RegistryHelper {
    @Nullable
    public static ResourceLocation getRegistryName(Block block) {
        ResourceLocation key = BuiltInRegistries.BLOCK.getKey((Object)block);
        if (key == BuiltInRegistries.BLOCK.getDefaultKey() && block != Blocks.AIR) {
            return null;
        }
        return key;
    }

    @Nullable
    public static Block getBlock(ResourceLocation rl) {
        Block block = (Block)BuiltInRegistries.BLOCK.getValue(rl);
        return block == Blocks.AIR ? null : block;
    }

    public static String getRegistryString(Block block) {
        return Optional.ofNullable(RegistryHelper.getRegistryName(block)).map(ResourceLocation::toString).orElse("");
    }

    @Nullable
    public static ResourceLocation getRegistryName(Item item) {
        ResourceLocation key = BuiltInRegistries.ITEM.getKey((Object)item);
        if (key == BuiltInRegistries.ITEM.getDefaultKey() && item != Items.AIR) {
            return null;
        }
        return key;
    }

    @Nullable
    public static Item getItem(ResourceLocation rl) {
        Item item = (Item)BuiltInRegistries.ITEM.getValue(rl);
        return item == Items.AIR ? null : item;
    }

    public static String getRegistryString(Item item) {
        return Optional.ofNullable(RegistryHelper.getRegistryName(item)).map(ResourceLocation::toString).orElse("");
    }

    public static boolean isValid(Item item, Predicate<ResourceLocation> rlPredicate) {
        return Optional.ofNullable(RegistryHelper.getRegistryName(item)).map(rlPredicate::test).orElse(false);
    }

    @Nullable
    public static ResourceLocation getRegistryName(EntityType<?> entityType) {
        ResourceLocation key = BuiltInRegistries.ENTITY_TYPE.getKey(entityType);
        if (key == BuiltInRegistries.ENTITY_TYPE.getDefaultKey() && entityType != EntityType.PIG) {
            return null;
        }
        return key;
    }

    @Nullable
    public static EntityType<?> getEntity(ResourceLocation rl) {
        EntityType entityType = (EntityType)BuiltInRegistries.ENTITY_TYPE.getValue(rl);
        return entityType == EntityType.PIG ? null : entityType;
    }

    public static String getRegistryString(@Nullable Entity entity) {
        return Optional.ofNullable(entity).map(Entity::getType).map(RegistryHelper::getRegistryString).orElse("");
    }

    public static String getRegistryString(EntityType<?> entityType) {
        return Optional.ofNullable(RegistryHelper.getRegistryName(entityType)).map(ResourceLocation::toString).orElse("");
    }

    public static <T> Optional<Holder<T>> findRandomHolder(Registry<T> registry, Predicate<T> predicate) {
        return Helper.getRandomInList(registry.listElements().filter(h -> predicate.test(h.value())).collect(Collectors.toList()));
    }
}

