/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.helper;

import com.mojang.blaze3d.opengl.GlStateManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.render.TextureSetup;
import net.minecraft.client.gui.render.state.GuiElementRenderState;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.resources.ResourceLocation;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fc;
import ovh.corail.tombstone.gui.GradientRenderState;

public class RenderHelper {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"tombstone", (String)"textures/block/circle.png");

    public static void fillHorizontalGradient(GuiGraphics guiGraphics, int left, int top, int right, int bottom, int color1, int color2) {
        Minecraft.getInstance().gameRenderer.guiRenderState.submitGuiElement((GuiElementRenderState)new GradientRenderState(RenderPipelines.GUI, TextureSetup.noTexture(), new Matrix3x2f((Matrix3x2fc)guiGraphics.pose()), left, top, right, bottom, color1, color2, guiGraphics.peekScissorStack()));
    }

    public static void renderCircle(GuiGraphics guiGraphics, int x, int y, int color, int size) {
        RenderHelper.renderCircle(guiGraphics, x, y, color, -5586716, size);
    }

    public static void renderCircle(GuiGraphics guiGraphics, int x, int y, int color, int colorBg, int size) {
        guiGraphics.fill(x + 1, y + 1, x - 1 + size, y - 1 + size, colorBg);
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, TEXTURE, x, y, 0.0f, 0.0f, size, size, size, size, size, size, color);
    }

    public static enum Sprites {
        ARROW_SPRITE(ResourceLocation.withDefaultNamespace((String)"widget/page_forward_highlighted"), 23, 13),
        MOUSE_ON(ResourceLocation.withDefaultNamespace((String)"toast/right_click"), 20, 20),
        MOUSE_OFF(ResourceLocation.withDefaultNamespace((String)"toast/mouse"), 20, 20),
        BAR_BACKGROUND_SPRITE(ResourceLocation.withDefaultNamespace((String)"boss_bar/yellow_background"), 182, 5),
        BAR_PROGRESS_SPRITE(ResourceLocation.withDefaultNamespace((String)"boss_bar/yellow_progress"), 182, 5),
        BAR_NOTCHED_12_SPRITE(ResourceLocation.withDefaultNamespace((String)"boss_bar/notched_12_background"), 182, 3);

        private final ResourceLocation spriteRL;
        private final int defaultWidth;
        private final int defaultHeight;

        private Sprites(ResourceLocation spriteRL, int defaultWidth, int defaultHeight) {
            this.spriteRL = spriteRL;
            this.defaultWidth = defaultWidth;
            this.defaultHeight = defaultHeight;
        }

        public void render(GuiGraphics guiGraphics, int x, int y) {
            this.render(guiGraphics, x, y, 1.0f);
        }

        public void render(GuiGraphics guiGraphics, int x, int y, float scale) {
            this.render(guiGraphics, x, y, scale, scale);
        }

        public void render(GuiGraphics guiGraphics, int x, int y, float scaleWidth, float scaleHeight) {
            this.render(guiGraphics, x, y, Math.round((float)this.defaultWidth * scaleWidth), Math.round((float)this.defaultHeight * scaleHeight));
        }

        public void render(GuiGraphics guiGraphics, int x, int y, int width, int height) {
            GlStateManager._enableBlend();
            guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, this.spriteRL, width, height, 0, 0, x, y, width, height);
        }
    }
}

