/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.Nullable;
import ovh.corail.tombstone.block.entity.BlockEntityDecorativeGrave;
import ovh.corail.tombstone.capability.TBPlayerCapabilityHandler;
import ovh.corail.tombstone.helper.CallbackHandler;
import ovh.corail.tombstone.helper.EffectHelper;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.LootHelper;
import ovh.corail.tombstone.helper.PlacedBlocksTracker;
import ovh.corail.tombstone.helper.PrayerHelper;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.network.CMessagePlayerCapSetWatcherKnowledge;
import ovh.corail.tombstone.network.PacketHandler;
import ovh.corail.tombstone.registry.ModEffects;
import ovh.corail.tombstone.registry.ModItems;
import ovh.corail.tombstone.registry.ModStats;
import ovh.corail.tombstone.registry.ModTags;

public class RitualFluteHandler {
    private static final Map<List<Integer>, Consumer<ServerPlayer>> SEQUENCES = Map.ofEntries(Map.entry(List.of(Integer.valueOf(10), Integer.valueOf(13), Integer.valueOf(10), Integer.valueOf(6), Integer.valueOf(11), Integer.valueOf(15), Integer.valueOf(11), Integer.valueOf(8)), RitualFluteHandler::onHealDeadCoral), Map.entry(List.of(Integer.valueOf(10), Integer.valueOf(13), Integer.valueOf(15), Integer.valueOf(13), Integer.valueOf(11), Integer.valueOf(10), Integer.valueOf(8), Integer.valueOf(6)), RitualFluteHandler::onRitualOfCoralChant), Map.entry(List.of(Integer.valueOf(8), Integer.valueOf(11), Integer.valueOf(13), Integer.valueOf(14), Integer.valueOf(13), Integer.valueOf(10), Integer.valueOf(11), Integer.valueOf(8)), RitualFluteHandler::onRitualOfRemanence));
    private static final Map<UUID, Long> LAST_NOTE_TIME = new ConcurrentHashMap<UUID, Long>();

    public static boolean validateSequence(ServerPlayer serverPlayer, int[] noteArray) {
        ItemStack mainHandStack = serverPlayer.getMainHandItem();
        if (mainHandStack.getItem() != ModItems.ritual_flute || EntityHelper.hasGlobalItemCooldown((Player)serverPlayer, mainHandStack)) {
            return false;
        }
        List<Integer> notes = Arrays.stream(noteArray).boxed().toList();
        for (Map.Entry<List<Integer>, Consumer<ServerPlayer>> entry : SEQUENCES.entrySet()) {
            List<Integer> sequence = entry.getKey();
            if (notes.size() != sequence.size() || !sequence.equals(notes)) continue;
            CallbackHandler.addCallback(40, () -> ((Consumer)entry.getValue()).accept(serverPlayer));
            EntityHelper.setGlobalItemCooldown((Player)serverPlayer, ModItems.ritual_flute, 100);
            return true;
        }
        return false;
    }

    public static void onRitualOfRemanence(ServerPlayer serverPlayer) {
        if (EntityHelper.getCustomStat(serverPlayer, ModStats.ERDOS_FRAGMENTS) < 4) {
            LangKey.MESSAGE_WATCHER_KNOWLEDGE_3_FIND_ERDOS_FRAGMENTS.sendMessage(serverPlayer, new Object[0]);
            return;
        }
        @Nullable BlockPos pos = PrayerHelper.findPrayableBlock(serverPlayer.level(), serverPlayer.blockPosition());
        if (pos == null) {
            return;
        }
        Optional<BlockEntityDecorativeGrave> blockEntity = Helper.getDecorativeGrave((Level)serverPlayer.level(), pos);
        if (blockEntity.isPresent()) {
            if (blockEntity.get().applyScreaming(serverPlayer)) {
                return;
            }
            if (!TBPlayerCapabilityHandler.hasWatcherKnowledge((Player)serverPlayer, 3)) {
                TBPlayerCapabilityHandler.rewardKnowledge(serverPlayer, 10);
                TBPlayerCapabilityHandler.unlockWatcherKnowledge((Player)serverPlayer, 3);
                PacketHandler.sendToPlayer(new CMessagePlayerCapSetWatcherKnowledge(TBPlayerCapabilityHandler.getWatcherKnowledge((Player)serverPlayer)), serverPlayer);
                LangKey.MESSAGE_WATCHER_KNOWLEDGE_3_UNLOCKED.sendMessage(serverPlayer, new Object[0]);
            }
            EffectHelper.addEffect((LivingEntity)serverPlayer, ModEffects.remanence, TimeHelper.tickFromMinute(15), 2, new boolean[0]);
            MutableComponent effectName = ((MobEffect)ModEffects.remanence.value()).getDisplayName().plainCopy().setStyle(StyleType.MESSAGE_SPECIAL);
            LangKey.MESSAGE_SPELL_CAST_ON_YOU.sendMessage(serverPlayer, StyleType.MESSAGE_SPELL, new Object[]{effectName});
            blockEntity.get().applySpammingRite();
        } else {
            LangKey.MESSAGE_RITUAL_FLUTE_NOTHING_HAPPENS.sendMessage(serverPlayer, StyleType.MESSAGE_SPECIAL, new Object[0]);
        }
    }

    public static void onRitualOfCoralChant(ServerPlayer serverPlayer) {
        if (EntityHelper.getCustomStat(serverPlayer, ModStats.CORAL_CHANT) < 4) {
            LangKey.MESSAGE_WATCHER_KNOWLEDGE_2_FIND_CORAL_CHANT.sendMessage(serverPlayer, new Object[0]);
            return;
        }
        @Nullable BlockPos pos = PrayerHelper.findPrayableBlock(serverPlayer.level(), serverPlayer.blockPosition());
        if (pos == null) {
            return;
        }
        Optional<BlockEntityDecorativeGrave> blockEntity = Helper.getDecorativeGrave((Level)serverPlayer.level(), pos);
        if (blockEntity.isPresent()) {
            if (blockEntity.get().applyScreaming(serverPlayer)) {
                return;
            }
            if (!TBPlayerCapabilityHandler.hasWatcherKnowledge((Player)serverPlayer, 2)) {
                TBPlayerCapabilityHandler.rewardKnowledge(serverPlayer, 10);
                TBPlayerCapabilityHandler.unlockWatcherKnowledge((Player)serverPlayer, 2);
                PacketHandler.sendToPlayer(new CMessagePlayerCapSetWatcherKnowledge(TBPlayerCapabilityHandler.getWatcherKnowledge((Player)serverPlayer)), serverPlayer);
                LangKey.MESSAGE_WATCHER_KNOWLEDGE_2_UNLOCKED.sendMessage(serverPlayer, new Object[0]);
            }
            EffectHelper.addEffect((LivingEntity)serverPlayer, ModEffects.aquatic_life, TimeHelper.tickFromMinute(15));
            MutableComponent effectName = ((MobEffect)ModEffects.aquatic_life.value()).getDisplayName().plainCopy().setStyle(StyleType.MESSAGE_SPECIAL);
            LangKey.MESSAGE_SPELL_CAST_ON_YOU.sendMessage(serverPlayer, StyleType.MESSAGE_SPELL, new Object[]{effectName});
            blockEntity.get().applySpammingRite();
        } else {
            LangKey.MESSAGE_RITUAL_FLUTE_NOTHING_HAPPENS.sendMessage(serverPlayer, StyleType.MESSAGE_SPECIAL, new Object[0]);
        }
    }

    public static void onHealDeadCoral(ServerPlayer serverPlayer) {
        int count = EntityHelper.getCustomStat(serverPlayer, ModStats.CORAL_CHANT);
        if (count < 1) {
            LangKey.MESSAGE_RITUAL_FLUTE_NOTHING_HAPPENS.sendMessage(serverPlayer, StyleType.MESSAGE_SPECIAL, new Object[0]);
            return;
        }
        int radius = 3;
        ArrayList coralItems = new ArrayList();
        PlacedBlocksTracker placedBlocksTracker = PlacedBlocksTracker.get(serverPlayer.level());
        BlockPos.betweenClosedStream((BlockPos)serverPlayer.blockPosition().offset(-radius, -1, -radius), (BlockPos)serverPlayer.blockPosition().offset(radius, 1, radius)).forEach(pos -> {
            BlockState state = serverPlayer.level().getBlockState(pos);
            if (state.is(ModTags.Blocks.dead_corals)) {
                if (placedBlocksTracker.contains((BlockPos)pos)) {
                    return;
                }
                Optional.ofNullable(RitualFluteHandler.getCoralItemFrom(state.getBlock())).ifPresent(coralItem -> {
                    coralItems.add(coralItem);
                    serverPlayer.level().removeBlock(pos, false);
                });
            }
        });
        if (!coralItems.isEmpty()) {
            if (count == 1) {
                LootHelper.rewardReadableScroll(serverPlayer, LootHelper.ReadableScrollType.CORAL_CHANT, 2);
            }
            EntityHelper.increaseCustomStat(serverPlayer, ModStats.HEALED_CORAL, coralItems.size());
            coralItems.forEach(coralItem -> ItemHandlerHelper.giveItemToPlayer((Player)serverPlayer, (ItemStack)new ItemStack((ItemLike)coralItem)));
            LangKey.MESSAGE_HEAL_CORAL_SUCCESS.sendMessage(serverPlayer, StyleType.MESSAGE_SPECIAL, new Object[0]);
        } else {
            LangKey.MESSAGE_RITUAL_FLUTE_NOTHING_HAPPENS.sendMessage(serverPlayer, StyleType.MESSAGE_SPECIAL, new Object[0]);
        }
    }

    @Nullable
    private static Item getCoralItemFrom(Block deadBlock) {
        if (deadBlock == Blocks.DEAD_BRAIN_CORAL_BLOCK) {
            return Items.BRAIN_CORAL_BLOCK;
        }
        if (deadBlock == Blocks.DEAD_BUBBLE_CORAL_BLOCK) {
            return Items.BUBBLE_CORAL_BLOCK;
        }
        if (deadBlock == Blocks.DEAD_FIRE_CORAL_BLOCK) {
            return Items.FIRE_CORAL_BLOCK;
        }
        if (deadBlock == Blocks.DEAD_HORN_CORAL_BLOCK) {
            return Items.HORN_CORAL_BLOCK;
        }
        if (deadBlock == Blocks.DEAD_TUBE_CORAL_BLOCK) {
            return Items.TUBE_CORAL_BLOCK;
        }
        if (deadBlock == Blocks.DEAD_BRAIN_CORAL_FAN || deadBlock == Blocks.DEAD_BRAIN_CORAL_WALL_FAN) {
            return Items.BRAIN_CORAL_FAN;
        }
        if (deadBlock == Blocks.DEAD_BUBBLE_CORAL_FAN || deadBlock == Blocks.DEAD_BUBBLE_CORAL_WALL_FAN) {
            return Items.BUBBLE_CORAL_FAN;
        }
        if (deadBlock == Blocks.DEAD_FIRE_CORAL_FAN || deadBlock == Blocks.DEAD_FIRE_CORAL_WALL_FAN) {
            return Items.FIRE_CORAL_FAN;
        }
        if (deadBlock == Blocks.DEAD_HORN_CORAL_FAN || deadBlock == Blocks.DEAD_HORN_CORAL_WALL_FAN) {
            return Items.HORN_CORAL_FAN;
        }
        if (deadBlock == Blocks.DEAD_TUBE_CORAL_FAN || deadBlock == Blocks.DEAD_TUBE_CORAL_WALL_FAN) {
            return Items.TUBE_CORAL_FAN;
        }
        if (deadBlock == Blocks.DEAD_BRAIN_CORAL) {
            return Items.BRAIN_CORAL;
        }
        if (deadBlock == Blocks.DEAD_BUBBLE_CORAL) {
            return Items.BUBBLE_CORAL;
        }
        if (deadBlock == Blocks.DEAD_FIRE_CORAL) {
            return Items.FIRE_CORAL;
        }
        if (deadBlock == Blocks.DEAD_HORN_CORAL) {
            return Items.HORN_CORAL;
        }
        if (deadBlock == Blocks.DEAD_TUBE_CORAL) {
            return Items.TUBE_CORAL;
        }
        return null;
    }

    public static void playNote(ServerPlayer serverPlayer, int noteId) {
        UUID uuid;
        long now = System.currentTimeMillis();
        if (now - LAST_NOTE_TIME.getOrDefault(uuid = serverPlayer.getUUID(), 0L) < 150L) {
            return;
        }
        LAST_NOTE_TIME.put(uuid, now);
        if (noteId >= 0 && noteId < 25) {
            float pitch = (float)Math.pow(2.0, (double)(noteId - 12) / 12.0);
            serverPlayer.level().playSound(null, serverPlayer.blockPosition(), (SoundEvent)SoundEvents.NOTE_BLOCK_FLUTE.value(), SoundSource.PLAYERS, 0.5f, pitch);
            serverPlayer.level().sendParticles((ParticleOptions)ParticleTypes.NOTE, serverPlayer.position().x + (Helper.RANDOM.nextDouble() - 0.5) * 2.0, serverPlayer.position().y + Helper.RANDOM.nextDouble() * 1.5 + 0.5, serverPlayer.position().z + (Helper.RANDOM.nextDouble() - 0.5) * 2.0, 3, 0.3, 0.0, 0.3, 0.1);
        }
    }
}

