/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.helper;

import com.mojang.logging.LogUtils;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.UUIDUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import ovh.corail.tombstone.helper.Location;

public class SerializationHelper {
    private static final Logger LOGGER = LogUtils.getLogger();

    public static boolean getBoolean(ValueInput valueInput, String keyName) {
        return valueInput.getBooleanOr(keyName, false);
    }

    public static void setBoolean(ValueOutput valueOutput, String keyName, boolean value) {
        valueOutput.putBoolean(keyName, value);
    }

    public static long getLong(ValueInput valueInput, String keyName) {
        return valueInput.getLongOr(keyName, 0L);
    }

    public static void setLong(ValueOutput valueOutput, String keyName, long value) {
        valueOutput.putLong(keyName, value);
    }

    public static int getInt(ValueInput valueInput, String keyName) {
        return valueInput.getIntOr(keyName, 0);
    }

    public static Optional<Integer> getOptionalInt(ValueInput valueInput, String keyName) {
        return valueInput.getInt(keyName);
    }

    public static void setInt(ValueOutput valueOutput, String keyName, int value) {
        valueOutput.putInt(keyName, value);
    }

    public static short getShort(ValueInput valueInput, String keyName) {
        return (short)valueInput.getShortOr(keyName, (short)0);
    }

    public static Optional<Short> getOptionalShort(ValueInput valueInput, String keyName) {
        short result = (short)valueInput.getShortOr(keyName, (short)-1);
        return result == -1 ? Optional.empty() : Optional.of(result);
    }

    public static void setShort(ValueOutput valueOutput, String keyName, short value) {
        valueOutput.putShort(keyName, value);
    }

    public static byte getByte(ValueInput valueInput, String keyName) {
        return (byte)(valueInput.getByteOr(keyName, (byte)0) & 0xFF);
    }

    public static void setByte(ValueOutput valueOutput, String keyName, byte value) {
        valueOutput.putByte(keyName, value);
    }

    public static Optional<String> getOptionalString(ValueInput valueInput, String keyName) {
        return valueInput.getString(keyName);
    }

    public static void setString(ValueOutput valueOutput, String keyName, String value) {
        valueOutput.putString(keyName, value);
    }

    public static Optional<Location> getLocation(ValueInput valueInput, String keyName) {
        return SerializationHelper.getBlockPos(valueInput, keyName).flatMap(pos -> SerializationHelper.getWorldKey(valueInput, keyName + "_dim").map(worldKey -> new Location((BlockPos)pos, (ResourceKey<Level>)worldKey)));
    }

    public static void setLocation(ValueOutput valueOutput, String keyName, Location location) {
        SerializationHelper.setBlockPos(valueOutput, keyName, location.getPos());
        SerializationHelper.setWorldKey(valueOutput, keyName + "_dim", location.dim);
    }

    private static Optional<BlockPos> getBlockPos(ValueInput valueInput, String keyName) {
        Optional<Integer> x = SerializationHelper.getOptionalInt(valueInput, keyName + "_x");
        Optional<Integer> y = SerializationHelper.getOptionalInt(valueInput, keyName + "_y");
        Optional<Integer> z = SerializationHelper.getOptionalInt(valueInput, keyName + "_z");
        return x.isPresent() && y.isPresent() && z.isPresent() ? Optional.of(new BlockPos(x.get().intValue(), y.get().intValue(), z.get().intValue())) : Optional.empty();
    }

    private static void setBlockPos(ValueOutput valueOutput, String keyName, BlockPos keyValue) {
        SerializationHelper.setInt(valueOutput, keyName + "_x", keyValue.getX());
        SerializationHelper.setInt(valueOutput, keyName + "_y", keyValue.getY());
        SerializationHelper.setInt(valueOutput, keyName + "_z", keyValue.getZ());
    }

    public static Optional<ResourceKey<Level>> getWorldKey(ValueInput valueInput, String keyName) {
        return valueInput.read(keyName, Level.RESOURCE_KEY_CODEC);
    }

    private static void setWorldKey(ValueOutput valueOutput, String keyName, ResourceKey<Level> worldKey) {
        valueOutput.store(keyName, Level.RESOURCE_KEY_CODEC, worldKey);
    }

    public static Optional<UUID> getUUID(ValueInput valueInput, String keyName) {
        return valueInput.read(keyName, UUIDUtil.CODEC);
    }

    public static void setUUID(ValueOutput valueOutput, String keyName, @Nullable UUID uuid) {
        valueOutput.storeNullable(keyName, UUIDUtil.CODEC, (Object)uuid);
    }

    public static ValueInput convertToValueInput(CompoundTag compoundTag, RegistryAccess registryAccess) {
        ValueInput valueInput;
        try (ProblemReporter.ScopedCollector problemReporter = new ProblemReporter.ScopedCollector(LOGGER);){
            valueInput = TagValueInput.create((ProblemReporter)problemReporter, (HolderLookup.Provider)registryAccess, (CompoundTag)compoundTag);
        }
        return valueInput;
    }

    public static CompoundTag createCompoundTag(Consumer<ValueOutput> consumer, RegistryAccess registryAccess) {
        CompoundTag compoundTag;
        try (ProblemReporter.ScopedCollector problemReporter = new ProblemReporter.ScopedCollector(LOGGER);){
            TagValueOutput tagValueOutput = TagValueOutput.createWithContext((ProblemReporter)problemReporter, (HolderLookup.Provider)registryAccess);
            consumer.accept((ValueOutput)tagValueOutput);
            compoundTag = tagValueOutput.buildResult();
        }
        return compoundTag;
    }
}

