/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.helper;

import com.google.common.io.Files;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.storage.LevelResource;
import net.neoforged.fml.loading.FMLPaths;
import org.jetbrains.annotations.Nullable;

public class StorageHelper {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final LevelResource SAVE_PLAYER_FOLDER = new LevelResource("tombstone" + File.separatorChar + "saved_players");
    private static final LevelResource SAVE_FAMILIAR_FOLDER = new LevelResource("tombstone" + File.separatorChar + "saved_familiars");

    public static File getTombstoneConfigFolder() {
        return new File(FMLPaths.CONFIGDIR.get().toFile(), "tombstone" + File.separatorChar);
    }

    public static File getSavedPlayerFolder(MinecraftServer server) {
        return StorageHelper.getFolder(server, SAVE_PLAYER_FOLDER);
    }

    public static File getSavedFamiliarFolder(MinecraftServer server) {
        return StorageHelper.getFolder(server, SAVE_FAMILIAR_FOLDER);
    }

    private static File getFolder(MinecraftServer server, LevelResource levelResource) {
        return server.getWorldPath(levelResource).toFile();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static <T> T load(Codec<T> codec, @Nullable File file) {
        if (file == null) return null;
        if (!file.exists()) return null;
        try (BufferedReader reader = Files.newReader((File)file, (Charset)StandardCharsets.UTF_8);){
            JsonElement result = JsonParser.parseReader((Reader)reader);
            Object object = codec.decode((DynamicOps)JsonOps.INSTANCE, (Object)result).result().map(Pair::getFirst).orElseThrow();
            return (T)object;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static <T> void save(Codec<T> codec, File file, T value, boolean prettyFormat) {
        try (BufferedWriter writer = Files.newWriter((File)file, (Charset)StandardCharsets.UTF_8);){
            JsonElement result = (JsonElement)codec.encodeStart((DynamicOps)JsonOps.INSTANCE, value).result().orElseThrow();
            String s = prettyFormat ? GSON.toJson(result) : result.toString();
            writer.write(s);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static boolean save(File file, String string) {
        boolean bl;
        block8: {
            BufferedWriter writer = Files.newWriter((File)file, (Charset)StandardCharsets.UTF_8);
            try {
                writer.write(string);
                bl = true;
                if (writer == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (writer != null) {
                        try {
                            ((Writer)writer).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException iOException) {
                    return false;
                }
            }
            ((Writer)writer).close();
        }
        return bl;
    }

    public static boolean save(File file, CompoundTag tag) {
        return StorageHelper.save(file, tag.toString());
    }

    public static String load(@Nullable File file) {
        if (file != null && file.exists()) {
            String string;
            block9: {
                BufferedReader reader = Files.newReader((File)file, (Charset)StandardCharsets.UTF_8);
                try {
                    string = reader.readLine();
                    if (reader == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (reader != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                reader.close();
            }
            return string;
        }
        return "";
    }

    public static CompoundTag loadCompound(@Nullable File file) {
        if (file != null && file.exists()) {
            CompoundTag compoundTag;
            block9: {
                BufferedReader reader = Files.newReader((File)file, (Charset)StandardCharsets.UTF_8);
                try {
                    compoundTag = TagParser.parseCompoundFully((String)reader.readLine());
                    if (reader == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (reader != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                reader.close();
            }
            return compoundTag;
        }
        return new CompoundTag();
    }
}

