/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityReference;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.entity.animal.horse.AbstractChestedHorse;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import ovh.corail.tombstone.capability.FriendlyAnimalHandler;
import ovh.corail.tombstone.capability.ServantUndeadHandler;
import ovh.corail.tombstone.compatibility.CompatibilityArsNouveau;
import ovh.corail.tombstone.compatibility.CompatibilityOccultism;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.PrayerHelper;
import ovh.corail.tombstone.helper.RegistryHelper;
import ovh.corail.tombstone.registry.ModTags;

public enum TamableType {
    TAMABLE(e -> e instanceof TamableAnimal, (player, entity) -> ((TamableAnimal)entity).tame(player), entity -> Optional.ofNullable(((TamableAnimal)entity).getOwnerReference()).map(EntityReference::getUUID).orElse(null), (entity, tag) -> {}),
    HORSE(e -> e instanceof AbstractHorse, (player, entity) -> ((AbstractHorse)entity).tameWithName(player), entity -> Optional.ofNullable(((AbstractHorse)entity).getOwnerReference()).map(EntityReference::getUUID).orElse(null), (entity, tag) -> {
        if (entity instanceof AbstractChestedHorse) {
            AbstractChestedHorse abstractChestedHorse = (AbstractChestedHorse)entity;
            abstractChestedHorse.setChest(false);
        }
    }),
    OCCULTISM_FAMILIAR(CompatibilityOccultism.instance::isFamiliar, CompatibilityOccultism.instance::setFamiliar, CompatibilityOccultism.instance::getOwnerId, (entity, compoundTag) -> {
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            entity.setItemSlot(slot, ItemStack.EMPTY);
        }
    }),
    ARS_NOUVEAU_FAMILIAR(CompatibilityArsNouveau.instance::isFamiliar, CompatibilityArsNouveau.instance::setFamiliar, CompatibilityArsNouveau.instance::getOwnerId, (entity, compoundTag) -> {
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            entity.setItemSlot(slot, ItemStack.EMPTY);
        }
    }),
    FRIENDLY_ANIMAL(e -> e instanceof Fox, (player, entity) -> {
        ((Fox)entity).addTrustedEntity((LivingEntity)player);
        FriendlyAnimalHandler.setOwnerId((Entity)entity, player.getGameProfile().getId());
        FriendlyAnimalHandler.setAI((PathfinderMob)entity);
    }, entity -> FriendlyAnimalHandler.getOwnerId((Entity)entity).orElse(null), (entity, tag) -> {
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            entity.setItemSlot(slot, ItemStack.EMPTY);
        }
    }),
    UNDEAD(PrayerHelper::isValidUndead, (player, entity) -> {
        ServantUndeadHandler.setOwnerId((Entity)entity, player.getGameProfile().getId());
        ServantUndeadHandler.setAI((PathfinderMob)entity);
    }, entity -> EntityHelper.getServantOwnerId((Entity)entity).orElse(null), (entity, tag) -> {
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            entity.setItemSlot(slot, ItemStack.EMPTY);
        }
    });

    final Predicate<Entity> predic;
    final BiConsumer<Player, LivingEntity> tame;
    final Function<LivingEntity, UUID> ownerId;
    final BiConsumer<LivingEntity, CompoundTag> onCapture;
    public static final Map<ResourceLocation, TamableType> TAMABLE_TYPE;
    static final Set<ResourceLocation> SUMMONABLE_TYPE;
    static final ResourceLocation DEFAULT_TAMABLE;

    private TamableType(Predicate<Entity> predic, BiConsumer<Player, LivingEntity> tame, Function<LivingEntity, UUID> ownerId, BiConsumer<LivingEntity, CompoundTag> onCapture) {
        this.predic = predic;
        this.tame = tame;
        this.ownerId = ownerId;
        this.onCapture = onCapture;
    }

    public static void init(Level level) {
        if (!TAMABLE_TYPE.isEmpty() || !SUMMONABLE_TYPE.isEmpty()) {
            return;
        }
        for (Map.Entry entry : BuiltInRegistries.ENTITY_TYPE.entrySet()) {
            try {
                Entity entity = ((EntityType)entry.getValue()).create(level, EntitySpawnReason.EVENT);
                if (entity == null || entity.getType().is(ModTags.EntityTypes.UNHANDLED_TAMABLE)) continue;
                ResourceLocation registryRL = ((ResourceKey)entry.getKey()).location();
                Arrays.stream(TamableType.values()).filter(t -> t.predic.test(entity)).findFirst().ifPresent(tamable -> TAMABLE_TYPE.put(registryRL, (TamableType)((Object)tamable)));
                if (!((EntityType)entry.getValue()).canSummon() || !(entity instanceof Mob)) continue;
                SUMMONABLE_TYPE.add(registryRL);
            }
            catch (Throwable throwable) {}
        }
    }

    public static void clear() {
        TAMABLE_TYPE.clear();
        SUMMONABLE_TYPE.clear();
    }

    public boolean is(@Nullable Entity entity) {
        return Optional.ofNullable(entity).map(Entity::getType).map(RegistryHelper::getRegistryName).map(rl -> TamableType.getType(rl) == this).orElse(false);
    }

    public void setTamedBy(Player player, LivingEntity entity) {
        this.tame.accept(player, entity);
    }

    public static boolean isTamedBy(LivingEntity owner, LivingEntity entity) {
        return Optional.ofNullable(TamableType.getType(entity)).map(t -> t.getOwnerId(entity)).map(id -> id.equals(owner.getUUID())).orElse(false);
    }

    @Nullable
    public UUID getOwnerId(LivingEntity entity) {
        return this.ownerId.apply(entity);
    }

    public void onCapture(LivingEntity entity, CompoundTag tag) {
        this.onCapture.accept(entity, tag);
    }

    public static boolean isTamable(ResourceLocation entityTypeRL) {
        return TamableType.getType(entityTypeRL) != null;
    }

    @Nullable
    public static TamableType getType(@Nullable LivingEntity entity) {
        return Optional.ofNullable(entity).map(Entity::getType).map(RegistryHelper::getRegistryName).map(TamableType::getType).orElse(null);
    }

    @Nullable
    public static TamableType getType(ResourceLocation entityTypeRL) {
        return TAMABLE_TYPE.get(entityTypeRL);
    }

    public static Optional<LangKey> getTypeLangKey(ResourceLocation entityTypeRL) {
        @Nullable TamableType tamableType = TamableType.getType(entityTypeRL);
        if (tamableType == null) {
            return Optional.empty();
        }
        return Optional.of(switch (tamableType.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0, 4 -> LangKey.MESSAGE_ANIMAL;
            case 1 -> LangKey.MESSAGE_MOUNT;
            case 2, 3 -> LangKey.MESSAGE_FAMILIAR;
            case 5 -> LangKey.MESSAGE_UNDEAD;
        });
    }

    public static EntityType<?> getRandomTamableEntityType() {
        List list = TAMABLE_TYPE.keySet().stream().map(RegistryHelper::getEntity).filter(Objects::nonNull).collect(Collectors.toList());
        return Helper.getRandomInList(list).orElse(EntityType.CAT);
    }

    public static ResourceLocation getRandomSummonableEntityType() {
        return Helper.getRandomInList(SUMMONABLE_TYPE).orElse(DEFAULT_TAMABLE);
    }

    public static List<ResourceLocation> getAllTamableEntityTypes() {
        return new ArrayList<ResourceLocation>(TAMABLE_TYPE.keySet());
    }

    static {
        TAMABLE_TYPE = new ConcurrentHashMap<ResourceLocation, TamableType>();
        SUMMONABLE_TYPE = ConcurrentHashMap.newKeySet();
        DEFAULT_TAMABLE = ResourceLocation.withDefaultNamespace((String)"cat");
    }
}

