/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.ZombieVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemCooldowns;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import ovh.corail.tombstone.capability.ProtectedEntityHandler;
import ovh.corail.tombstone.capability.TBPlayerCapabilityHandler;
import ovh.corail.tombstone.helper.CooldownHandler;
import ovh.corail.tombstone.helper.EffectHelper;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.NBTHelper;
import ovh.corail.tombstone.helper.PrayerHelper;
import ovh.corail.tombstone.helper.ProxyHelper;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.helper.TamableType;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.item.CastingType;
import ovh.corail.tombstone.item.ItemCastableMagic;
import ovh.corail.tombstone.network.CMessagePrayer;
import ovh.corail.tombstone.network.PacketHandler;
import ovh.corail.tombstone.registry.ModDataComponents;
import ovh.corail.tombstone.registry.ModEffects;
import ovh.corail.tombstone.registry.ModPerks;

public final class ItemAnkhOfPrayer
extends ItemCastableMagic {
    private static final ItemAttributeModifiers ATTRIBUTE_MODIFIERS = ItemAttributeModifiers.builder().add(Attributes.ENTITY_INTERACTION_RANGE, new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"tombstone", (String)"ankh_range_bonus"), 10.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).build();
    private static final int MAX_USE_COUNT = 40;

    public ItemAnkhOfPrayer() {
        super("ankh_of_prayer", ItemAnkhOfPrayer.getBuilder().component(ModDataComponents.USE_COUNT, (Object)40).fireResistant().attributes(ATTRIBUTE_MODIFIERS), () -> true);
    }

    @Override
    protected void addTooltipInfo(ItemStack stack, List<Component> tooltip) {
        this.addItemDesc(tooltip);
        ProxyHelper.getClientPlayer().ifPresent(player -> {
            if (!this.isFoil(stack)) {
                int cd = CooldownHandler.INSTANCE.getCooldown((Player)player, CooldownHandler.CooldownType.NEXT_PRAY);
                if (cd > 0) {
                    this.addInfo(tooltip, this.getDescriptionId() + ".use1", Component.literal((String)("[" + TimeHelper.getTimeString(cd) + "]")).withStyle(StyleType.TOOLTIP_DESC));
                }
            } else {
                this.addItemUse(tooltip, "2", new Object[0]);
            }
        });
        super.addTooltipInfo(stack, tooltip);
    }

    @Override
    public InteractionResult interactLivingEntity(ItemStack stack, Player player, LivingEntity target, InteractionHand hand) {
        if (EntityHelper.isValidPlayer(player) && hand == InteractionHand.MAIN_HAND && player.getMainHandItem().is((Item)this) && EntityHelper.noGlobalItemCooldown(player, stack) && !CooldownHandler.INSTANCE.hasCooldown(player, CooldownHandler.CooldownType.NEXT_PRAY) && target != null && !target.hasEffect(ModEffects.prayer)) {
            int alignment = TBPlayerCapabilityHandler.getAlignmentLevel(player);
            if (alignment < 0) {
                if (target instanceof Villager) {
                    return this.handleInteractEntity(player, target, 2, target.level().getDifficulty() == Difficulty.PEACEFUL ? LangKey.MESSAGE_DIFFICULTY_PEACEFUL : null);
                }
                @Nullable TamableType tamableType = TamableType.getType(target);
                if (tamableType == TamableType.UNDEAD) {
                    if (alignment < -2) {
                        return this.handleInteractEntity(player, target, 6, target.level().getDifficulty() == Difficulty.PEACEFUL ? LangKey.MESSAGE_DIFFICULTY_PEACEFUL : (tamableType.getOwnerId(target) != null ? LangKey.MESSAGE_FAMILIAR_ALREADY_OWNED : null));
                    }
                    if (alignment < -1) {
                        return this.handleInteractEntity(player, target, 4, target.level().getDifficulty() == Difficulty.PEACEFUL ? LangKey.MESSAGE_DIFFICULTY_PEACEFUL : (tamableType.getOwnerId(target) != null ? LangKey.MESSAGE_FAMILIAR_ALREADY_OWNED : null));
                    }
                }
            } else {
                if (target instanceof ZombieVillager) {
                    return this.handleInteractEntity(player, target, 3, null);
                }
                @Nullable TamableType tamableType = TamableType.getType(target);
                if (tamableType != null && tamableType != TamableType.UNDEAD) {
                    if (alignment > 2) {
                        return this.handleInteractEntity(player, target, 5, tamableType.getOwnerId(target) != null ? LangKey.MESSAGE_FAMILIAR_ALREADY_OWNED : null);
                    }
                    if (alignment > 1) {
                        return this.handleInteractEntity(player, target, 0, tamableType.getOwnerId(target) != null ? LangKey.MESSAGE_FAMILIAR_ALREADY_OWNED : null);
                    }
                }
                if (alignment > 0) {
                    return ProtectedEntityHandler.hasCapability((Entity)target) ? this.handleInteractEntity(player, target, 1, ProtectedEntityHandler.isActive((Entity)target) ? LangKey.MESSAGE_PRAY_OF_PROTECTION_FAILED : null) : InteractionResult.SUCCESS;
                }
            }
        }
        return this.use(player.level(), player, hand);
    }

    private InteractionResult handleInteractEntity(Player player, LivingEntity target, int prayType, @Nullable LangKey failKey) {
        if (failKey != null) {
            if (!player.level().isClientSide()) {
                failKey.sendSpecialMessage((ServerPlayer)player, new Object[0]);
            }
            EntityHelper.setGlobalItemCooldown(player, this, 10);
        } else {
            TARGET.put(player.getGameProfile().getId(), target);
            player.startUsingItem(InteractionHand.MAIN_HAND);
            if (!player.level().isClientSide()) {
                NBTHelper.setUUID(target.getPersistentData(), "prayer", player.getGameProfile().getId());
                NBTHelper.setShort(target.getPersistentData(), "pray_type", (short)prayType);
                int duration = 200;
                EffectHelper.addEffect(target, ModEffects.prayer, 200);
                PacketHandler.sendToAllTrackingPlayersAndSelf(new CMessagePrayer(target.getId(), player.getGameProfile().getId(), prayType, 200), target);
            }
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    public InteractionResult use(Level level, Player player, InteractionHand hand) {
        if (hand != InteractionHand.MAIN_HAND) {
            return InteractionResult.PASS;
        }
        if (CooldownHandler.INSTANCE.hasCooldown(player, CooldownHandler.CooldownType.NEXT_PRAY)) {
            return InteractionResult.CONSUME;
        }
        return super.use(level, player, hand);
    }

    @Override
    protected boolean doEffects(ServerLevel level, ServerPlayer player, ItemStack stack, @Nullable LivingEntity target) {
        int priestLevel;
        if (CooldownHandler.INSTANCE.hasCooldown((Player)player, CooldownHandler.CooldownType.NEXT_PRAY)) {
            return false;
        }
        boolean valid = false;
        if (target != null && target.hasEffect(ModEffects.prayer)) {
            target.removeEffect(ModEffects.prayer);
            int alignment = TBPlayerCapabilityHandler.getAlignmentLevel((Player)player);
            if (PrayerHelper.exorcism(player, target, alignment) || PrayerHelper.zombify(player, target, alignment) || PrayerHelper.dissonance(player, target, alignment) || PrayerHelper.undead(player, target, alignment) || PrayerHelper.protection(player, target, alignment) || PrayerHelper.harmonization(player, target, alignment) || PrayerHelper.empathy(player, target, alignment)) {
                valid = true;
            }
        } else if (PrayerHelper.onGrave(player, player.blockPosition())) {
            valid = true;
        }
        if (valid && ((priestLevel = EntityHelper.getPerkLevelWithBonus((Player)player, ModPerks.priest)) == 0 || Helper.RANDOM.nextInt(100) > priestLevel * 5)) {
            CooldownHandler.INSTANCE.setMaxCooldown(player, CooldownHandler.CooldownType.NEXT_PRAY);
        }
        return valid;
    }

    @Override
    protected ItemCastableMagic.CastingTarget getCastingTarget(ItemStack stack) {
        return ItemCastableMagic.CastingTarget.TARGET_OR_SELF;
    }

    @Override
    protected ItemStack onConsumeItem(Player player, ItemStack stack) {
        int useCount = (Integer)stack.getOrDefault(ModDataComponents.USE_COUNT, (Object)40);
        if (useCount < 2) {
            return ItemStack.EMPTY;
        }
        stack.set(ModDataComponents.USE_COUNT, (Object)(--useCount));
        return stack;
    }

    @Override
    public boolean isFoil(ItemStack stack) {
        return ProxyHelper.getClientPlayer().filter(player -> !EntityHelper.hasGlobalItemCooldown(player, stack)).map(player -> {
            int cooldownToPray = CooldownHandler.INSTANCE.getCooldown((Player)player, CooldownHandler.CooldownType.NEXT_PRAY);
            if (cooldownToPray > 0) {
                int maxTime = CooldownHandler.CooldownType.NEXT_PRAY.getMaxCooldown();
                int elapsedTime = maxTime - cooldownToPray;
                ItemCooldowns cd = player.getCooldowns();
                cd.tickCount -= elapsedTime;
                cd.addCooldown(stack, maxTime);
                cd.tickCount += elapsedTime;
                return false;
            }
            return true;
        }).orElse(false);
    }

    @Override
    protected void produceParticleCasting(ItemStack stack, Player player) {
        ProxyHelper.produceParticleCasting(CastingType.PRAY, (LivingEntity)player, p -> !player.isUsingItem() || player.getTicksUsingItem() == 1);
    }

    @Override
    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 100;
    }

    public boolean onLeftClickEntity(ItemStack stack, Player player, Entity entity) {
        return stack.is((Item)this);
    }

    public boolean supportsEnchantment(ItemStack stack, Holder<Enchantment> enchantment) {
        return false;
    }

    public boolean isBarVisible(ItemStack stack) {
        return (Integer)stack.getOrDefault(ModDataComponents.USE_COUNT, (Object)40) < 40;
    }

    public int getBarColor(ItemStack stack) {
        return Mth.hsvToRgb((float)(Math.max(0.0f, (float)(1.0 - this.getDurability(stack))) / 1.5f), (float)1.0f, (float)1.0f);
    }

    public int getBarWidth(ItemStack stack) {
        return Math.round(13.0f - (float)this.getDurability(stack) * 13.0f);
    }

    private double getDurability(ItemStack stack) {
        return 1.0 - (double)((Integer)stack.getOrDefault(ModDataComponents.USE_COUNT, (Object)40)).intValue() / 40.0;
    }
}

