/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import ovh.corail.tombstone.api.item.ISoulConsumer;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.item.ItemBook;
import ovh.corail.tombstone.registry.ModPerks;
import ovh.corail.tombstone.registry.ModTriggers;

public class ItemBookOfDisenchantment
extends ItemBook {
    public ItemBookOfDisenchantment() {
        super("book_of_disenchantment", () -> SharedConfigTombstone.allowed_magic_items.allowBookOfDisenchantment.get());
    }

    @Override
    public ISoulConsumer.ConsumeResult setEnchant(Level level, BlockPos gravePos, ServerPlayer player, ItemStack stack, int soulStrength) {
        boolean isEnchantedBook;
        ItemStack mainhand;
        if (stack.getItem() != this || (mainhand = player.getMainHandItem()).isEmpty()) {
            return ISoulConsumer.ConsumeResult.fail((Component)LangKey.MESSAGE_DISENCHANTMENT_FAILED.getText(new Object[0]));
        }
        boolean bl = isEnchantedBook = mainhand.getItem() == Items.ENCHANTED_BOOK;
        if (isEnchantedBook && !((Boolean)ConfigTombstone.magic_item.canDisenchantEnchantedBook.get()).booleanValue()) {
            return ISoulConsumer.ConsumeResult.fail((Component)LangKey.MESSAGE_DISENCHANTMENT_DENIED_ITEM.getText(Component.translatable((String)Items.ENCHANTED_BOOK.getDescriptionId()).setStyle(StyleType.TOOLTIP_ITEM)));
        }
        ItemEnchantments itemEnchantments = EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)mainhand);
        if (itemEnchantments.isEmpty()) {
            return ISoulConsumer.ConsumeResult.fail((Component)LangKey.MESSAGE_DISENCHANTMENT_NO_ENCHANTMENT.getText(new Object[0]));
        }
        if (isEnchantedBook && itemEnchantments.size() == 1) {
            return ISoulConsumer.ConsumeResult.fail((Component)LangKey.MESSAGE_DISENCHANTMENT_FAILED.getText(new Object[0]));
        }
        stack.shrink(1);
        int enchantMax = EntityHelper.getPerkLevelWithBonus((Player)player, ModPerks.scribe) + 2;
        ItemEnchantments.Mutable mainHandEnchantments = new ItemEnchantments.Mutable(ItemEnchantments.EMPTY);
        int enchantCount = 0;
        for (Object2IntMap.Entry entry : itemEnchantments.entrySet()) {
            if (entry.getKey() == null) continue;
            if (enchantCount < enchantMax) {
                ItemStack book = new ItemStack((ItemLike)Items.ENCHANTED_BOOK);
                ItemEnchantments.Mutable bookEnchantments = new ItemEnchantments.Mutable(ItemEnchantments.EMPTY);
                bookEnchantments.set((Holder)entry.getKey(), entry.getIntValue());
                EnchantmentHelper.setEnchantments((ItemStack)book, (ItemEnchantments)bookEnchantments.toImmutable());
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)book);
                ++enchantCount;
                continue;
            }
            mainHandEnchantments.set((Holder)entry.getKey(), entry.getIntValue());
        }
        int left = mainHandEnchantments.keySet().size();
        if (left > 0) {
            EnchantmentHelper.setEnchantments((ItemStack)mainhand, (ItemEnchantments)mainHandEnchantments.toImmutable());
        } else if (isEnchantedBook) {
            mainhand.shrink(1);
        } else {
            mainhand.set(DataComponents.ENCHANTMENTS, (Object)ItemEnchantments.EMPTY);
            mainhand.set(DataComponents.REPAIR_COST, (Object)(mainhand.has(DataComponents.CUSTOM_NAME) ? 1 : 0));
        }
        ModTriggers.use_disenchantment.trigger(player);
        return ISoulConsumer.ConsumeResult.success((Component)(left == 0 || isEnchantedBook && left == 1 ? LangKey.MESSAGE_DISENCHANTMENT_SUCCESS.getText(new Object[0]) : LangKey.MESSAGE_DISENCHANTMENT_PARTIAL_SUCCESS.getText(left)), 1);
    }
}

