/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import ovh.corail.tombstone.api.item.ISoulConsumer;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.RegistryHelper;
import ovh.corail.tombstone.item.ItemBook;
import ovh.corail.tombstone.registry.ModTriggers;

public class ItemBookOfRecycling
extends ItemBook {
    public ItemBookOfRecycling() {
        super("book_of_recycling", () -> SharedConfigTombstone.allowed_magic_items.allowBookOfRecycling.get());
    }

    @Override
    public ISoulConsumer.ConsumeResult setEnchant(Level level, BlockPos gravePos, ServerPlayer player, ItemStack stack, int soulStrength) {
        int count;
        ItemStack mainhand;
        if (stack.getItem() != this || (mainhand = player.getMainHandItem()).isEmpty()) {
            return ISoulConsumer.ConsumeResult.fail((Component)LangKey.MESSAGE_RECYCLING_FAILED.getText(new Object[0]));
        }
        if (Helper.containRL((List)ConfigTombstone.magic_item.deniedItemToRecycle.get(), RegistryHelper.getRegistryName(mainhand.getItem()))) {
            return ISoulConsumer.ConsumeResult.fail((Component)LangKey.MESSAGE_RECYCLING_DENIED.getText(new Object[0]));
        }
        if (mainhand.isDamaged() && !((Boolean)ConfigTombstone.magic_item.canRecycleDamagedItem.get()).booleanValue()) {
            return ISoulConsumer.ConsumeResult.fail((Component)LangKey.MESSAGE_CANT_RECYCLE_DAMAGED.getText(new Object[0]));
        }
        if (mainhand.has(DataComponents.CONTAINER) || mainhand.has(DataComponents.BUNDLE_CONTENTS)) {
            return ISoulConsumer.ConsumeResult.fail((Component)LangKey.MESSAGE_CANT_RECYCLE_CONTAINER.getText(new Object[0]));
        }
        ArrayList<ItemStack> ingredients = new ArrayList<ItemStack>();
        ItemStack recipeResult = this.checkAdditionalRecipes(mainhand.getItem(), ingredients);
        if (recipeResult.isEmpty()) {
            ShapelessRecipe shapelessRecipe;
            DataComponentPatch mainhandComponentsPatch = mainhand.getComponentsPatch();
            CraftingRecipe recipe = Objects.requireNonNull(player.getServer()).getRecipeManager().recipeMap().byType(RecipeType.CRAFTING).stream().map(RecipeHolder::value).filter(r -> {
                ItemStack itemStack;
                if (r instanceof ShapelessRecipe) {
                    ShapelessRecipe shapelessRecipe = (ShapelessRecipe)r;
                    itemStack = shapelessRecipe.result;
                } else if (r instanceof ShapedRecipe) {
                    ShapedRecipe shapedRecipe = (ShapedRecipe)r;
                    itemStack = shapedRecipe.result;
                } else {
                    itemStack = ItemStack.EMPTY;
                }
                ItemStack result = itemStack;
                return result.is(mainhand.getItem()) && Helper.hasDataComponentPatch(mainhandComponentsPatch, result.getComponentsPatch());
            }).max(Comparator.comparingLong(r -> {
                long l;
                if (r instanceof ShapelessRecipe) {
                    ShapelessRecipe shapelessRecipe = (ShapelessRecipe)r;
                    l = shapelessRecipe.ingredients.size();
                } else if (r instanceof ShapedRecipe) {
                    ShapedRecipe shapedRecipe = (ShapedRecipe)r;
                    l = (int)shapedRecipe.getIngredients().stream().filter(Optional::isPresent).count();
                } else {
                    l = 0L;
                }
                return l;
            })).orElse(null);
            if (recipe == null) {
                return ISoulConsumer.ConsumeResult.fail((Component)LangKey.MESSAGE_NO_RECIPE_TO_RECYCLE.getText(new Object[0]));
            }
            if (recipe instanceof ShapelessRecipe) {
                shapelessRecipe = (ShapelessRecipe)recipe;
                v0 = shapelessRecipe.result;
            } else if (recipe instanceof ShapedRecipe) {
                ShapedRecipe shapedRecipe = (ShapedRecipe)recipe;
                v0 = shapedRecipe.result;
            } else {
                v0 = recipeResult = ItemStack.EMPTY;
            }
            if (recipeResult.isEmpty() || recipeResult.getCount() > mainhand.getCount()) {
                return ISoulConsumer.ConsumeResult.fail((Component)LangKey.MESSAGE_RECYCLING_NOT_ENOUGH.getText(new Object[0]));
            }
            List<Object> recipeIngredients = new ArrayList();
            if (recipe instanceof ShapelessRecipe) {
                shapelessRecipe = (ShapelessRecipe)recipe;
                recipeIngredients = shapelessRecipe.ingredients.stream().map(Optional::of).collect(Collectors.toList());
            } else if (recipe instanceof ShapedRecipe) {
                ShapedRecipe shapedRecipe = (ShapedRecipe)recipe;
                recipeIngredients = shapedRecipe.pattern.ingredients();
            }
            count = recipeIngredients.size();
            NonNullList grid = NonNullList.withSize((int)9, (Object)ItemStack.EMPTY);
            for (int slotId2 = 0; slotId2 < count; ++slotId2) {
                Optional optionalIngredient = (Optional)recipeIngredients.get(slotId2);
                ItemStack[] items = optionalIngredient.map(ingredient -> (ItemStack[])ingredient.items().map(Holder::value).map(ItemStack::new).toArray(ItemStack[]::new)).orElseGet(() -> new ItemStack[]{ItemStack.EMPTY});
                ItemStack result = items[Helper.RANDOM.nextInt(items.length)];
                if (result.isEmpty()) continue;
                grid.set(slotId2, (Object)result.copy());
            }
            NonNullList remains = recipe.getRemainingItems(CraftingInput.of((int)3, (int)3, (List)grid));
            IntStream.range(0, count).filter(slotId -> ((ItemStack)remains.get(slotId)).isEmpty()).mapToObj(arg_0 -> ((NonNullList)grid).get(arg_0)).filter(i -> !i.isEmpty()).forEach(ingredients::add);
        }
        if (ingredients.isEmpty()) {
            return ISoulConsumer.ConsumeResult.fail((Component)LangKey.MESSAGE_NO_RECIPE_TO_RECYCLE.getText(new Object[0]));
        }
        int maxRecycle = mainhand.getCount() / recipeResult.getCount();
        stack.shrink(1);
        mainhand.shrink(recipeResult.getCount() * maxRecycle);
        for (ItemStack ingredient2 : ingredients) {
            count = ingredient2.getCount() * maxRecycle;
            int maxSize = ingredient2.getMaxStackSize();
            int fullStacks = count / maxSize;
            for (int i2 = 0; i2 < fullStacks; ++i2) {
                ItemStack newStack = ingredient2.copy();
                newStack.setCount(maxSize);
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)newStack);
            }
            int left = count - fullStacks * maxSize;
            if (left <= 0) continue;
            ItemStack leftStack = ingredient2.copy();
            leftStack.setCount(left);
            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)leftStack);
        }
        ModTriggers.use_recycling.trigger(player);
        return ISoulConsumer.ConsumeResult.success((Component)LangKey.MESSAGE_RECYCLING_SUCCESS.getText(new Object[0]), 1);
    }

    private ItemStack checkAdditionalRecipes(Item searchItem, List<ItemStack> ingredients) {
        if (searchItem == Items.LEATHER_HORSE_ARMOR) {
            ingredients.add(new ItemStack((ItemLike)Items.LEATHER, 7));
            return new ItemStack((ItemLike)Items.LEATHER_HORSE_ARMOR);
        }
        if (searchItem == Items.IRON_HORSE_ARMOR) {
            ingredients.add(new ItemStack((ItemLike)Items.IRON_INGOT, 7));
            return new ItemStack((ItemLike)Items.IRON_HORSE_ARMOR);
        }
        if (searchItem == Items.GOLDEN_HORSE_ARMOR) {
            ingredients.add(new ItemStack((ItemLike)Items.GOLD_INGOT, 7));
            return new ItemStack((ItemLike)Items.GOLDEN_HORSE_ARMOR);
        }
        if (searchItem == Items.DIAMOND_HORSE_ARMOR) {
            ingredients.add(new ItemStack((ItemLike)Items.DIAMOND, 7));
            return new ItemStack((ItemLike)Items.DIAMOND_HORSE_ARMOR);
        }
        if (searchItem == Items.NETHERITE_AXE || searchItem == Items.NETHERITE_PICKAXE) {
            ingredients.add(new ItemStack((ItemLike)Items.DIAMOND, 3));
            ingredients.add(new ItemStack((ItemLike)Items.STICK, 2));
            ingredients.add(new ItemStack((ItemLike)Items.NETHERITE_INGOT));
            return new ItemStack((ItemLike)searchItem);
        }
        if (searchItem == Items.NETHERITE_SWORD) {
            ingredients.add(new ItemStack((ItemLike)Items.DIAMOND, 2));
            ingredients.add(new ItemStack((ItemLike)Items.STICK));
            ingredients.add(new ItemStack((ItemLike)Items.NETHERITE_INGOT));
            return new ItemStack((ItemLike)Items.NETHERITE_SWORD);
        }
        if (searchItem == Items.NETHERITE_HOE) {
            ingredients.add(new ItemStack((ItemLike)Items.DIAMOND, 2));
            ingredients.add(new ItemStack((ItemLike)Items.STICK, 2));
            ingredients.add(new ItemStack((ItemLike)Items.NETHERITE_INGOT));
            return new ItemStack((ItemLike)Items.NETHERITE_HOE);
        }
        if (searchItem == Items.NETHERITE_SHOVEL) {
            ingredients.add(new ItemStack((ItemLike)Items.DIAMOND));
            ingredients.add(new ItemStack((ItemLike)Items.STICK, 2));
            ingredients.add(new ItemStack((ItemLike)Items.NETHERITE_INGOT));
            return new ItemStack((ItemLike)Items.NETHERITE_SHOVEL);
        }
        if (searchItem == Items.NETHERITE_BOOTS) {
            ingredients.add(new ItemStack((ItemLike)Items.DIAMOND, 4));
            ingredients.add(new ItemStack((ItemLike)Items.NETHERITE_INGOT));
            return new ItemStack((ItemLike)Items.NETHERITE_BOOTS);
        }
        if (searchItem == Items.NETHERITE_HELMET) {
            ingredients.add(new ItemStack((ItemLike)Items.DIAMOND, 5));
            ingredients.add(new ItemStack((ItemLike)Items.NETHERITE_INGOT));
            return new ItemStack((ItemLike)Items.NETHERITE_HELMET);
        }
        if (searchItem == Items.NETHERITE_CHESTPLATE) {
            ingredients.add(new ItemStack((ItemLike)Items.DIAMOND, 8));
            ingredients.add(new ItemStack((ItemLike)Items.NETHERITE_INGOT));
            return new ItemStack((ItemLike)Items.NETHERITE_CHESTPLATE);
        }
        if (searchItem == Items.NETHERITE_LEGGINGS) {
            ingredients.add(new ItemStack((ItemLike)Items.DIAMOND, 7));
            ingredients.add(new ItemStack((ItemLike)Items.NETHERITE_INGOT));
            return new ItemStack((ItemLike)Items.NETHERITE_LEGGINGS);
        }
        return ItemStack.EMPTY;
    }
}

