/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.BooleanSupplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.event.EventHooks;
import org.jetbrains.annotations.Nullable;
import ovh.corail.tombstone.capability.TBPlayerCapabilityHandler;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.ProxyHelper;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.item.CastingType;
import ovh.corail.tombstone.item.ItemGeneric;
import ovh.corail.tombstone.registry.ModPerks;
import ovh.corail.tombstone.registry.ModSounds;

public abstract class ItemCastableMagic
extends ItemGeneric {
    protected static final Map<UUID, Long> USING = new ConcurrentHashMap<UUID, Long>();
    protected static final Map<UUID, LivingEntity> TARGET = new ConcurrentHashMap<UUID, LivingEntity>();

    protected ItemCastableMagic(String name, Item.Properties builder, BooleanSupplier supplierEnabled) {
        super(name, builder, supplierEnabled);
    }

    public Component getName(ItemStack stack) {
        return super.getName(stack).plainCopy().setStyle(StyleType.MESSAGE_SPECIAL);
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        return EntityHelper.isValidPlayer(context.getPlayer()) && this.getCastingTarget(stack) != CastingTarget.TARGET_ONLY ? (this.canBlockInteractFirst(context.getLevel(), context.getClickedPos(), stack) ? InteractionResult.PASS : this.use(context.getLevel(), context.getPlayer(), context.getHand())) : InteractionResult.FAIL;
    }

    public InteractionResult interactLivingEntity(ItemStack stack, Player player, LivingEntity target, InteractionHand hand) {
        CastingTarget castingTarget = this.getCastingTarget(stack);
        if (castingTarget == CastingTarget.TARGET_OR_SELF || castingTarget == CastingTarget.TARGET_ONLY) {
            if (this.isTargetForCasting(player, target)) {
                if (this.canAffectTarget(stack, target)) {
                    UUID uuid = player.getGameProfile().getId();
                    TARGET.put(uuid, target);
                    InteractionResult result = this.use(player.level(), player, hand);
                    if (result.consumesAction()) {
                        return InteractionResult.SUCCESS;
                    }
                    TARGET.remove(uuid);
                    return result;
                }
                if (!player.level().isClientSide()) {
                    LangKey.MESSAGE_CANT_APPLY_EFFECT.sendMessage((ServerPlayer)player, target.getName());
                }
                EntityHelper.setGlobalItemCooldown(player, this, 10);
                return InteractionResult.SUCCESS;
            }
            if (castingTarget == CastingTarget.TARGET_ONLY) {
                return InteractionResult.SUCCESS;
            }
        }
        return this.use(player.level(), player, hand);
    }

    public InteractionResult use(Level level, Player player, InteractionHand hand) {
        ItemStack heldStack = player.getItemInHand(hand);
        if (this.getCastingTarget(heldStack) == CastingTarget.TARGET_ONLY && TARGET.get(player.getGameProfile().getId()) == null || !EntityHelper.isValidPlayer(player)) {
            return InteractionResult.FAIL;
        }
        if (!heldStack.is((Item)this)) {
            return InteractionResult.PASS;
        }
        if (EntityHelper.hasGlobalItemCooldown(player, heldStack)) {
            return InteractionResult.CONSUME;
        }
        player.startUsingItem(hand);
        return InteractionResult.SUCCESS;
    }

    public boolean releaseUsing(ItemStack stack, Level level, LivingEntity entity, int timeLeft) {
        this.resetCasting((Player)entity);
        return super.releaseUsing(stack, level, entity, timeLeft);
    }

    public ItemStack finishUsingItem(ItemStack stack, @Nullable Level level, LivingEntity entity) {
        if (EntityHelper.isValidPlayer((Entity)entity)) {
            ServerPlayer player;
            if (stack.is((Item)this) && EntityHelper.noGlobalItemCooldown((Player)entity, stack) && !entity.level().isClientSide() && this.doEffects((player = (ServerPlayer)entity).level(), player, stack, TARGET.get(player.getGameProfile().getId()))) {
                player.level().playSound(null, player.blockPosition(), ModSounds.magic_use01, SoundSource.PLAYERS, 0.5f, 1.0f);
                if (!player.getAbilities().instabuild && this.canConsumeOnUse()) {
                    stack = this.onConsumeItem((Player)player, stack);
                }
            }
            EntityHelper.setGlobalItemCooldown((Player)entity, this, 10);
            this.resetCasting((Player)entity);
        }
        return stack;
    }

    protected ItemStack onConsumeItem(Player player, ItemStack stack) {
        if (stack.getCount() > 1) {
            stack.shrink(1);
            return stack;
        }
        return ItemStack.EMPTY;
    }

    public void onUseTick(Level level, LivingEntity entity, ItemStack stack, int timeLeft) {
        boolean isStarting;
        if (!stack.is((Item)this) || !EntityHelper.isValidPlayer((Entity)entity)) {
            return;
        }
        Player player = (Player)entity;
        boolean bl = isStarting = timeLeft == this.getUseDuration(stack, (LivingEntity)player);
        if (isStarting) {
            int concentrationLevel = TBPlayerCapabilityHandler.getPerkLevelWithBonus(player, ModPerks.channeler);
            USING.put(player.getGameProfile().getId(), TimeHelper.systemTime() + (long)((float)TimeUnit.SECONDS.toMillis(1L) * ((float)this.getUseDuration(stack, (LivingEntity)player) / 20.0f * (1.0f - (float)concentrationLevel * 0.15f))));
            if (player.level().isClientSide()) {
                this.produceParticleCasting(stack, player);
            } else {
                level.playSound(null, player.blockPosition(), SoundEvents.EVOKER_CAST_SPELL, SoundSource.PLAYERS, 0.5f, 1.0f);
            }
        } else if (!player.level().isClientSide() && USING.containsKey(player.getGameProfile().getId()) && USING.get(player.getGameProfile().getId()) < TimeHelper.systemTime() && player.isUsingItem() && player.getUseItem().is((Item)this)) {
            ItemStack resultStack = EventHooks.onItemUseFinish((LivingEntity)player, (ItemStack)player.getUseItem().copy(), (int)0, (ItemStack)player.getUseItem().finishUsingItem(player.level(), (LivingEntity)player));
            if (resultStack != player.getUseItem()) {
                player.setItemInHand(player.getUsedItemHand(), resultStack);
            }
            player.stopUsingItem();
        }
    }

    protected void produceParticleCasting(ItemStack stack, Player player) {
        ProxyHelper.produceParticleCasting(CastingType.SCROLL, Optional.ofNullable(TARGET.get(player.getGameProfile().getId())).orElse((LivingEntity)player), p -> !player.isUsingItem() || player.getTicksUsingItem() == 1);
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 80;
    }

    public ItemUseAnimation getUseAnimation(ItemStack stack) {
        return ItemUseAnimation.BOW;
    }

    protected abstract boolean doEffects(ServerLevel var1, ServerPlayer var2, ItemStack var3, @Nullable LivingEntity var4);

    protected boolean canBlockInteractFirst(Level level, BlockPos pos, ItemStack stack) {
        return false;
    }

    protected boolean isTargetForCasting(Player player, @Nullable LivingEntity target) {
        return false;
    }

    protected boolean canAffectTarget(ItemStack stack, LivingEntity target) {
        return true;
    }

    protected boolean canConsumeOnUse() {
        return true;
    }

    protected CastingTarget getCastingTarget(ItemStack stack) {
        return CastingTarget.SELF;
    }

    private void resetCasting(Player player) {
        UUID uuid = player.getGameProfile().getId();
        USING.remove(uuid);
        TARGET.remove(uuid);
    }

    protected static Item.Properties getBuilder() {
        return ItemGeneric.getBuilder().stacksTo(1).fireResistant();
    }

    protected static enum CastingTarget {
        SELF,
        AREA,
        TARGET_ONLY,
        TARGET_OR_SELF;

    }
}

