/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.HashSet;
import java.util.Set;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.helper.CallbackHandler;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.item.ItemMagicDust;

public class ItemDustOfFrost
extends ItemMagicDust {
    public ItemDustOfFrost() {
        super("dust_of_frost", () -> SharedConfigTombstone.allowed_magic_items.allowDustOfFrost.get());
    }

    @Override
    protected void onTeleportBackward(ServerPlayer player, Vec3 posVec, Vec3 lookVec, Location spawnPos) {
        ServerLevel level = player.level();
        HashSet<BlockPos> positions = new HashSet<BlockPos>();
        Vec3 crossVec = new Vec3(player.getLookAngle().x, 0.0, player.getLookAngle().z).normalize().cross(new Vec3(0.0, 1.0, 0.0)).scale(0.5);
        positions.add(BlockPos.containing((Position)posVec));
        IntStream.rangeClosed(1, 4).forEach(i -> {
            positions.add(BlockPos.containing((Position)posVec.add(crossVec.scale((double)i))));
            positions.add(BlockPos.containing((Position)posVec.add(crossVec.scale((double)i).reverse())));
        });
        positions.stream().toList().forEach(pos -> {
            positions.add(pos.above());
            positions.add(pos.above(2));
        });
        positions.removeIf(arg_0 -> ItemDustOfFrost.lambda$onTeleportBackward$2((Level)level, arg_0));
        BlockState powderState = Blocks.POWDER_SNOW.defaultBlockState();
        positions.forEach(arg_0 -> ItemDustOfFrost.lambda$onTeleportBackward$3((Level)level, powderState, arg_0));
        CallbackHandler.addCallback(200, () -> ItemDustOfFrost.lambda$onTeleportBackward$6(positions, (Level)level));
    }

    private static /* synthetic */ void lambda$onTeleportBackward$6(Set positions, Level level) {
        positions.stream().filter(pos -> level.getBlockState(pos).is(Blocks.POWDER_SNOW)).forEach(pos -> level.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState()));
    }

    private static /* synthetic */ void lambda$onTeleportBackward$3(Level level, BlockState powderState, BlockPos pos) {
        level.setBlockAndUpdate(pos, powderState);
    }

    private static /* synthetic */ boolean lambda$onTeleportBackward$2(Level level, BlockPos pos) {
        BlockState state = level.getBlockState(pos);
        return !state.isAir() && !state.canBeReplaced();
    }
}

