/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.List;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import ovh.corail.tombstone.api.item.ISoulConsumer;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.GlobalClock;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.ProxyHelper;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.item.CastingType;
import ovh.corail.tombstone.item.ItemCastableMagic;
import ovh.corail.tombstone.registry.ModBlocks;
import ovh.corail.tombstone.registry.ModDataComponents;
import ovh.corail.tombstone.registry.ModSounds;

public abstract class ItemGraveMagic
extends ItemCastableMagic
implements ISoulConsumer {
    protected ItemGraveMagic(String name, BooleanSupplier supplierBoolean) {
        this(name, ItemGraveMagic.getBuilder(), supplierBoolean);
    }

    protected ItemGraveMagic(String name, Item.Properties builder, BooleanSupplier supplierEnabled) {
        super(name, builder, supplierEnabled);
    }

    @Override
    public Component getName(ItemStack stack) {
        Component name = super.getName(stack);
        return this.isAncient(stack) ? LangKey.MESSAGE_ANCIENT_ITEM.getText(name).setStyle(StyleType.MESSAGE_SPECIAL) : (this.isEnchanted(stack) ? LangKey.MESSAGE_ENCHANTED_ITEM.getText(name).setStyle(StyleType.MESSAGE_SPECIAL) : name);
    }

    @Override
    protected void addTooltipInfo(ItemStack stack, List<Component> tooltip) {
        int cd;
        if (this.isEnchanted(stack) && (cd = this.getCooldown(ProxyHelper.getClientWorld().get(), stack)) > 10) {
            this.addWarn(tooltip, LangKey.MESSAGE_IN_COOLDOWN, TimeHelper.getTimeStringWithUnit(cd));
        }
        super.addTooltipInfo(stack, tooltip);
    }

    @Override
    public boolean isFoil(ItemStack stack) {
        return this.isEnchanted(stack);
    }

    @Override
    public InteractionResult use(Level level, Player player, InteractionHand hand) {
        ItemStack heldStack = player.getItemInHand(hand);
        int cd = this.getCooldown(level, heldStack);
        if (cd > 0) {
            if (!level.isClientSide()) {
                EntityHelper.setGlobalItemCooldown(player, this, 20);
                LangKey.MESSAGE_IN_COOLDOWN.sendMessage((ServerPlayer)player, TimeHelper.getTimeStringWithUnit(cd));
            }
            return InteractionResult.FAIL;
        }
        return this.isEnchanted(heldStack) ? super.use(level, player, hand) : InteractionResult.PASS;
    }

    @Override
    public void onUseTick(Level level, LivingEntity entity, ItemStack stack, int timeLeft) {
        if (this.isEnchanted(stack)) {
            super.onUseTick(level, entity, stack, timeLeft);
        }
    }

    @Override
    protected void produceParticleCasting(ItemStack stack, Player player) {
        ProxyHelper.produceParticleCasting(this.getCastingType(stack), Optional.ofNullable((LivingEntity)TARGET.get(player.getGameProfile().getId())).orElse((LivingEntity)player), p -> !player.isUsingItem() || player.getTicksUsingItem() == 1);
    }

    protected CastingType getCastingType(ItemStack stack) {
        return CastingType.SIMPLE_TELEPORT;
    }

    @Override
    protected boolean doEffects(ServerLevel level, ServerPlayer player, ItemStack stack, @Nullable LivingEntity target) {
        if (this.isEnchanted(stack)) {
            int cd;
            level.playSound(null, player.blockPosition(), ModSounds.magic_use01, SoundSource.PLAYERS, 0.5f, 1.0f);
            if (!stack.isEmpty() && (cd = this.getCastingCooldown()) > 0) {
                this.setCooldown((Level)level, stack, cd);
            }
        }
        return false;
    }

    protected int getCastingCooldown() {
        return 0;
    }

    public int getCooldown(Level level, ItemStack stack) {
        return stack.is((Item)this) ? ModDataComponents.getTimer(GlobalClock.INSTANCE.getTime(level), stack, ModDataComponents.COOLDOWN_TIME, this.getCastingCooldown()) : 0;
    }

    public void setCooldown(Level level, ItemStack stack, int time) {
        if (stack.is((Item)this)) {
            stack.set(ModDataComponents.COOLDOWN_TIME, (Object)(GlobalClock.INSTANCE.getTime(level) + (long)time));
        }
    }

    @Override
    protected boolean canBlockInteractFirst(Level level, BlockPos pos, ItemStack stack) {
        return !this.isEnchanted(stack) || ModBlocks.isDecorativeGrave(level.getBlockState(pos).getBlock());
    }

    @Override
    public boolean canEnchant(Level level, BlockPos gravePos, Player player, ItemStack stack) {
        return this.isEnabled();
    }

    public boolean isAncient(ItemStack stack) {
        return stack.is((Item)this) && (Boolean)stack.getOrDefault(ModDataComponents.ANCIENT, (Object)false) != false;
    }
}

