/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.item.component.Consumables;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootContext;
import ovh.corail.tombstone.helper.EffectHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.item.ItemGeneric;
import ovh.corail.tombstone.loot.IDelayedNBTLoot;
import ovh.corail.tombstone.registry.ModDataComponents;
import ovh.corail.tombstone.registry.ModItems;
import ovh.corail.tombstone.registry.ModTriggers;

public class ItemLollipop
extends ItemGeneric
implements IDelayedNBTLoot {
    public ItemLollipop() {
        super("lollipop", ItemLollipop.getBuilder().food(new FoodProperties.Builder().nutrition(2).saturationModifier(2.0f).alwaysEdible().build(), Consumables.defaultFood().consumeSeconds(0.8f).build()));
    }

    @Override
    protected void addTooltipInfo(ItemStack stack, List<Component> tooltip) {
        tooltip.add((Component)Component.translatable((String)(this.getDescriptionId() + ".desc")).setStyle(StyleType.TOOLTIP_DESC));
        super.addTooltipInfo(stack, tooltip);
    }

    @Override
    public void fillItemCategory(CreativeModeTab.Output toAdd) {
    }

    public Component getName(ItemStack stack) {
        return super.getName(stack).plainCopy().setStyle(StyleType.MESSAGE_SPECIAL);
    }

    public static int getColor(ItemStack stack, int tintIndex) {
        if (tintIndex == 0) {
            short ordinal;
            return ((ordinal = ((Short)stack.getOrDefault(ModDataComponents.MODEL_COLOR, (Object)Short.valueOf((short)-1))).shortValue()) >= 0 && ordinal < ModelColor.values().length ? ModelColor.values()[ordinal] : ModelColor.RED).color;
        }
        return -1;
    }

    public ItemStack setColor(ItemStack stack, ModelColor modelColor) {
        if (stack.is((Item)this)) {
            stack.set(ModDataComponents.MODEL_COLOR, (Object)((short)modelColor.ordinal()));
        }
        return stack;
    }

    public ItemStack getRandomItemStack() {
        return this.getRandomItemStack(1);
    }

    public ItemStack getRandomItemStack(int count) {
        return this.resetColor(new ItemStack((ItemLike)this, count));
    }

    public ItemStack resetColor(ItemStack stack) {
        return this.setColor(stack, ModelColor.getRandom());
    }

    public ItemStack finishUsingItem(ItemStack stack, Level world, LivingEntity entity) {
        super.finishUsingItem(stack, world, entity);
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            EffectHelper.addRandomEffect((Player)serverPlayer, 6000, true, false, false);
            ModTriggers.eat_lollipop.trigger(serverPlayer);
        }
        return stack;
    }

    public ItemUseAnimation getUseAnimation(ItemStack stack) {
        return ItemUseAnimation.EAT;
    }

    @Override
    public ItemStack onDelayedLoot(ItemStack stack, LootContext context) {
        return this.resetColor(stack);
    }

    public static enum ModelColor {
        YELLOW(14469140),
        PURPLE(5584316),
        GREEN(4174479),
        MAGENTA(11154876),
        RED(12334416),
        ORANGE(16756224);

        private final int color;

        private ModelColor(int color) {
            this.color = color;
        }

        public static ModelColor getRandom() {
            return ModelColor.values()[Helper.RANDOM.nextInt(ModelColor.values().length)];
        }

        public ItemStack asItemStack() {
            return ModItems.lollipop.setColor(new ItemStack((ItemLike)ModItems.lollipop), this);
        }
    }
}

