/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.List;
import java.util.function.BooleanSupplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.EntityTeleportEvent;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.helper.SpawnHelper;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.item.ItemGeneric;
import ovh.corail.tombstone.registry.ModTriggers;

public abstract class ItemMagicDust
extends ItemGeneric {
    protected ItemMagicDust(String name, BooleanSupplier supplierEnabled) {
        super(name, supplierEnabled);
    }

    public Component getName(ItemStack stack) {
        return super.getName(stack).plainCopy().setStyle(StyleType.MESSAGE_SPECIAL);
    }

    @Override
    protected void addTooltipInfo(ItemStack stack, List<Component> tooltip) {
        tooltip.add((Component)Component.translatable((String)"item.tombstone.dust_of_vanishing.desc").setStyle(StyleType.TOOLTIP_DESC));
        tooltip.add((Component)Component.translatable((String)"item.tombstone.dust_of_vanishing.use").setStyle(StyleType.TOOLTIP_USE));
        super.addTooltipInfo(stack, tooltip);
    }

    public InteractionResult use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (stack.is((Item)this)) {
            if (EntityHelper.hasGlobalItemCooldown(player, stack)) {
                return InteractionResult.CONSUME;
            }
            if (!level.isClientSide()) {
                Vec3 posVec = player.position();
                Vec3 lookVec = new Vec3(player.getLookAngle().x, 0.0, player.getLookAngle().z).normalize();
                level.playSound(null, posVec.x, posVec.y, posVec.z, SoundEvents.FIRE_EXTINGUISH, SoundSource.PLAYERS, 0.5f, 0.5f);
                ServerLevel targetWorld = (ServerLevel)level;
                Location spawnPos = this.findBackwardLocation(targetWorld, posVec, lookVec, 8.0);
                if ((spawnPos.isOrigin() || ((EntityTeleportEvent)NeoForge.EVENT_BUS.post((Event)new EntityTeleportEvent((Entity)player, (double)spawnPos.getX(), (double)spawnPos.getY(), (double)spawnPos.getZ()))).isCanceled()) && !(spawnPos = this.findBackwardLocation(targetWorld, posVec, lookVec, 3.0)).isOrigin() && ((EntityTeleportEvent)NeoForge.EVENT_BUS.post((Event)new EntityTeleportEvent((Entity)player, (double)spawnPos.getX(), (double)spawnPos.getY(), (double)spawnPos.getZ()))).isCanceled()) {
                    spawnPos = Location.ORIGIN;
                }
                if (spawnPos.isOrigin()) {
                    spawnPos = new Location((Entity)player);
                } else {
                    Helper.teleport(player, spawnPos, targetWorld);
                }
                player.resetFallDistance();
                this.onTeleportBackward((ServerPlayer)player, posVec, lookVec, spawnPos);
                ModTriggers.use_vanishing.trigger((ServerPlayer)player);
                if (!player.getAbilities().instabuild) {
                    stack.shrink(1);
                }
                EntityHelper.setGlobalItemCooldown(player, this, 200);
            }
            return InteractionResult.SUCCESS;
        }
        return super.use(level, player, hand);
    }

    protected abstract void onTeleportBackward(ServerPlayer var1, Vec3 var2, Vec3 var3, Location var4);

    public InteractionResult interactLivingEntity(ItemStack stack, Player player, LivingEntity target, InteractionHand hand) {
        return InteractionResult.FAIL;
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        if (EntityHelper.isValidPlayer(context.getPlayer())) {
            return this.use(context.getLevel(), context.getPlayer(), context.getHand());
        }
        return InteractionResult.FAIL;
    }

    private Location findBackwardLocation(ServerLevel level, Vec3 posVec, Vec3 lookVec, double range) {
        return new SpawnHelper(level, BlockPos.containing((Position)posVec.subtract(lookVec.x * range, 0.0, lookVec.z * range))).findSafePlace(2, true);
    }
}

