/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import ovh.corail.tombstone.helper.ProxyHelper;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.item.ItemGeneric;
import ovh.corail.tombstone.registry.ModDataComponents;

public class ItemReadableScroll
extends ItemGeneric {
    public ItemReadableScroll() {
        super("readable_scroll", ItemReadableScroll.getBuilder().stacksTo(1).fireResistant());
    }

    @Override
    protected void addTooltipInfo(ItemStack stack, List<Component> tooltip) {
        MutableComponent author = Component.translatable((String)("readable_scroll." + this.getContentId(stack) + ".author"));
        if (!author.getString().isEmpty()) {
            tooltip.add((Component)Component.translatable((String)"readable_scroll.by_author", (Object[])new Object[]{author}).setStyle(StyleType.INFO));
        }
        tooltip.add((Component)Component.translatable((String)"readable_scroll.read_info").setStyle(StyleType.TOOLTIP_USE));
        super.addTooltipInfo(stack, tooltip);
    }

    @Override
    public void fillItemCategory(CreativeModeTab.Output toAdd) {
    }

    public void inventoryTick(ItemStack stack, ServerLevel serverLevel, Entity entity, @Nullable EquipmentSlot slot) {
        if (stack.is((Item)this) && TimeHelper.atInterval((Level)serverLevel, 100) && this.getContentId(stack).isEmpty()) {
            stack.shrink(1);
        }
        super.inventoryTick(stack, serverLevel, entity, slot);
    }

    public Component getName(ItemStack stack) {
        return Component.translatable((String)"readable_scroll.title", (Object[])new Object[]{Component.translatable((String)("readable_scroll." + this.getContentId(stack) + ".title")), this.getContentPart(stack)}).setStyle(StyleType.MESSAGE_SPECIAL);
    }

    public InteractionResult use(Level level, Player player, InteractionHand hand) {
        if (level.isClientSide) {
            ItemStack stack = player.getItemInHand(hand);
            if (stack.is((Item)this)) {
                ProxyHelper.openReadableScrollScreen(this.getContentId(stack), this.getContentPart(stack));
            }
            return InteractionResult.CONSUME;
        }
        return InteractionResult.SUCCESS;
    }

    public ItemStack createScroll(String title, int part) {
        ItemStack stack = new ItemStack((ItemLike)this);
        this.setContent(stack, title, part);
        return stack;
    }

    public void setContent(ItemStack stack, String title, int part) {
        stack.set(ModDataComponents.CONTENT_ID, (Object)title);
        stack.set(ModDataComponents.CONTENT_PART, (Object)part);
    }

    public String getContentId(ItemStack stack) {
        return (String)stack.getOrDefault(ModDataComponents.CONTENT_ID, (Object)"");
    }

    public int getContentPart(ItemStack stack) {
        return (Integer)stack.getOrDefault(ModDataComponents.CONTENT_PART, (Object)1);
    }
}

