/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootContext;
import org.jetbrains.annotations.Nullable;
import ovh.corail.tombstone.api.item.ISoulConsumer;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.LootHelper;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.item.ItemScroll;
import ovh.corail.tombstone.loot.IDelayedNBTLoot;
import ovh.corail.tombstone.registry.ModDataComponents;
import ovh.corail.tombstone.registry.ModStats;
import ovh.corail.tombstone.registry.ModTriggers;

public class ItemScrollOfKnowledge
extends ItemScroll
implements IDelayedNBTLoot {
    public ItemScrollOfKnowledge() {
        super("scroll_of_knowledge", () -> SharedConfigTombstone.allowed_magic_items.allowScrollOfKnowledge.get());
    }

    @Override
    public Component getName(ItemStack stack) {
        return (Boolean)stack.getOrDefault(ModDataComponents.IS_LOOT_NO_SYNC, (Object)false) != false ? Component.translatable((String)(this.getDescriptionId() + ".loot")).setStyle(StyleType.MESSAGE_SPECIAL) : super.getName(stack);
    }

    @Override
    public void fillItemCategory(CreativeModeTab.Output toAdd) {
        if (this.isEnabled()) {
            toAdd.accept(new ItemStack((ItemLike)this));
            toAdd.accept(this.createWithXp(2000));
        }
    }

    @Override
    protected void addTooltipInfo(ItemStack stack, List<Component> tooltip) {
        if (!this.isEnchanted(stack)) {
            this.addItemDesc(tooltip, "1", SharedConfigTombstone.magic_item.scrollOfKnowledgeLoss.get());
            this.addItemUse(tooltip, "1", new Object[0]);
        } else {
            this.addItemDesc(tooltip, "2", new Object[0]);
            this.addInfo(tooltip, LangKey.MESSAGE_STORED_EXPERIENCE, this.getStoredXp(stack));
            this.addItemUse(tooltip, "2", new Object[0]);
        }
        super.addTooltipInfo(stack, tooltip);
    }

    @Override
    public boolean isEnchanted(ItemStack stack) {
        return this.getStoredXp(stack) > 0;
    }

    @Override
    public ISoulConsumer.ConsumeResult setEnchant(Level level, BlockPos gravePos, ServerPlayer player, ItemStack stack, int soulStrength) {
        float knowledgeLoss = (float)(100 - (Integer)SharedConfigTombstone.magic_item.scrollOfKnowledgeLoss.get()) / 100.0f;
        boolean valid = this.setStoredXp(stack, (int)((float)EntityHelper.getPlayerTotalXp((Player)player) * knowledgeLoss));
        if (valid) {
            player.experienceLevel = 0;
            player.totalExperience = 0;
            player.experienceProgress = 0.0f;
            player.lastSentExp = -1;
            return ISoulConsumer.ConsumeResult.success((Component)LangKey.MESSAGE_LOSE_EXPERIENCE_SUCCESS.getText(new Object[0]), 1);
        }
        return ISoulConsumer.ConsumeResult.fail((Component)LangKey.MESSAGE_LOSE_EXPERIENCE_FAILED.getText(new Object[0]));
    }

    @Override
    protected boolean doEffects(ServerLevel world, ServerPlayer player, ItemStack stack, @Nullable LivingEntity target) {
        int erdosFragments;
        int i;
        int storedXp;
        ServerPlayer targetPlayer = Optional.ofNullable(target).filter(EntityHelper::isValidServerPlayer).map(ServerPlayer.class::cast).orElse(player);
        if (!targetPlayer.equals((Object)player)) {
            ModTriggers.cast_on_ally.trigger(player);
        }
        if ((storedXp = this.getStoredXp(stack)) > (i = Integer.MAX_VALUE - targetPlayer.totalExperience)) {
            LangKey.MESSAGE_EARN_EXPERIENCE_FAILED.sendMessage(player, new Object[0]);
            return false;
        }
        if (((Boolean)stack.getOrDefault(ModDataComponents.IS_LOOT_NO_SYNC, (Object)false)).booleanValue() && (erdosFragments = EntityHelper.getCustomStat(targetPlayer, ModStats.ERDOS_FRAGMENTS)) > 0 && erdosFragments < 4) {
            LootHelper.rewardReadableScroll(targetPlayer, LootHelper.ReadableScrollType.ERDOS_FRAGMENTS, ++erdosFragments);
            storedXp /= 2;
            LangKey.MESSAGE_ERDOS_FRAGMENTS_PARTIAL_XP.sendMessage(targetPlayer, StyleType.MESSAGE_SPECIAL, new Object[0]);
        }
        EntityHelper.setPlayerXp((Player)targetPlayer, EntityHelper.getPlayerTotalXp((Player)targetPlayer) + storedXp);
        LangKey.MESSAGE_EARN_EXPERIENCE_SUCCESS.sendMessage(targetPlayer, new Object[0]);
        ModTriggers.use_knowledge.trigger(player);
        return true;
    }

    public int getStoredXp(ItemStack stack) {
        return Math.max((Integer)stack.getOrDefault(ModDataComponents.STORED_XP, (Object)0), 0);
    }

    public boolean setStoredXp(ItemStack stack, int xp) {
        if (stack.is((Item)this) && xp > 0) {
            stack.set(ModDataComponents.STORED_XP, (Object)xp);
            return true;
        }
        return false;
    }

    @Override
    protected boolean isTargetForCasting(Player player, @Nullable LivingEntity target) {
        return EntityHelper.isValidPlayer((Entity)target);
    }

    @Override
    public ItemStack onDelayedLoot(ItemStack stack, LootContext context) {
        stack.set(ModDataComponents.STORED_XP, (Object)(Helper.RANDOM.nextInt((Integer)ConfigTombstone.loot.maxXpLostPage.get()) + 1));
        stack.set(ModDataComponents.IS_LOOT_NO_SYNC, (Object)true);
        return stack;
    }

    public ItemStack createWithXp(int xp) {
        ItemStack stack = new ItemStack((ItemLike)this);
        stack.set(ModDataComponents.STORED_XP, (Object)xp);
        stack.set(ModDataComponents.IS_LOOT_NO_SYNC, (Object)true);
        return stack;
    }
}

