/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import com.mojang.datafixers.util.Either;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiRecord;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import org.jetbrains.annotations.Nullable;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.GlobalClock;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.helper.ProxyHelper;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.helper.WorldHelper;
import ovh.corail.tombstone.item.ItemGeneric;
import ovh.corail.tombstone.registry.ModDataComponents;
import ovh.corail.tombstone.registry.ModTags;

public abstract class ItemSearchable
extends ItemGeneric {
    protected ItemSearchable(String name, BooleanSupplier supplierEnabled) {
        super(name, ItemSearchable.getBuilder().stacksTo(1).fireResistant(), supplierEnabled);
    }

    @Override
    protected void addTooltipInfo(ItemStack stack, List<Component> tooltip) {
        this.addItemDesc(tooltip);
        if (ProxyHelper.getClientPlayer().map(player -> !this.isInVillageRange((Player)player, stack)).orElse(true).booleanValue()) {
            this.addItemDistance(tooltip, this.getCurrentTarget(stack));
        }
        this.addItemUse(tooltip, this.isTargetFound(stack) ? "2" : "1", new Object[0]);
        super.addTooltipInfo(stack, tooltip);
    }

    public Component getName(ItemStack stack) {
        return super.getName(stack).plainCopy().setStyle(StyleType.MESSAGE_SPECIAL);
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        if (EntityHelper.isValidPlayer(context.getPlayer()) && this.isTargetFound(stack) && this.isInVillageRange(context.getPlayer(), stack) && context.getClickedPos().equals((Object)this.getCurrentTarget(stack).getPos())) {
            if (!context.getPlayer().level().isClientSide()) {
                this.giveReward((ServerPlayer)context.getPlayer(), context.getClickedPos());
                stack.shrink(1);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public void inventoryTick(ItemStack stack, ServerLevel serverLevel, Entity entity, @Nullable EquipmentSlot slot) {
        if (EntityHelper.isValidPlayer(entity)) {
            ServerPlayer player = (ServerPlayer)entity;
            if (this.getCurrentTarget(stack).isOrigin()) {
                if (ModDataComponents.hasTimer(GlobalClock.INSTANCE.getTime((Level)player.level()), stack, ModDataComponents.COOLDOWN_TIME_NO_SYNC, 1200)) {
                    return;
                }
                assert (player.getServer() != null);
                int d1 = (Helper.RANDOM.nextBoolean() ? -400 : 400) + Helper.RANDOM.nextInt(401) - 200;
                int d2 = Helper.RANDOM.nextInt(1001) - 500;
                boolean inverse = Helper.RANDOM.nextBoolean();
                Location loc = (Location)WorldHelper.findNearestStructure(player.getServer().overworld(), player.blockPosition().offset(inverse ? d2 : d1, 0, inverse ? d1 : d2), ModTags.Structures.vanilla_villages, false).getLeft();
                if (loc.isOrigin()) {
                    stack.set(ModDataComponents.COOLDOWN_TIME_NO_SYNC, (Object)(GlobalClock.INSTANCE.getTime((Level)player.level()) + 1200L));
                } else {
                    ModDataComponents.setLocation(stack, loc);
                }
            } else if (!this.isTargetFound(stack) && this.isInVillageRange((Player)player, stack) && Helper.RANDOM.nextInt(10) == 0) {
                BlockPos villageCenter = this.getCurrentTarget(stack).getPos();
                Stream pois = player.level().getPoiManager().getInSquare(poiType -> poiType.is(this.getTargetType()), villageCenter, 64, PoiManager.Occupancy.ANY);
                Either<TagKey<Block>, Block> matcher = this.getTargetMatcher();
                Optional<BlockPos> targetPos = pois.map(PoiRecord::getPos).filter(pos -> {
                    BlockState state = player.level().getBlockState(pos);
                    return (Boolean)matcher.map(arg_0 -> ((BlockState)state).is(arg_0), b -> state.getBlock() == b);
                }).min(Comparator.comparingDouble(pos -> pos.distSqr((Vec3i)villageCenter)));
                if (targetPos.isPresent()) {
                    stack.set(ModDataComponents.TARGET_FOUND, (Object)true);
                    ModDataComponents.setLocation(stack, new Location(targetPos.get(), (Level)player.level()));
                } else {
                    @Nullable Block forcedBlock = this.getTargetForcedBlock();
                    if (forcedBlock != null) {
                        BlockPos placeAt = player.level().getHeightmapPos(Heightmap.Types.WORLD_SURFACE, villageCenter);
                        player.level().setBlock(placeAt, this.getTargetForcedBlock().defaultBlockState(), 3);
                        stack.set(ModDataComponents.TARGET_FOUND, (Object)true);
                        ModDataComponents.setLocation(stack, new Location(placeAt, (Level)player.level()));
                    } else {
                        ModDataComponents.removeLocation(stack);
                    }
                }
            }
        }
        super.inventoryTick(stack, serverLevel, entity, slot);
    }

    public boolean isTargetFound(ItemStack stack) {
        return (Boolean)stack.getOrDefault(ModDataComponents.TARGET_FOUND, (Object)false);
    }

    public Location getCurrentTarget(ItemStack stack) {
        return ModDataComponents.getLocation(stack);
    }

    public boolean isInVillageRange(Player player, ItemStack stack) {
        double dz;
        if (!player.level().dimension().equals(Level.OVERWORLD)) {
            return false;
        }
        Location targetLocation = this.getCurrentTarget(stack);
        if (targetLocation.isOrigin()) {
            return false;
        }
        double dx = (double)targetLocation.x + 0.5 - player.getX();
        return dx * dx + (dz = (double)targetLocation.z + 0.5 - player.getZ()) * dz < 900.0;
    }

    protected abstract void giveReward(ServerPlayer var1, BlockPos var2);

    protected abstract ResourceKey<PoiType> getTargetType();

    protected abstract Either<TagKey<Block>, Block> getTargetMatcher();

    @Nullable
    protected abstract Block getTargetForcedBlock();

    public abstract String getMessageToDisplay(Player var1, ItemStack var2);
}

