/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraft.world.level.block.entity.TickingBlockEntity;
import net.minecraft.world.level.chunk.LevelChunk;
import org.jetbrains.annotations.Nullable;
import ovh.corail.tombstone.api.item.ISoulConsumer;
import ovh.corail.tombstone.capability.TBPlayerCapabilityHandler;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.helper.CallbackHandler;
import ovh.corail.tombstone.helper.EffectHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.helper.SpawnHelper;
import ovh.corail.tombstone.helper.WorldHelper;
import ovh.corail.tombstone.item.ItemTablet;
import ovh.corail.tombstone.registry.ModDataComponents;
import ovh.corail.tombstone.registry.ModTriggers;

public class ItemTabletOfCupidity
extends ItemTablet {
    public ItemTabletOfCupidity() {
        super("tablet_of_cupidity", () -> SharedConfigTombstone.allowed_magic_items.allowTabletOfCupidity.get());
    }

    @Override
    protected void addTooltipInfo(ItemStack stack, List<Component> tooltip) {
        this.addItemDesc(tooltip);
        this.addItemDesc(tooltip, this.isAncient(stack) ? "_ancient" : "_not_ancient", new Object[0]);
        this.addItemUse(tooltip, this.isEnchanted(stack) ? "2" : "1", new Object[0]);
        super.addTooltipInfo(stack, tooltip);
    }

    @Override
    public boolean isEnchanted(ItemStack stack) {
        return stack.is((Item)this) && (Boolean)stack.getOrDefault(ModDataComponents.ENCHANTED, (Object)false) != false;
    }

    @Override
    public ISoulConsumer.ConsumeResult setEnchant(Level level, BlockPos gravePos, ServerPlayer player, ItemStack stack, int soulStrength) {
        if (stack.is((Item)this)) {
            stack.set(ModDataComponents.ENCHANTED, (Object)true);
            if (!this.isAncient(stack) && soulStrength > 1) {
                stack.set(ModDataComponents.ANCIENT, (Object)true);
                return ISoulConsumer.ConsumeResult.success(2);
            }
            return ISoulConsumer.ConsumeResult.success(1);
        }
        return ISoulConsumer.ConsumeResult.fail();
    }

    @Override
    protected boolean doEffects(ServerLevel world, ServerPlayer player, ItemStack stack, @Nullable LivingEntity target) {
        Location spawnPos;
        boolean isAncient = this.isAncient(stack);
        BlockPos spawnerPos = Helper.getRandomInList(new CopyOnWriteArrayList(world.blockEntityTickers).stream().filter(tileTicker -> {
            try {
                ChestBlockEntity chestBlockEntity;
                BlockEntity blockEntity = ((LevelChunk.BoundTickingBlockEntity)((LevelChunk.RebindableTickingBlockEntityWrapper)tileTicker).ticker).blockEntity;
                return !isAncient && blockEntity instanceof SpawnerBlockEntity || blockEntity instanceof ChestBlockEntity && (chestBlockEntity = (ChestBlockEntity)blockEntity).getLootTable() != null;
            }
            catch (Throwable throwable) {
                return false;
            }
        }).map(TickingBlockEntity::getPos).collect(Collectors.toList())).orElse(null);
        if (spawnerPos != null && WorldHelper.isValidPos((Level)world, spawnerPos) && !(spawnPos = new SpawnHelper(world, spawnerPos).findSpawnPlace()).isOrigin()) {
            CallbackHandler.addFastCallback(() -> {
                ServerPlayer newPlayer = Helper.teleport(player, spawnPos, world);
                LangKey.MESSAGE_TELEPORT_SUCCESS.sendMessage(newPlayer, new Object[0]);
                if (isAncient) {
                    EffectHelper.addRandomEffect((Player)newPlayer, 6000, true, false, true);
                } else {
                    TBPlayerCapabilityHandler.rewardAlignment(newPlayer, (Integer)ConfigTombstone.alignment.pointsTabletOfCupidity.get());
                    EffectHelper.addRandomEffect((Player)newPlayer, 1200, true, true, false);
                    if (Helper.RANDOM.nextInt(5) == 0 && world.getLevelData().getDifficulty() != Difficulty.PEACEFUL) {
                        IntStream.range(0, Helper.RANDOM.nextInt(3) + 1).forEach(i -> Helper.spawnRandomMob(world, spawnPos.getPos()));
                    }
                }
                ModTriggers.use_magic_tablet.trigger(newPlayer);
            });
            return true;
        }
        LangKey.MESSAGE_TABLET_SEARCH_FAILED.sendMessage(player, new Object[0]);
        return false;
    }
}

