/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootContext;
import ovh.corail.tombstone.api.item.ISoulConsumer;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.helper.EffectHelper;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.InventoryHelper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.ProxyHelper;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.item.ItemGeneric;
import ovh.corail.tombstone.loot.IDelayedNBTLoot;
import ovh.corail.tombstone.registry.ModDataComponents;
import ovh.corail.tombstone.registry.ModPerks;
import ovh.corail.tombstone.registry.ModTriggers;

public class ItemVoodooPoppet
extends ItemGeneric
implements ISoulConsumer,
IDelayedNBTLoot {
    public ItemVoodooPoppet() {
        super("voodoo_poppet", ItemVoodooPoppet.getBuilder().stacksTo(1).fireResistant(), () -> SharedConfigTombstone.allowed_magic_items.allowVoodooPoppet.get());
    }

    @Override
    protected void addTooltipInfo(ItemStack stack, List<Component> tooltip) {
        this.addItemDesc(tooltip);
        boolean enchanted = this.isEnchanted(stack);
        this.addItemUse(tooltip, enchanted ? "2" : "1", new Object[0]);
        if (enchanted) {
            ProxyHelper.getClientPlayer().ifPresent(player -> tooltip.add((Component)ModPerks.witch_doctor.getCurrentBonusInfo(EntityHelper.getPerkLevelWithBonus(player, ModPerks.witch_doctor)).copy().withStyle(StyleType.INFO)));
        }
        super.addTooltipInfo(stack, tooltip);
    }

    @Override
    public void fillItemCategory(CreativeModeTab.Output toAdd) {
        if (this.isEnabled()) {
            toAdd.accept(new ItemStack((ItemLike)this));
            toAdd.accept(this.createEnchantedStack());
        }
    }

    public Component getName(ItemStack stack) {
        Component name = super.getName(stack);
        return (this.isEnchanted(stack) ? LangKey.MESSAGE_ENCHANTED_ITEM.getText(name) : name.plainCopy()).setStyle(StyleType.MESSAGE_SPECIAL);
    }

    @Override
    public boolean isFoil(ItemStack stack) {
        return this.isEnchanted(stack);
    }

    @Override
    public boolean isEnchanted(ItemStack stack) {
        return stack.is((Item)this) && (Boolean)stack.getOrDefault(ModDataComponents.ENCHANTED, (Object)false) != false;
    }

    @Override
    public ISoulConsumer.ConsumeResult setEnchant(Level level, BlockPos gravePos, ServerPlayer player, ItemStack stack, int soulStrength) {
        if (stack.is((Item)this)) {
            stack.set(ModDataComponents.ENCHANTED, (Object)true);
            return ISoulConsumer.ConsumeResult.success((Component)LangKey.MESSAGE_ENCHANT_VOODOO_POPPET_SUCCESS.getText(new Object[0]), 1);
        }
        return ISoulConsumer.ConsumeResult.fail();
    }

    public boolean preventDeath(ServerPlayer player) {
        ItemStack voodooPoppet = InventoryHelper.findFirstInInventory((Player)player, p -> p.is((Item)this) && this.isEnchanted((ItemStack)p));
        if (voodooPoppet.isEmpty()) {
            return false;
        }
        int chance = EntityHelper.getPerkLevelWithBonus((Player)player, ModPerks.witch_doctor) * 10;
        if (Helper.RANDOM.nextInt(100) >= chance) {
            voodooPoppet.shrink(1);
        }
        LangKey.sendSystemMessage(player, (Component)LangKey.MESSAGE_VOODOO_POPPET_PREVENT_DEATH.getText(StyleType.MESSAGE_SPECIAL, new Object[0]));
        ModTriggers.prevent_death_voodoo_poppet.trigger(player);
        player.setHealth(player.getMaxHealth());
        EffectHelper.clearBadEffects((LivingEntity)player);
        return true;
    }

    public ItemStack createEnchantedStack() {
        ItemStack stack = new ItemStack((ItemLike)this);
        stack.set(ModDataComponents.ENCHANTED, (Object)true);
        return stack;
    }

    @Override
    public ItemStack onDelayedLoot(ItemStack stack, LootContext context) {
        stack.set(ModDataComponents.ENCHANTED, (Object)true);
        return stack;
    }
}

