/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.loot;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import ovh.corail.tombstone.helper.NBTHelper;
import ovh.corail.tombstone.registry.ModDataComponents;
import ovh.corail.tombstone.registry.ModItems;
import ovh.corail.tombstone.registry.ModLootFunctions;

public class AsGiftFunction
extends LootItemConditionalFunction {
    public static final ResourceLocation RL = ResourceLocation.fromNamespaceAndPath((String)"tombstone", (String)"as_gift");
    public static final MapCodec<AsGiftFunction> CODEC = RecordCodecBuilder.mapCodec(b -> AsGiftFunction.commonFields((RecordCodecBuilder.Instance)b).apply((Applicative)b, AsGiftFunction::new));

    protected AsGiftFunction(List<LootItemCondition> conditionsIn) {
        super(conditionsIn);
    }

    public LootItemFunctionType<AsGiftFunction> getType() {
        return ModLootFunctions.AS_GIFT;
    }

    protected ItemStack run(ItemStack stack, LootContext context) {
        if (!stack.isEmpty()) {
            ItemStack gift = new ItemStack((ItemLike)ModItems.gift);
            CompoundTag compoundTag = ModDataComponents.getCompoundTag(gift);
            NBTHelper.getListOrCreate(compoundTag, "Items").add((Object)NBTHelper.saveItemStack(context.getLevel().registryAccess(), stack));
            return gift;
        }
        return stack;
    }

    public static class Builder
    extends LootItemConditionalFunction.Builder<Builder> {
        protected Builder getThis() {
            return this;
        }

        public LootItemFunction build() {
            return new AsGiftFunction(this.getConditions());
        }
    }
}

