/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.loot;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantable;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import org.jetbrains.annotations.Nullable;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LootHelper;
import ovh.corail.tombstone.helper.RandomWeightedItem;
import ovh.corail.tombstone.helper.RegistryHelper;
import ovh.corail.tombstone.registry.ModDataComponents;
import ovh.corail.tombstone.registry.ModLootFunctions;
import ovh.corail.tombstone.registry.ModTags;

public class EnchantedEquipmentFunction
extends LootItemConditionalFunction {
    public static final ResourceLocation RL = ResourceLocation.fromNamespaceAndPath((String)"tombstone", (String)"enchanted_equipment");
    public static final MapCodec<EnchantedEquipmentFunction> CODEC = RecordCodecBuilder.mapCodec(b -> EnchantedEquipmentFunction.commonFields((RecordCodecBuilder.Instance)b).and((App)Codec.STRING.fieldOf("type").orElse((Object)Type.ARMOR.name()).forGetter(g -> g.type.name())).and((App)Codec.INT.fieldOf("enchanted_chance").orElse((Object)50).forGetter(g -> g.enchantedChance)).and((App)Codec.INT.fieldOf("random_enchantability").orElse((Object)0).forGetter(g -> g.randomEnchantability)).apply((Applicative)b, (conditions, typeString, enchantedChance, enchantability) -> new EnchantedEquipmentFunction((List<LootItemCondition>)conditions, Type.valueOf(typeString), (int)enchantedChance, (int)enchantability)));
    private final Type type;
    private final int enchantedChance;
    private final int randomEnchantability;

    protected EnchantedEquipmentFunction(List<LootItemCondition> conditionsIn, Type type, int enchantedChance, int randomEnchantability) {
        super(conditionsIn);
        this.type = type;
        this.enchantedChance = enchantedChance;
        this.randomEnchantability = randomEnchantability;
    }

    public LootItemFunctionType<? extends LootItemConditionalFunction> getType() {
        return ModLootFunctions.ENCHANTED_EQUIPMENT;
    }

    protected ItemStack run(ItemStack stack, LootContext context) {
        RandomWeightedItem generator = (Boolean)ConfigTombstone.loot.onlyVanillaForEquipment.get() != false || Helper.RANDOM.nextInt(100) < 80 ? LootHelper.getItemGenerator(this.type == Type.WEAPON ? ModTags.Items.lootable_vanilla_weapon : (this.type == Type.ARMOR ? ModTags.Items.lootable_vanilla_armor : ModTags.Items.lootable_vanilla_tool)) : LootHelper.getItemGenerator(this.type == Type.WEAPON ? ModTags.Items.lootable_weapon : (this.type == Type.ARMOR ? ModTags.Items.lootable_armor : ModTags.Items.lootable_tool));
        ItemStack result = ItemStack.EMPTY;
        for (int i = 0; i < 3; ++i) {
            ResourceLocation registryName;
            @Nullable Item item = generator.getRandomItem();
            if (item == null || (registryName = RegistryHelper.getRegistryName(item)) == null || ((List)ConfigTombstone.loot.deniedModidForEquipment.get()).contains(registryName.getNamespace())) continue;
            result = new ItemStack((ItemLike)item);
            break;
        }
        if (result.isEmpty()) {
            result = new ItemStack((ItemLike)Items.ENCHANTED_BOOK);
        }
        if (Helper.RANDOM.nextInt(5) == 0) {
            result.set(ModDataComponents.SOULBOUND, (Object)true);
        }
        int enchantability = Optional.ofNullable((Enchantable)result.get(DataComponents.ENCHANTABLE)).map(Enchantable::value).orElse(0);
        if (result.isEnchantable() && enchantability > 0 && Helper.RANDOM.nextInt(100) < this.enchantedChance) {
            EnchantmentHelper.setEnchantments((ItemStack)result, (ItemEnchantments)Helper.getRandomEnchantments(enchantability + Helper.RANDOM.nextInt(this.randomEnchantability), result, Helper.RANDOM.nextInt(4) + 1, (Level)context.getLevel()));
        }
        return result;
    }

    public static enum Type {
        WEAPON,
        ARMOR,
        TOOL;

    }

    public static class Builder
    extends LootItemConditionalFunction.Builder<Builder> {
        private final Type type;
        private final int enchantedChance;
        private final int randomEnchantability;

        public Builder(Type type, int enchantedChance, int randomEnchantability) {
            this.type = type;
            this.enchantedChance = enchantedChance;
            this.randomEnchantability = randomEnchantability;
        }

        protected Builder getThis() {
            return this;
        }

        public LootItemFunction build() {
            return new EnchantedEquipmentFunction(this.getConditions(), this.type, this.enchantedChance, this.randomEnchantability);
        }
    }
}

