/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.loot;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.NumberProviders;
import ovh.corail.tombstone.capability.TBPlayerCapabilityHandler;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.registry.ModLootFunctions;

public class KnowledgeRewardFunction
extends LootItemConditionalFunction {
    public static final ResourceLocation RL = ResourceLocation.fromNamespaceAndPath((String)"tombstone", (String)"reward_knowledge");
    public static final MapCodec<KnowledgeRewardFunction> CODEC = RecordCodecBuilder.mapCodec(b -> KnowledgeRewardFunction.commonFields((RecordCodecBuilder.Instance)b).and((App)NumberProviders.CODEC.fieldOf("points").orElse((Object)new ConstantValue(0.0f)).forGetter(g -> g.points)).apply((Applicative)b, KnowledgeRewardFunction::new));
    private final NumberProvider points;

    protected KnowledgeRewardFunction(List<LootItemCondition> conditions, NumberProvider points) {
        super(conditions);
        this.points = points;
    }

    protected ItemStack run(ItemStack stack, LootContext context) {
        if (EntityHelper.isValidServerPlayer((Entity)context.getParameter(LootContextParams.THIS_ENTITY))) {
            ServerPlayer player = (ServerPlayer)context.getParameter(LootContextParams.THIS_ENTITY);
            TBPlayerCapabilityHandler.rewardKnowledge(player, this.points.getInt(context));
        }
        return ItemStack.EMPTY;
    }

    public LootItemFunctionType<KnowledgeRewardFunction> getType() {
        return ModLootFunctions.KNOWLEDGE_REWARD;
    }
}

