/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.loot;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import ovh.corail.tombstone.helper.LootHelper;
import ovh.corail.tombstone.helper.RandomWeightedItem;
import ovh.corail.tombstone.registry.ModLootFunctions;

public class RandomInTagFunction
extends LootItemConditionalFunction {
    public static final ResourceLocation RL = ResourceLocation.fromNamespaceAndPath((String)"tombstone", (String)"random_in_tag");
    public static final MapCodec<RandomInTagFunction> CODEC = RecordCodecBuilder.mapCodec(b -> RandomInTagFunction.commonFields((RecordCodecBuilder.Instance)b).and((App)ResourceLocation.CODEC.fieldOf("rl").orElse((Object)ItemTags.DECORATED_POT_SHERDS.location()).forGetter(g -> g.tagRL)).apply((Applicative)b, RandomInTagFunction::new));
    private final ResourceLocation tagRL;

    protected RandomInTagFunction(List<LootItemCondition> conditionsIn, ResourceLocation tagRL) {
        super(conditionsIn);
        this.tagRL = tagRL;
    }

    public LootItemFunctionType<? extends LootItemConditionalFunction> getType() {
        return ModLootFunctions.RANDOM_IN_TAG;
    }

    protected ItemStack run(ItemStack stack, LootContext context) {
        TagKey tagKey = BuiltInRegistries.ITEM.getTags().map(HolderSet.Named::key).filter(t -> this.tagRL.equals((Object)t.location())).findFirst().orElse(null);
        if (tagKey != null) {
            RandomWeightedItem generator = LootHelper.getItemGenerator((TagKey<Item>)tagKey);
            return Optional.ofNullable(generator.getRandomItem()).map(ItemStack::new).orElse(ItemStack.EMPTY);
        }
        return ItemStack.EMPTY;
    }

    public static class Builder
    extends LootItemConditionalFunction.Builder<Builder> {
        private final ResourceLocation tagRL;

        public Builder(TagKey<Item> tagKey) {
            this.tagRL = tagKey.location();
        }

        protected Builder getThis() {
            return this;
        }

        public LootItemFunction build() {
            return new RandomInTagFunction(this.getConditions(), this.tagRL);
        }
    }
}

