/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.mixin;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import ovh.corail.tombstone.block.BlockGraveBase;
import ovh.corail.tombstone.helper.CallbackHandler;
import ovh.corail.tombstone.helper.DeathHandler;
import ovh.corail.tombstone.helper.SerializationHelper;
import ovh.corail.tombstone.registry.ModBlocks;

@Mixin(value={LevelChunk.class}, priority=1031)
public class LevelChunkMixin {
    @Inject(method={"setBlockState"}, at={@At(value="HEAD")})
    private void methodSetBlockState(BlockPos pos, BlockState newState, int flag, CallbackInfoReturnable<BlockState> callbackInfoReturnable) {
        LevelChunk thisLevelChunk = (LevelChunk)this;
        Level level = thisLevelChunk.getLevel();
        if (level == null) {
            return;
        }
        BlockState oldState = level.getBlockState(pos);
        Block oldBlock = oldState.getBlock();
        if (!level.isClientSide() && (ModBlocks.isPlayerGrave(oldBlock) && !ModBlocks.isPlayerGrave(newState.getBlock()) || ModBlocks.isDecorativeGrave(oldBlock) && !ModBlocks.isDecorativeGrave(newState.getBlock()))) {
            if (DeathHandler.INSTANCE.canRemovePlayerGrave(level, pos)) {
                ((BlockGraveBase)oldBlock).onDrop(level, pos, oldState);
            } else {
                Optional.ofNullable(level.getBlockEntity(pos)).ifPresent(grave -> {
                    CompoundTag oldNbt = grave.saveWithFullMetadata((HolderLookup.Provider)level.registryAccess());
                    CallbackHandler.addFastCallback(() -> {
                        level.setBlockAndUpdate(pos, oldState);
                        Optional.ofNullable(level.getBlockEntity(pos)).ifPresent(newGrave -> {
                            newGrave.loadWithComponents(SerializationHelper.convertToValueInput(oldNbt, level.registryAccess()));
                            newGrave.setChanged();
                            level.sendBlockUpdated(pos, newState, oldState, 3);
                        });
                    });
                });
            }
        }
    }
}

