/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.mixin;

import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import ovh.corail.tombstone.capability.FriendlyAnimalHandler;
import ovh.corail.tombstone.entity.SpectralWolf;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.registry.ModEntities;

@Mixin(value={LivingEntity.class})
public class LivingEntityMixin {
    @Inject(method={"canAttack"}, at={@At(value="RETURN")}, cancellable=true)
    private void methodCanAttack(LivingEntity target, CallbackInfoReturnable<Boolean> callbackInfoReturnable) {
        if (((Boolean)callbackInfoReturnable.getReturnValue()).booleanValue() && target != null && EntityHelper.areOwnerOrServants((LivingEntity)this, target)) {
            callbackInfoReturnable.setReturnValue((Object)false);
        }
    }

    @Inject(method={"resolvePlayerResponsibleForDamage"}, at={@At(value="RETURN")}, cancellable=true)
    private void methodResolvePlayerResponsibleForDamage(DamageSource source, CallbackInfoReturnable<Player> callbackInfoReturnable) {
        Entity entity;
        if (callbackInfoReturnable.getReturnValue() == null && (entity = source.getEntity()) instanceof LivingEntity) {
            LivingEntity causingEntity = (LivingEntity)entity;
            Player owner = null;
            if (EntityHelper.isServant((Entity)causingEntity)) {
                owner = EntityHelper.getServantOwner((Entity)causingEntity).orElse(null);
            } else if (causingEntity.getType() == ModEntities.spectral_wolf) {
                owner = ((SpectralWolf)causingEntity).getOwner().orElse(null);
            } else if (FriendlyAnimalHandler.hasCapability((Entity)causingEntity)) {
                owner = FriendlyAnimalHandler.getOwner((Entity)causingEntity).orElse(null);
            }
            if (owner != null) {
                ((LivingEntity)this).setLastHurtByPlayer(owner, 100);
                callbackInfoReturnable.setReturnValue((Object)owner);
            }
        }
    }
}

