/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.mixin;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import ovh.corail.tombstone.capability.SpellCasterHandler;
import ovh.corail.tombstone.helper.EffectHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.registry.ModEffects;

@Mixin(value={LivingEntityRenderer.class})
public abstract class LivingEntityRendererMixin<T extends LivingEntity, S extends LivingEntityRenderState, M extends EntityModel<? super S>>
extends EntityRenderer<T, S>
implements RenderLayerParent<S, M> {
    @Shadow
    M model;
    private PoseStack poseStack;
    private MultiBufferSource bufferSource;
    private float r;
    private float g;
    private float b;
    private float a;
    private boolean isSpellCasting;
    private float bob;
    private boolean isGhostly;
    private int overlayCoords;

    private LivingEntityRendererMixin(EntityRendererProvider.Context context) {
        super(context);
    }

    @Inject(method={"extractRenderState"}, at={@At(value="HEAD")})
    private void methodExtractRenderState(T entity, S renderState, float partialTicks, CallbackInfo callbackInfo) {
        this.isSpellCasting = SpellCasterHandler.hasCapability(entity) && SpellCasterHandler.isCasting(entity);
        this.bob = this.isSpellCasting ? (float)((LivingEntity)entity).tickCount + Minecraft.getInstance().level.tickRateManager().tickrate() : 0.0f;
        this.isGhostly = entity.getType() == EntityType.PLAYER && (entity.hasEffect(ModEffects.ghostly_shape) || EffectHelper.isUnstableIntangibilityActive(entity));
        this.overlayCoords = this.isGhostly ? LivingEntityRenderer.getOverlayCoords(renderState, (float)0.0f) : OverlayTexture.NO_OVERLAY;
    }

    @Inject(method={"render"}, at={@At(value="HEAD")})
    private void render(S renderState, PoseStack poseStack, MultiBufferSource bufferSource, int light, CallbackInfo callbackInfo) {
        if (this.isGhostly) {
            this.poseStack = poseStack;
            this.bufferSource = bufferSource;
            this.r = 0.5f;
            this.g = 1.0f;
            this.b = 1.0f;
            this.a = 0.3f;
        }
    }

    @ModifyVariable(method={"render"}, at=@At(value="STORE"), ordinal=0)
    private RenderType renderType(RenderType renderType) {
        M m;
        if (this.isSpellCasting && (m = this.model) instanceof HumanoidModel) {
            HumanoidModel humanoidModel = (HumanoidModel)m;
            humanoidModel.rightArm.z = 0.0f;
            humanoidModel.rightArm.x = -5.0f;
            humanoidModel.leftArm.z = 0.0f;
            humanoidModel.leftArm.x = 5.0f;
            humanoidModel.rightArm.xRot = Mth.cos((float)(this.bob * 0.6662f)) * 0.25f;
            humanoidModel.leftArm.xRot = Mth.cos((float)(this.bob * 0.6662f)) * 0.25f;
            humanoidModel.rightArm.zRot = 2.3561945f;
            humanoidModel.leftArm.zRot = -2.3561945f;
            humanoidModel.rightArm.yRot = 0.0f;
            humanoidModel.leftArm.yRot = 0.0f;
            this.isSpellCasting = false;
        }
        if (renderType != null && this.poseStack != null) {
            this.model.renderToBuffer(this.poseStack, this.bufferSource.getBuffer(renderType), 0xF000F0, this.overlayCoords, Helper.convertColorToInt(this.a, this.r, this.g, this.b));
            this.poseStack = null;
            this.bufferSource = null;
            this.isGhostly = false;
            return null;
        }
        return renderType;
    }
}

