/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.mixin;

import com.mojang.authlib.GameProfile;
import java.util.Optional;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec2;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.registry.ModEffects;
import ovh.corail.tombstone.registry.ModPerks;

@Mixin(value={LocalPlayer.class})
public abstract class LocalPlayerMixin
extends AbstractClientPlayer {
    private LocalPlayerMixin(ClientLevel clientLevel, GameProfile gameProfile) {
        super(clientLevel, gameProfile);
    }

    @Redirect(method={"modifyInput"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/player/LocalPlayer;modifyInputSpeedForSquareMovement(Lnet/minecraft/world/phys/Vec2;)Lnet/minecraft/world/phys/Vec2;"), require=1)
    private Vec2 methodModifyInput(Vec2 vec2) {
        if (vec2.lengthSquared() > 0.0f) {
            boolean isCrouching = this.isCrouching();
            boolean isVisuallyCrawling = this.isVisuallyCrawling();
            if (isCrouching && !isVisuallyCrawling) {
                LocalPlayer player = (LocalPlayer)this;
                float discretionModifier = Optional.ofNullable(player.getEffect(ModEffects.discretion)).map(effect -> Float.valueOf((float)(effect.getAmplifier() + 1) * 0.1f)).orElse(Float.valueOf(0.0f)).floatValue();
                float shadowWalkerModifier = (float)EntityHelper.getPerkLevelWithBonus((Player)player, ModPerks.shadowalker) * 0.1f;
                if (discretionModifier > 0.0f || shadowWalkerModifier > 0.0f) {
                    float oldScale = (float)this.getAttributeValue(Attributes.SNEAKING_SPEED);
                    float sneakingSpeedModifier = Math.clamp((float)this.getAttributeValue(Attributes.SNEAKING_SPEED) + discretionModifier + shadowWalkerModifier, 0.0f, 1.0f);
                    return vec2.scale(sneakingSpeedModifier / oldScale);
                }
            }
        }
        return vec2;
    }
}

