/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.mixin;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.client.renderer.entity.state.PlayerRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import ovh.corail.tombstone.helper.EffectHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.registry.ModEffects;

@Mixin(value={PlayerRenderer.class})
public abstract class PlayerRendererMixin
extends LivingEntityRenderer<AbstractClientPlayer, PlayerRenderState, PlayerModel> {
    private PlayerRendererMixin(EntityRendererProvider.Context context, boolean useSlimModel) {
        super(context, (EntityModel)new PlayerModel(context.bakeLayer(useSlimModel ? ModelLayers.PLAYER_SLIM : ModelLayers.PLAYER), useSlimModel), 0.5f);
    }

    @Inject(method={"renderHand"}, at={@At(value="HEAD")}, cancellable=true)
    private void renderHand(PoseStack poseStack, MultiBufferSource bufferSource, int light, ResourceLocation texture, ModelPart modelPart, boolean useSlimModel, CallbackInfo callbackInfo) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null && (player.hasEffect(ModEffects.ghostly_shape) || EffectHelper.isUnstableIntangibilityActive((LivingEntity)player))) {
            PlayerModel playerModel = (PlayerModel)this.getModel();
            modelPart.resetPose();
            modelPart.visible = true;
            playerModel.leftSleeve.visible = useSlimModel;
            playerModel.rightSleeve.visible = useSlimModel;
            playerModel.leftArm.zRot = -0.1f;
            playerModel.rightArm.zRot = 0.1f;
            modelPart.render(poseStack, bufferSource.getBuffer(RenderType.entityTranslucent((ResourceLocation)texture)), light, OverlayTexture.NO_OVERLAY, Helper.convertColorToInt(0.3f, 0.5f, 1.0f, 1.0f));
            callbackInfo.cancel();
        }
    }
}

