/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.mixin;

import java.util.function.Consumer;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.component.Consumable;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import ovh.corail.tombstone.capability.TBPlayerCapabilityHandler;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.helper.EffectHelper;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.ProxyHelper;
import ovh.corail.tombstone.registry.ModEffects;
import ovh.corail.tombstone.registry.ModPerks;

@Mixin(value={PotionContents.class}, priority=1031)
public class PotionContentsMixin {
    @Inject(method={"onConsume"}, at={@At(value="HEAD")}, cancellable=true)
    private void methodOnConsume(Level level, LivingEntity livingEntity, ItemStack stack, Consumable consumable, CallbackInfo callbackInfo) {
        ServerLevel serverLevel;
        block3: {
            block2: {
                if (!(level instanceof ServerLevel)) break block2;
                serverLevel = (ServerLevel)level;
                if (EntityHelper.isValidServerPlayer((Entity)livingEntity)) break block3;
            }
            return;
        }
        ServerPlayer player = (ServerPlayer)livingEntity;
        float alchemistBonus = 1.0f + (float)EntityHelper.getPerkLevelWithBonus((Player)((ServerPlayer)livingEntity), ModPerks.alchemist) * 0.2f;
        PotionContents potionContents = (PotionContents)this;
        potionContents.forEachEffect(effectInstance -> {
            MobEffect effect = (MobEffect)effectInstance.getEffect().value();
            if (effect.isInstantenous()) {
                effect.applyInstantenousEffect(serverLevel, (Entity)player, (Entity)player, livingEntity, effectInstance.getAmplifier(), 1.0);
            } else {
                if (effect == ModEffects.earthly_garden) {
                    TBPlayerCapabilityHandler.rewardAlignment((ServerPlayer)livingEntity, (Integer)ConfigTombstone.alignment.pointsEarthlyGarden.get());
                }
                if (!EffectHelper.isBadEffect(effect)) {
                    EffectHelper.modifyEffectDuration(effectInstance, e -> Mth.floor((float)((float)e.getDuration() * alchemistBonus)));
                }
                livingEntity.addEffect(effectInstance);
            }
        }, ((Float)stack.getOrDefault(DataComponents.POTION_DURATION_SCALE, (Object)Float.valueOf(1.0f))).floatValue());
        callbackInfo.cancel();
    }

    @Inject(method={"addToTooltip"}, at={@At(value="HEAD")}, cancellable=true)
    private void methodAddToTooltip(Item.TooltipContext context, Consumer<Component> componentConsumer, TooltipFlag tooltipFlag, DataComponentGetter dataComponentGetter, CallbackInfo callbackInfo) {
        ProxyHelper.getClientPlayer().ifPresent(player -> {
            int alchemistLevel = EntityHelper.getPerkLevelWithBonus(player, ModPerks.alchemist);
            if (alchemistLevel > 0) {
                float alchemistBonus = 1.0f + (float)alchemistLevel * 0.2f;
                PotionContents.addPotionTooltip((Iterable)((PotionContents)this).getAllEffects(), (Consumer)componentConsumer, (float)(((Float)dataComponentGetter.getOrDefault(DataComponents.POTION_DURATION_SCALE, (Object)Float.valueOf(1.0f))).floatValue() * alchemistBonus), (float)context.tickRate());
                callbackInfo.cancel();
            }
        });
    }
}

