/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.mixin;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import ovh.corail.tombstone.registry.ModBlocks;
import ovh.corail.tombstone.registry.ModEffects;

@Mixin(value={ServerPlayer.class}, priority=1031)
public abstract class ServerPlayerMixin {
    private static final ThreadLocal<Boolean> IGNORE_XP_INJECTION = ThreadLocal.withInitial(() -> false);

    @Inject(method={"mayInteract"}, at={@At(value="RETURN")}, cancellable=true)
    private void methodMayInteract(ServerLevel level, BlockPos pos, CallbackInfoReturnable<Boolean> callbackInfoReturnable) {
        if (!((Boolean)callbackInfoReturnable.getReturnValue()).booleanValue() && ModBlocks.isAnyGrave(level.getBlockState(pos).getBlock())) {
            callbackInfoReturnable.setReturnValue((Object)true);
        }
    }

    @Inject(method={"giveExperiencePoints"}, at={@At(value="HEAD")}, cancellable=true)
    public void methodGiveExperiencePoints(int amount, CallbackInfo callbackInfo) {
        ServerPlayer serverPlayer = (ServerPlayer)this;
        if (amount > 0 && !IGNORE_XP_INJECTION.get().booleanValue() && serverPlayer.isAlive() && serverPlayer.hasEffect(ModEffects.remanence)) {
            MobEffectInstance effectInstance = serverPlayer.getEffect(ModEffects.remanence);
            assert (effectInstance != null);
            int xpBonus = Math.round((float)amount * 0.1f * (float)(effectInstance.getAmplifier() + 1));
            if (xpBonus <= 0) {
                return;
            }
            IGNORE_XP_INJECTION.set(true);
            serverPlayer.giveExperiencePoints(amount + xpBonus);
            IGNORE_XP_INJECTION.set(false);
            callbackInfo.cancel();
        }
    }
}

