/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.network;

import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import ovh.corail.tombstone.helper.CooldownHandler;
import ovh.corail.tombstone.helper.GlobalClock;
import ovh.corail.tombstone.helper.NBTHelper;
import ovh.corail.tombstone.helper.ProxyHelper;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.network.PacketHandler;
import ovh.corail.tombstone.network.SMessagePlayerPreference;

public record CMessageLogin(TimeHelper.SpecialEvent specialEvent, long globalTime, ListTag clientCooldowns) implements CustomPacketPayload
{
    static final StreamCodec<RegistryFriendlyByteBuf, CMessageLogin> STREAM_CODEC = StreamCodec.ofMember(CMessageLogin::encode, CMessageLogin::decode);
    static final CustomPacketPayload.Type<CMessageLogin> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"tombstone", (String)"login"));

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    static CMessageLogin decode(RegistryFriendlyByteBuf buf) {
        return new CMessageLogin(TimeHelper.SpecialEvent.byId(buf.readShort()), buf.readLong(), Optional.ofNullable(buf.readNbt()).flatMap(tag -> NBTHelper.getListOrEmpty(tag, "tb_cooldowns")).orElse(new ListTag()));
    }

    static void encode(CMessageLogin msg, RegistryFriendlyByteBuf buf) {
        buf.writeShort(msg.specialEvent.ordinal());
        buf.writeLong(msg.globalTime());
        CompoundTag compound = new CompoundTag();
        compound.put("tb_cooldowns", (Tag)msg.clientCooldowns());
        buf.writeNbt((Tag)compound);
    }

    static void handle(CMessageLogin msg, IPayloadContext ctx) {
        TimeHelper.setSpecialEvent(msg.specialEvent);
        GlobalClock.INSTANCE.setClientTime(msg.globalTime());
        CooldownHandler.INSTANCE.updateAllClientCooldowns(msg.clientCooldowns());
        PacketHandler.sendToServer(new SMessagePlayerPreference(ProxyHelper.initPlayerPreference(), true));
    }
}

