/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.network;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.Nullable;
import ovh.corail.tombstone.capability.TBPlayerCapabilityHandler;
import ovh.corail.tombstone.helper.NBTHelper;
import ovh.corail.tombstone.helper.ProxyHelper;
import ovh.corail.tombstone.perk.Perk;

public record CMessagePlayerCapSyncPerks(Map<Perk, Integer> perks) implements CustomPacketPayload
{
    static final StreamCodec<RegistryFriendlyByteBuf, CMessagePlayerCapSyncPerks> STREAM_CODEC = StreamCodec.ofMember(CMessagePlayerCapSyncPerks::encode, CMessagePlayerCapSyncPerks::decode);
    static final CustomPacketPayload.Type<CMessagePlayerCapSyncPerks> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"tombstone", (String)"player_cap_sync_perks"));

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    static CMessagePlayerCapSyncPerks decode(RegistryFriendlyByteBuf buf) {
        HashMap<Perk, Integer> perks = new HashMap<Perk, Integer>();
        @Nullable CompoundTag tag = buf.readNbt();
        if (tag != null) {
            NBTHelper.readPerks(perks, tag);
        }
        return new CMessagePlayerCapSyncPerks(perks);
    }

    static void encode(CMessagePlayerCapSyncPerks msg, RegistryFriendlyByteBuf buf) {
        CompoundTag tag = new CompoundTag();
        NBTHelper.writePerks(msg.perks, tag);
        buf.writeNbt((Tag)tag);
    }

    static void handle(CMessagePlayerCapSyncPerks msg, IPayloadContext ctx) {
        ProxyHelper.getClientPlayer().ifPresent(player -> TBPlayerCapabilityHandler.setPerks(player, msg.perks));
    }
}

