/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.network;

import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import ovh.corail.tombstone.capability.ProtectedEntityHandler;
import ovh.corail.tombstone.helper.ProxyHelper;

public record CMessageProtection(int entityId, boolean active) implements CustomPacketPayload
{
    static final StreamCodec<RegistryFriendlyByteBuf, CMessageProtection> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, CMessageProtection::entityId, (StreamCodec)ByteBufCodecs.BOOL, CMessageProtection::active, CMessageProtection::new);
    static final CustomPacketPayload.Type<CMessageProtection> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"tombstone", (String)"protection"));

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    static void handle(CMessageProtection msg, IPayloadContext ctx) {
        ProxyHelper.getClientWorld().map(level -> level.getEntity(msg.entityId)).filter(LivingEntity.class::isInstance).map(LivingEntity.class::cast).filter(ProtectedEntityHandler::hasCapability).ifPresent(entity -> ProtectedEntityHandler.apply(entity, msg.active));
    }
}

