/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.network;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import ovh.corail.tombstone.registry.ModBlocks;
import ovh.corail.tombstone.registry.ModItems;

public record SMessageResetPerk(Vec3 vec, Direction direction, BlockPos pos, boolean isInside) implements CustomPacketPayload
{
    static final StreamCodec<RegistryFriendlyByteBuf, SMessageResetPerk> STREAM_CODEC = StreamCodec.ofMember(SMessageResetPerk::encode, SMessageResetPerk::decode);
    static final CustomPacketPayload.Type<SMessageResetPerk> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"tombstone", (String)"reset_perk"));

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    static SMessageResetPerk decode(RegistryFriendlyByteBuf buf) {
        return new SMessageResetPerk(new Vec3(buf.readDouble(), buf.readDouble(), buf.readDouble()), Direction.values()[Mth.clamp((int)(buf.readByte() & 0xFF), (int)0, (int)(Direction.values().length - 1))], buf.readBlockPos(), buf.readBoolean());
    }

    static void encode(SMessageResetPerk msg, RegistryFriendlyByteBuf buf) {
        buf.writeDouble(msg.vec.x);
        buf.writeDouble(msg.vec.y);
        buf.writeDouble(msg.vec.z);
        buf.writeByte(msg.direction.ordinal());
        buf.writeBlockPos(msg.pos);
        buf.writeBoolean(msg.isInside);
    }

    static void handle(SMessageResetPerk msg, IPayloadContext ctx) {
        BlockState state;
        BlockHitResult result;
        ServerPlayer player = (ServerPlayer)ctx.player();
        if (player.getMainHandItem().is((Item)ModItems.ankh_of_prayer) && (result = new BlockHitResult(msg.vec, msg.direction, msg.pos, msg.isInside)).distanceTo((Entity)player) < 25.0 && ModBlocks.DECORATIVE_GRAVES.containsValue((state = player.level().getBlockState(msg.pos)).getBlock())) {
            state.useItemOn(player.getMainHandItem(), (Level)player.level(), (Player)player, InteractionHand.MAIN_HAND, result);
        }
    }
}

